/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.exceptions;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.exceptions.ExceptionCode;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestFailureReason;

public class RequestFailureException
extends RequestExecutionException {
    public final ConsistencyLevel consistency;
    public final int received;
    public final int blockFor;
    public final Map<InetAddress, RequestFailureReason> failureReasonByEndpoint;

    protected RequestFailureException(ExceptionCode code, ConsistencyLevel consistency, int received, int blockFor, Map<InetAddress, RequestFailureReason> failureReasonByEndpoint) {
        super(code, String.format("Operation failed - received %d responses and %d failures", received, failureReasonByEndpoint.size()));
        this.consistency = consistency;
        this.received = received;
        this.blockFor = blockFor;
        this.failureReasonByEndpoint = new HashMap<InetAddress, RequestFailureReason>(failureReasonByEndpoint);
    }
}

