/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.coyote.AbstractProcessor;
import org.apache.coyote.ActionCode;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.ByteBufferHolder;
import org.apache.coyote.Constants;
import org.apache.coyote.ErrorState;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.UpgradeToken;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProcessor<S>
extends AbstractProcessor<S> {
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.coyote.ajp");
    protected static final byte[] endMessageArray;
    protected static final byte[] endAndCloseMessageArray;
    protected static final byte[] flushMessageArray;
    protected static final byte[] pongMessageArray;
    protected final byte[] getBodyMessageArray;
    private final int outputMaxChunkSize;
    protected final AjpMessage requestHeaderMessage;
    protected final AjpMessage responseMessage;
    private int responseMsgPos = -1;
    protected final AjpMessage bodyMessage;
    protected final MessageBytes bodyBytes = MessageBytes.newInstance();
    private int bufferedWriteSize = 65536;
    private final LinkedBlockingDeque<ByteBufferHolder> bufferedWrites = new LinkedBlockingDeque();
    protected final MessageBytes tmpMB = MessageBytes.newInstance();
    protected final MessageBytes certificates = MessageBytes.newInstance();
    protected boolean endOfStream = false;
    protected boolean empty = true;
    protected boolean first = true;
    private boolean waitingForBodyMessage = false;
    protected boolean replay = false;
    private boolean swallowResponse = false;
    protected boolean finished = false;
    protected long bytesWritten = 0L;
    protected boolean ajpFlush = true;
    protected int keepAliveTimeout = -1;
    protected boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    protected String requiredSecret = null;
    protected String clientCertProvider = null;

    public AbstractAjpProcessor(int packetSize, AbstractEndpoint<S> endpoint) {
        super(endpoint);
        this.outputMaxChunkSize = 8184 + packetSize - 8192;
        this.request.setInputBuffer(new SocketInputBuffer());
        this.requestHeaderMessage = new AjpMessage(packetSize);
        this.responseMessage = new AjpMessage(packetSize);
        this.bodyMessage = new AjpMessage(packetSize);
        AjpMessage getBodyMessage = new AjpMessage(16);
        getBodyMessage.reset();
        getBodyMessage.appendByte(6);
        getBodyMessage.appendInt(8186 + packetSize - 8192);
        getBodyMessage.end();
        this.getBodyMessageArray = new byte[getBodyMessage.getLen()];
        System.arraycopy(getBodyMessage.getBuffer(), 0, this.getBodyMessageArray, 0, getBodyMessage.getLen());
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean ajpFlush) {
        this.ajpFlush = ajpFlush;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int timeout) {
        this.keepAliveTimeout = timeout;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean tomcatAuthentication) {
        this.tomcatAuthentication = tomcatAuthentication;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean tomcatAuthorization) {
        this.tomcatAuthorization = tomcatAuthorization;
    }

    public void setRequiredSecret(String requiredSecret) {
        this.requiredSecret = requiredSecret;
    }

    public String getClientCertProvider() {
        return this.clientCertProvider;
    }

    public void setClientCertProvider(String s) {
        this.clientCertProvider = s;
    }

    @Override
    public final void action(ActionCode actionCode, Object param) {
        switch (actionCode) {
            case CLOSE: {
                try {
                    this.finish();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case COMMIT: {
                if (this.response.isCommitted()) {
                    return;
                }
                try {
                    this.prepareResponse();
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                try {
                    this.flush(false);
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case ACK: {
                break;
            }
            case CLIENT_FLUSH: {
                if (!this.response.isCommitted()) {
                    try {
                        this.prepareResponse();
                    }
                    catch (IOException e) {
                        this.setErrorState(ErrorState.CLOSE_NOW, e);
                        return;
                    }
                }
                try {
                    this.flush(true);
                }
                catch (IOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)param).set(this.getErrorState().isError());
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                break;
            }
            case RESET: {
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                if (this.certificates.isNull()) break;
                ByteChunk certData = this.certificates.getByteChunk();
                X509Certificate[] jsseCerts = null;
                ByteArrayInputStream bais = new ByteArrayInputStream(certData.getBytes(), certData.getStart(), certData.getLength());
                try {
                    CertificateFactory cf = this.clientCertProvider == null ? CertificateFactory.getInstance("X.509") : CertificateFactory.getInstance("X.509", this.clientCertProvider);
                    while (bais.available() > 0) {
                        X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                        if (jsseCerts == null) {
                            jsseCerts = new X509Certificate[]{cert};
                            continue;
                        }
                        X509Certificate[] temp = new X509Certificate[jsseCerts.length + 1];
                        System.arraycopy(jsseCerts, 0, temp, 0, jsseCerts.length);
                        temp[jsseCerts.length] = cert;
                        jsseCerts = temp;
                    }
                }
                catch (CertificateException e) {
                    this.getLog().error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)e);
                    return;
                }
                catch (NoSuchProviderException e) {
                    this.getLog().error((Object)sm.getString("ajpprocessor.certs.fail"), (Throwable)e);
                    return;
                }
                this.request.setAttribute("javax.servlet.request.X509Certificate", jsseCerts);
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                if (!this.request.remoteHost().isNull()) break;
                try {
                    this.request.remoteHost().setString(InetAddress.getByName(this.request.remoteAddr().toString()).getHostName());
                }
                catch (IOException certData) {}
                break;
            }
            case REQ_HOST_ADDR_ATTRIBUTE: {
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (!this.request.localAddr().isNull()) break;
                this.request.localAddr().setString(this.request.localName().toString());
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                ByteChunk bc = (ByteChunk)param;
                int length = bc.getLength();
                this.bodyBytes.setBytes(bc.getBytes(), bc.getStart(), length);
                this.request.setContentLength(length);
                this.first = false;
                this.empty = false;
                this.replay = true;
                this.endOfStream = false;
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)param);
                this.getSocketWrapper().access();
                break;
            }
            case ASYNC_COMPLETE: {
                this.socketWrapper.clearDispatches();
                if (!this.asyncStateMachine.asyncComplete()) break;
                this.endpoint.processSocket(this.socketWrapper, SocketStatus.OPEN_READ, true);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                this.endpoint.processSocket(this.socketWrapper, SocketStatus.OPEN_READ, true);
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (param == null) {
                    return;
                }
                long timeout = (Long)param;
                this.socketWrapper.setTimeout(timeout);
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)param);
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_COMPLETING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isCompleting());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)param).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case ASYNC_POST_PROCESS: {
                this.asyncStateMachine.asyncPostProcess();
                break;
            }
            case UPGRADE: {
                throw new UnsupportedOperationException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
            }
            case COMET_BEGIN: {
                throw new UnsupportedOperationException(sm.getString("ajpprocessor.comet.notsupported"));
            }
            case COMET_END: {
                throw new UnsupportedOperationException(sm.getString("ajpprocessor.comet.notsupported"));
            }
            case COMET_CLOSE: {
                throw new UnsupportedOperationException(sm.getString("ajpprocessor.comet.notsupported"));
            }
            case COMET_SETTIMEOUT: {
                throw new UnsupportedOperationException(sm.getString("ajpprocessor.comet.notsupported"));
            }
            case IS_COMET: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(false);
                break;
            }
            case AVAILABLE: {
                if (this.available()) {
                    this.request.setAvailable(1);
                    break;
                }
                this.request.setAvailable(0);
                break;
            }
            case NB_READ_INTEREST: {
                if (this.endOfStream) break;
                this.registerForEvent(true, false);
                break;
            }
            case NB_WRITE_INTEREST: {
                AtomicBoolean isReady = (AtomicBoolean)param;
                boolean result = this.bufferedWrites.size() == 0 && this.responseMsgPos == -1;
                isReady.set(result);
                if (result) break;
                this.registerForEvent(false, true);
                break;
            }
            case REQUEST_BODY_FULLY_READ: {
                AtomicBoolean result = (AtomicBoolean)param;
                result.set(this.endOfStream);
                break;
            }
            case DISPATCH_READ: {
                this.socketWrapper.addDispatch(DispatchType.NON_BLOCKING_READ);
                break;
            }
            case DISPATCH_WRITE: {
                this.socketWrapper.addDispatch(DispatchType.NON_BLOCKING_WRITE);
                break;
            }
            case DISPATCH_EXECUTE: {
                this.getEndpoint().executeNonBlockingDispatches(this.socketWrapper);
                break;
            }
            case CLOSE_NOW: {
                this.swallowResponse = true;
                if (param instanceof Throwable) {
                    this.setErrorState(ErrorState.CLOSE_NOW, (Throwable)param);
                    break;
                }
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
        }
    }

    @Override
    public AbstractEndpoint.Handler.SocketState asyncDispatch(SocketStatus status) {
        block19: {
            if (status == SocketStatus.OPEN_WRITE && this.response.getWriteListener() != null) {
                try {
                    this.asyncStateMachine.asyncOperation();
                    try {
                        if (!this.hasDataToWrite()) break block19;
                        this.flushBufferedData();
                        if (this.hasDataToWrite()) {
                            this.response.checkRegisterForWrite();
                            return AbstractEndpoint.Handler.SocketState.LONG;
                        }
                    }
                    catch (IOException x) {
                        if (this.getLog().isDebugEnabled()) {
                            this.getLog().debug((Object)"Unable to write async data.", (Throwable)x);
                        }
                        status = SocketStatus.ERROR;
                        this.request.setAttribute("javax.servlet.error.exception", x);
                    }
                }
                catch (IllegalStateException x) {
                    this.registerForEvent(false, true);
                }
            } else if (status == SocketStatus.OPEN_READ && this.request.getReadListener() != null) {
                try {
                    if (this.available()) {
                        this.asyncStateMachine.asyncOperation();
                    }
                }
                catch (IllegalStateException x) {
                    this.registerForEvent(true, false);
                }
            }
        }
        RequestInfo rp = this.request.getRequestProcessor();
        try {
            rp.setStage(3);
            if (!this.getAdapter().asyncDispatch(this.request, this.response, status)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
            this.resetTimeouts();
        }
        catch (InterruptedIOException e) {
            this.setErrorState(ErrorState.CLOSE_NOW, e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable((Throwable)t);
            this.setErrorState(ErrorState.CLOSE_NOW, t);
            this.getLog().error((Object)sm.getString("http11processor.request.process"), t);
        }
        rp.setStage(7);
        if (this.isAsync()) {
            if (this.getErrorState().isError()) {
                this.request.updateCounters();
                return AbstractEndpoint.Handler.SocketState.CLOSED;
            }
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        this.request.updateCounters();
        if (this.getErrorState().isError()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        this.recycle(false);
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<S> socket) throws IOException {
        RequestInfo rp = this.request.getRequestProcessor();
        rp.setStage(1);
        this.socketWrapper = socket;
        this.setupSocket(socket);
        int soTimeout = this.endpoint.getSoTimeout();
        boolean cping = false;
        boolean keptAlive = false;
        while (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            try {
                byte type;
                if (!this.readMessage(this.requestHeaderMessage, !keptAlive)) break;
                if (this.keepAliveTimeout > 0) {
                    this.setTimeout(this.socketWrapper, soTimeout);
                }
                if ((type = this.requestHeaderMessage.getByte()) == 10) {
                    if (this.endpoint.isPaused()) {
                        this.recycle(true);
                        break;
                    }
                    cping = true;
                    try {
                        this.output(pongMessageArray, 0, pongMessageArray.length, true);
                    }
                    catch (IOException e) {
                        this.setErrorState(ErrorState.CLOSE_NOW, e);
                    }
                    this.recycle(false);
                    continue;
                }
                if (type != 2) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((Object)("Unexpected message: " + type));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    break;
                }
                keptAlive = true;
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException e) {
                this.setErrorState(ErrorState.CLOSE_NOW, e);
                break;
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable((Throwable)t);
                this.getLog().debug((Object)sm.getString("ajpprocessor.header.error"), t);
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            if (!this.getErrorState().isError()) {
                rp.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.getLog().debug((Object)sm.getString("ajpprocessor.request.prepare"), t);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (!this.getErrorState().isError() && !cping && this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            cping = false;
            if (!this.getErrorState().isError()) {
                try {
                    rp.setStage(3);
                    this.getAdapter().service(this.request, this.response);
                }
                catch (InterruptedIOException e) {
                    this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.getLog().error((Object)sm.getString("ajpprocessor.request.process"), t);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, t);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.isAsync() && !this.getErrorState().isError()) break;
            if (!this.finished && this.getErrorState().isIoAllowed()) {
                try {
                    this.finish();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable((Throwable)t);
                    this.setErrorState(ErrorState.CLOSE_NOW, t);
                }
            }
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            rp.setStage(6);
            if (this.keepAliveTimeout > 0) {
                this.setTimeout(this.socketWrapper, this.keepAliveTimeout);
            }
            this.recycle(false);
        }
        rp.setStage(7);
        if (this.getErrorState().isError() || this.endpoint.isPaused()) {
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        if (this.isAsync()) {
            return AbstractEndpoint.Handler.SocketState.LONG;
        }
        return AbstractEndpoint.Handler.SocketState.OPEN;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        throw new IllegalStateException(sm.getString("ajpprocessor.ssl.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState event(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.comet.notsupported"));
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketStatus status) throws IOException {
        throw new IOException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public UpgradeToken getUpgradeToken() {
        throw new IllegalStateException(sm.getString("ajpprocessor.httpupgrade.notsupported"));
    }

    @Override
    public void recycle(boolean socketClosing) {
        this.getAdapter().checkRecycled(this.request, this.response);
        this.asyncStateMachine.recycle();
        this.first = true;
        this.endOfStream = false;
        this.waitingForBodyMessage = false;
        this.empty = true;
        this.replay = false;
        this.finished = false;
        this.request.recycle();
        this.response.recycle();
        this.certificates.recycle();
        this.swallowResponse = false;
        this.bytesWritten = 0L;
        this.resetErrorState();
        this.bufferedWrites.clear();
    }

    protected abstract void resetTimeouts();

    protected abstract int output(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected abstract void setupSocket(SocketWrapper<S> var1) throws IOException;

    protected abstract void setTimeout(SocketWrapper<S> var1, int var2) throws IOException;

    protected abstract boolean read(byte[] var1, int var2, int var3, boolean var4) throws IOException;

    protected boolean receive(boolean block) throws IOException {
        this.bodyMessage.reset();
        if (!this.readMessage(this.bodyMessage, block)) {
            return false;
        }
        this.waitingForBodyMessage = false;
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int blen = this.bodyMessage.peekInt();
        if (blen == 0) {
            return false;
        }
        this.bodyMessage.getBodyBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    protected boolean readMessage(AjpMessage message, boolean block) throws IOException {
        int headerLength;
        byte[] buf = message.getBuffer();
        if (!this.read(buf, 0, headerLength = message.getHeaderLength(), block)) {
            return false;
        }
        int messageLength = message.processHeader(true);
        if (messageLength < 0) {
            throw new IOException(sm.getString("ajpmessage.invalidLength", new Object[]{messageLength}));
        }
        if (messageLength == 0) {
            return true;
        }
        if (messageLength > message.getBuffer().length) {
            String msg = sm.getString("ajpprocessor.header.tooLong", new Object[]{messageLength, buf.length});
            this.getLog().error((Object)msg);
            throw new IllegalArgumentException(msg);
        }
        this.read(buf, headerLength, messageLength, true);
        return true;
    }

    @Override
    public final boolean isComet() {
        return false;
    }

    @Override
    public final boolean isUpgrade() {
        return false;
    }

    @Override
    public ByteBuffer getLeftoverInput() {
        return null;
    }

    protected boolean refillReadBuffer(boolean block) throws IOException {
        boolean moreData;
        if (this.replay) {
            this.endOfStream = true;
        }
        if (this.endOfStream) {
            return false;
        }
        if (this.first) {
            this.first = false;
            long contentLength = this.request.getContentLengthLong();
            if (contentLength > 0L) {
                this.waitingForBodyMessage = true;
            } else if (contentLength == 0L) {
                this.endOfStream = true;
                return false;
            }
        }
        if (!this.waitingForBodyMessage) {
            this.output(this.getBodyMessageArray, 0, this.getBodyMessageArray.length, true);
            this.waitingForBodyMessage = true;
        }
        if (!(moreData = this.receive(block)) && !this.waitingForBodyMessage) {
            this.endOfStream = true;
        }
        return moreData;
    }

    protected void prepareRequest() {
        ByteChunk uriBC;
        byte attributeCode;
        boolean isSSL;
        byte methodCode = this.requestHeaderMessage.getByte();
        if (methodCode != -1) {
            String methodName = org.apache.coyote.ajp.Constants.getMethodForCode(methodCode - 1);
            this.request.method().setString(methodName);
        }
        this.requestHeaderMessage.getBytes(this.request.protocol());
        this.requestHeaderMessage.getBytes(this.request.requestURI());
        this.requestHeaderMessage.getBytes(this.request.remoteAddr());
        this.requestHeaderMessage.getBytes(this.request.remoteHost());
        this.requestHeaderMessage.getBytes(this.request.localName());
        this.request.setLocalPort(this.requestHeaderMessage.getInt());
        boolean bl = isSSL = this.requestHeaderMessage.getByte() != 0;
        if (isSSL) {
            this.request.scheme().setString("https");
        }
        MimeHeaders headers = this.request.getMimeHeaders();
        headers.setLimit(this.endpoint.getMaxHeaderCount());
        this.request.getCookies().setLimit(this.getMaxCookieCount());
        boolean contentLengthSet = false;
        int hCount = this.requestHeaderMessage.getInt();
        for (int i = 0; i < hCount; ++i) {
            String hName = null;
            int isc = this.requestHeaderMessage.peekInt();
            int hId = isc & 0xFF;
            MessageBytes vMB = null;
            if (40960 == (isc &= 0xFF00)) {
                this.requestHeaderMessage.getInt();
                hName = org.apache.coyote.ajp.Constants.getHeaderForCode(hId - 1);
                vMB = headers.addValue(hName);
            } else {
                hId = -1;
                this.requestHeaderMessage.getBytes(this.tmpMB);
                ByteChunk bc = this.tmpMB.getByteChunk();
                vMB = headers.addValue(bc.getBuffer(), bc.getStart(), bc.getLength());
            }
            this.requestHeaderMessage.getBytes(vMB);
            if (hId == 8 || hId == -1 && this.tmpMB.equalsIgnoreCase("Content-Length")) {
                long cl = vMB.getLong();
                if (contentLengthSet) {
                    this.response.setStatus(400);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue;
                }
                contentLengthSet = true;
                this.request.setContentLength(cl);
                continue;
            }
            if (hId != 7 && (hId != -1 || !this.tmpMB.equalsIgnoreCase("Content-Type"))) continue;
            ByteChunk bchunk = vMB.getByteChunk();
            this.request.contentType().setBytes(bchunk.getBytes(), bchunk.getOffset(), bchunk.getLength());
        }
        boolean secret = false;
        block18: while ((attributeCode = this.requestHeaderMessage.getByte()) != -1) {
            switch (attributeCode) {
                case 10: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String n = this.tmpMB.toString();
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    String v = this.tmpMB.toString();
                    if (n.equals("AJP_LOCAL_ADDR")) {
                        this.request.localAddr().setString(v);
                        continue block18;
                    }
                    if (n.equals("AJP_REMOTE_PORT")) {
                        try {
                            this.request.setRemotePort(Integer.parseInt(v));
                        }
                        catch (NumberFormatException vMB) {}
                        continue block18;
                    }
                    if (n.equals("AJP_SSL_PROTOCOL")) {
                        this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", v);
                        continue block18;
                    }
                    this.request.setAttribute(n, v);
                    continue block18;
                }
                case 1: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 2: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 3: {
                    if (this.tomcatAuthorization || !this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.request.getRemoteUser());
                        this.request.setRemoteUserNeedsAuthorization(this.tomcatAuthorization);
                        continue block18;
                    }
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    continue block18;
                }
                case 4: {
                    if (this.tomcatAuthentication) {
                        this.requestHeaderMessage.getBytes(this.tmpMB);
                        continue block18;
                    }
                    this.requestHeaderMessage.getBytes(this.request.getAuthType());
                    continue block18;
                }
                case 5: {
                    this.requestHeaderMessage.getBytes(this.request.queryString());
                    continue block18;
                }
                case 6: {
                    this.requestHeaderMessage.getBytes(this.request.instanceId());
                    continue block18;
                }
                case 7: {
                    this.requestHeaderMessage.getBytes(this.certificates);
                    continue block18;
                }
                case 8: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.cipher_suite", this.tmpMB.toString());
                    continue block18;
                }
                case 9: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    this.request.setAttribute("javax.servlet.request.ssl_session_id", this.tmpMB.toString());
                    continue block18;
                }
                case 11: {
                    this.request.setAttribute("javax.servlet.request.key_size", this.requestHeaderMessage.getInt());
                    continue block18;
                }
                case 13: {
                    this.requestHeaderMessage.getBytes(this.request.method());
                    continue block18;
                }
                case 12: {
                    this.requestHeaderMessage.getBytes(this.tmpMB);
                    if (this.requiredSecret == null) continue block18;
                    secret = true;
                    if (this.tmpMB.equals(this.requiredSecret)) continue block18;
                    this.response.setStatus(403);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                    continue block18;
                }
            }
        }
        if (this.requiredSecret != null && !secret) {
            this.response.setStatus(403);
            this.setErrorState(ErrorState.CLOSE_CLEAN, null);
        }
        if ((uriBC = this.request.requestURI().getByteChunk()).startsWithIgnoreCase("http", 0)) {
            int pos = uriBC.indexOf("://", 0, 3, 4);
            int uriBCStart = uriBC.getStart();
            int slashPos = -1;
            if (pos != -1) {
                byte[] uriB = uriBC.getBytes();
                slashPos = uriBC.indexOf('/', pos + 3);
                if (slashPos == -1) {
                    slashPos = uriBC.getLength();
                    this.request.requestURI().setBytes(uriB, uriBCStart + pos + 1, 1);
                } else {
                    this.request.requestURI().setBytes(uriB, uriBCStart + slashPos, uriBC.getLength() - slashPos);
                }
                MessageBytes hostMB = headers.setValue("host");
                hostMB.setBytes(uriB, uriBCStart + pos + 3, slashPos - pos - 3);
            }
        }
        MessageBytes valueMB = this.request.getMimeHeaders().getValue("host");
        this.parseHost(valueMB);
        if (this.getErrorState().isError()) {
            this.getAdapter().log(this.request, this.response, 0L);
        }
    }

    @Override
    protected void populateHost() {
        this.request.setServerPort(this.request.getLocalPort());
        try {
            this.request.serverName().duplicate(this.request.localName());
        }
        catch (IOException e) {
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, e);
        }
    }

    protected void prepareResponse() throws IOException {
        long contentLength;
        String contentLanguage;
        MessageBytes methodMB;
        this.response.setCommitted(true);
        this.tmpMB.recycle();
        this.responseMsgPos = -1;
        this.responseMessage.reset();
        this.responseMessage.appendByte(4);
        int statusCode = this.response.getStatus();
        if (statusCode < 200 || statusCode == 204 || statusCode == 205 || statusCode == 304) {
            this.swallowResponse = true;
        }
        if ((methodMB = this.request.method()).equals("HEAD")) {
            this.swallowResponse = true;
        }
        this.responseMessage.appendInt(statusCode);
        String message = null;
        if (Constants.USE_CUSTOM_STATUS_MSG_IN_HEADER && HttpMessages.isSafeInHttpHeader(this.response.getMessage())) {
            message = this.response.getMessage();
        }
        if (message == null) {
            message = HttpMessages.getInstance(this.response.getLocale()).getMessage(this.response.getStatus());
        }
        if (message == null) {
            message = Integer.toString(this.response.getStatus());
        }
        this.tmpMB.setString(message);
        this.responseMessage.appendBytes(this.tmpMB);
        MimeHeaders headers = this.response.getMimeHeaders();
        String contentType = this.response.getContentType();
        if (contentType != null) {
            headers.setValue("Content-Type").setString(contentType);
        }
        if ((contentLanguage = this.response.getContentLanguage()) != null) {
            headers.setValue("Content-Language").setString(contentLanguage);
        }
        if ((contentLength = this.response.getContentLengthLong()) >= 0L) {
            headers.setValue("Content-Length").setLong(contentLength);
        }
        int numHeaders = headers.size();
        this.responseMessage.appendInt(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            MessageBytes hN = headers.getName(i);
            int hC = org.apache.coyote.ajp.Constants.getResponseAjpIndex(hN.toString());
            if (hC > 0) {
                this.responseMessage.appendInt(hC);
            } else {
                this.responseMessage.appendBytes(hN);
            }
            MessageBytes hV = headers.getValue(i);
            this.responseMessage.appendBytes(hV);
        }
        this.responseMessage.end();
        this.output(this.responseMessage.getBuffer(), 0, this.responseMessage.getLen(), true);
    }

    protected void flush(boolean explicit) throws IOException {
        if (this.ajpFlush && explicit && !this.finished) {
            this.output(flushMessageArray, 0, flushMessageArray.length, true);
        }
    }

    protected void finish() throws IOException {
        if (!this.response.isCommitted()) {
            try {
                this.prepareResponse();
            }
            catch (IOException e) {
                this.setErrorState(ErrorState.CLOSE_NOW, e);
                return;
            }
        }
        if (this.finished) {
            return;
        }
        this.finished = true;
        if (this.waitingForBodyMessage || this.first && this.request.getContentLengthLong() > 0L) {
            this.refillReadBuffer(true);
        }
        if (this.getErrorState().isError()) {
            this.output(endAndCloseMessageArray, 0, endAndCloseMessageArray.length, true);
        } else {
            this.output(endMessageArray, 0, endMessageArray.length, true);
        }
    }

    private boolean available() {
        if (this.endOfStream) {
            return false;
        }
        if (this.empty) {
            try {
                this.refillReadBuffer(false);
            }
            catch (IOException timeout) {
                return true;
            }
        }
        return !this.empty;
    }

    private void writeData(ByteChunk chunk) throws IOException {
        boolean blocking;
        this.socketWrapper.access();
        boolean bl = blocking = this.response.getWriteListener() == null;
        if (!blocking) {
            this.flushBufferedData();
        }
        int len = chunk.getLength();
        int off = 0;
        while (this.responseMsgPos == -1 && len > 0) {
            int thisTime = len;
            if (thisTime > this.outputMaxChunkSize) {
                thisTime = this.outputMaxChunkSize;
            }
            this.responseMessage.reset();
            this.responseMessage.appendByte(3);
            this.responseMessage.appendBytes(chunk.getBytes(), chunk.getOffset() + off, thisTime);
            this.responseMessage.end();
            this.writeResponseMessage(blocking);
            len -= thisTime;
            off += thisTime;
        }
        this.bytesWritten += (long)off;
        if (len > 0 && !blocking) {
            this.addToBuffers(chunk.getBuffer(), off, len);
        }
    }

    private void addToBuffers(byte[] buf, int offset, int length) {
        ByteBufferHolder holder = this.bufferedWrites.peekLast();
        if (holder == null || holder.isFlipped() || holder.getBuf().remaining() < length) {
            ByteBuffer buffer = ByteBuffer.allocate(Math.max(this.bufferedWriteSize, length));
            holder = new ByteBufferHolder(buffer, false);
            this.bufferedWrites.add(holder);
        }
        holder.getBuf().put(buf, offset, length);
    }

    private boolean hasDataToWrite() {
        return this.responseMsgPos != -1 || this.bufferedWrites.size() > 0;
    }

    private void flushBufferedData() throws IOException {
        if (this.responseMsgPos > -1) {
            this.writeResponseMessage(false);
        }
        while (this.responseMsgPos == -1 && this.bufferedWrites.size() > 0) {
            Iterator<ByteBufferHolder> holders = this.bufferedWrites.iterator();
            ByteBufferHolder holder = holders.next();
            holder.flip();
            ByteBuffer buffer = holder.getBuf();
            int initialBufferSize = buffer.remaining();
            while (this.responseMsgPos == -1 && buffer.remaining() > 0) {
                this.transferToResponseMsg(buffer);
                this.writeResponseMessage(false);
            }
            this.bytesWritten += (long)(initialBufferSize - buffer.remaining());
            if (buffer.remaining() != 0) continue;
            holders.remove();
        }
    }

    private void transferToResponseMsg(ByteBuffer buffer) {
        int thisTime = buffer.remaining();
        if (thisTime > this.outputMaxChunkSize) {
            thisTime = this.outputMaxChunkSize;
        }
        this.responseMessage.reset();
        this.responseMessage.appendByte(3);
        buffer.get(this.responseMessage.getBuffer(), this.responseMessage.pos, thisTime);
        this.responseMessage.end();
    }

    private void writeResponseMessage(boolean block) throws IOException {
        int len = this.responseMessage.getLen();
        int written = 1;
        if (this.responseMsgPos == -1) {
            this.responseMsgPos = 0;
        }
        while (written > 0 && this.responseMsgPos < len) {
            written = this.output(this.responseMessage.getBuffer(), this.responseMsgPos, len - this.responseMsgPos, block);
            this.responseMsgPos += written;
        }
        if (this.responseMsgPos == len) {
            this.responseMsgPos = -1;
        }
    }

    static {
        AjpMessage endMessage = new AjpMessage(16);
        endMessage.reset();
        endMessage.appendByte(5);
        endMessage.appendByte(1);
        endMessage.end();
        endMessageArray = new byte[endMessage.getLen()];
        System.arraycopy(endMessage.getBuffer(), 0, endMessageArray, 0, endMessage.getLen());
        AjpMessage endAndCloseMessage = new AjpMessage(16);
        endAndCloseMessage.reset();
        endAndCloseMessage.appendByte(5);
        endAndCloseMessage.appendByte(0);
        endAndCloseMessage.end();
        endAndCloseMessageArray = new byte[endAndCloseMessage.getLen()];
        System.arraycopy(endAndCloseMessage.getBuffer(), 0, endAndCloseMessageArray, 0, endAndCloseMessage.getLen());
        AjpMessage flushMessage = new AjpMessage(16);
        flushMessage.reset();
        flushMessage.appendByte(3);
        flushMessage.appendInt(0);
        flushMessage.appendByte(0);
        flushMessage.end();
        flushMessageArray = new byte[flushMessage.getLen()];
        System.arraycopy(flushMessage.getBuffer(), 0, flushMessageArray, 0, flushMessage.getLen());
        AjpMessage pongMessage = new AjpMessage(16);
        pongMessage.reset();
        pongMessage.appendByte(9);
        pongMessage.end();
        pongMessageArray = new byte[pongMessage.getLen()];
        System.arraycopy(pongMessage.getBuffer(), 0, pongMessageArray, 0, pongMessage.getLen());
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            if (!AbstractAjpProcessor.this.response.isCommitted()) {
                try {
                    AbstractAjpProcessor.this.prepareResponse();
                }
                catch (IOException e) {
                    AbstractAjpProcessor.this.setErrorState(ErrorState.CLOSE_NOW, e);
                }
            }
            if (!AbstractAjpProcessor.this.swallowResponse) {
                try {
                    AbstractAjpProcessor.this.writeData(chunk);
                }
                catch (IOException ioe) {
                    AbstractAjpProcessor.this.response.action(ActionCode.CLOSE_NOW, ioe);
                    throw ioe;
                }
            }
            return chunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return AbstractAjpProcessor.this.bytesWritten;
        }
    }

    protected class SocketInputBuffer
    implements InputBuffer {
        protected SocketInputBuffer() {
        }

        @Override
        public int doRead(ByteChunk chunk, Request req) throws IOException {
            if (AbstractAjpProcessor.this.endOfStream) {
                return -1;
            }
            if (AbstractAjpProcessor.this.empty && !AbstractAjpProcessor.this.refillReadBuffer(true)) {
                return -1;
            }
            ByteChunk bc = AbstractAjpProcessor.this.bodyBytes.getByteChunk();
            chunk.setBytes(bc.getBuffer(), bc.getStart(), bc.getLength());
            AbstractAjpProcessor.this.empty = true;
            return chunk.getLength();
        }
    }
}

