/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw.border;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.flexdock.demos.raw.border.DockablePanel;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.BorderManager;
import org.flexdock.docking.defaults.DefaultDockingPort;

public class DemoBorderManager
implements BorderManager {
    private Border dummyBorder = new TitledBorder("");

    DemoBorderManager() {
    }

    public void managePortNullChild(DockingPort port) {
        this.setBorder(port, this.dummyBorder);
    }

    public void managePortSimpleChild(DockingPort port) {
        if (port == null || port.getDockedComponent() == null) {
            return;
        }
        Component docked = port.getDockedComponent();
        this.setBorder(docked, null);
        this.setBorder(port, this.getDesiredBorder(docked));
    }

    public void managePortSplitChild(DockingPort port) {
        if (port == null || !(port.getDockedComponent() instanceof JSplitPane)) {
            return;
        }
        JSplitPane split = (JSplitPane)port.getDockedComponent();
        this.clearSplitPaneBorder(split);
        Component left = split.getLeftComponent();
        Component right = split.getRightComponent();
        Border leftBorder = this.getDesiredBorder(left);
        Border rightBorder = this.getDesiredBorder(right);
        this.setBorder(port, null);
        this.setBorder(left, null);
        this.setBorder(right, null);
        this.setBorder(this.getDocked(left), leftBorder);
        this.setBorder(this.getDocked(right), rightBorder);
    }

    public void managePortTabbedChild(DockingPort port) {
        this.setBorder(port, null);
        if (port == null || !(port.getDockedComponent() instanceof JTabbedPane)) {
            return;
        }
        JTabbedPane tabs = (JTabbedPane)port.getDockedComponent();
        int tc = tabs.getTabCount();
        for (int i = 0; i < tc; ++i) {
            this.setBorder(tabs.getComponentAt(i), (Border)new TitledBorder(tabs.getTitleAt(i)));
        }
    }

    private void clearSplitPaneBorder(JSplitPane split) {
        BasicSplitPaneDivider divider;
        split.setBorder(null);
        if (split.getUI() instanceof BasicSplitPaneUI && (divider = ((BasicSplitPaneUI)split.getUI()).getDivider()) != null && divider.getBorder() != null) {
            divider.setBorder(null);
        }
    }

    private void setBorder(DockingPort port, Border border) {
        if (port instanceof JComponent) {
            ((JComponent)((Object)port)).setBorder(border);
        }
    }

    private void setBorder(Component cmp, Border border) {
        if (cmp instanceof JComponent) {
            ((JComponent)cmp).setBorder(border);
        }
    }

    private Border getDesiredBorder(Component cmp) {
        if (cmp instanceof DefaultDockingPort) {
            cmp = ((DefaultDockingPort)cmp).getDockedComponent();
        }
        if (cmp instanceof DockablePanel) {
            String title = ((DockablePanel)cmp).getDockable().getDockingProperties().getDockableDesc();
            return new TitledBorder(title);
        }
        return this.dummyBorder;
    }

    private Component getDocked(Component c) {
        if (c instanceof DefaultDockingPort) {
            return ((DefaultDockingPort)c).getDockedComponent();
        }
        return c;
    }
}

