/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import net.sf.gogui.gui.AnalyzeShow;
import net.sf.gogui.gui.GuiBoard;
import net.sf.gogui.gui.StatusBar;

public class LiveGfx {
    private boolean m_duringMultiLineResponse;
    private final StringBuffer m_buffer = new StringBuffer(1024);
    private final StringBuffer m_response = new StringBuffer(1024);
    private final GuiBoard m_guiBoard;
    private final StatusBar m_statusBar;

    public LiveGfx(GuiBoard guiBoard, StatusBar statusBar) {
        this.m_guiBoard = guiBoard;
        this.m_statusBar = statusBar;
        this.m_duringMultiLineResponse = false;
    }

    public void receivedStdErr(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') {
                if (SwingUtilities.isEventDispatchThread()) {
                    this.handleLine(this.m_buffer.toString());
                } else {
                    this.invokeAndWait(new Runnable(){

                        public void run() {
                            LiveGfx.this.handleLine(LiveGfx.this.m_buffer.toString());
                        }
                    });
                }
                this.m_buffer.setLength(0);
                continue;
            }
            this.m_buffer.append(c);
        }
    }

    private void handleLine(String string) {
        if (this.m_duringMultiLineResponse) {
            if (string.equals("")) {
                this.showGfx(this.m_response.toString());
                this.m_duringMultiLineResponse = false;
            } else {
                this.m_response.append(string);
                this.m_response.append('\n');
            }
            return;
        }
        if ((string = string.trim()).startsWith("gogui-gfx:")) {
            int n = string.indexOf(58);
            String string2 = string.substring(n + 1);
            if (string2.trim().equals("")) {
                this.m_response.setLength(0);
                this.m_duringMultiLineResponse = true;
            } else {
                this.showGfx(string2);
            }
        }
    }

    private void invokeAndWait(Runnable runnable) {
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Thread interrupted");
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("InvocationTargetException");
        }
    }

    private void showGfx(String string) {
        String string2 = AnalyzeShow.showGfx(string, this.m_guiBoard);
        if (string2 != null) {
            this.m_statusBar.setText(string2);
        }
    }
}

