/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.Bin;
import htsjdk.samtools.BinList;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.GenomicIndexUtil;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

class CachingBAMFileIndex
extends AbstractBAMFileIndex
implements BrowseableBAMIndex {
    private Integer lastReferenceIndex = null;
    private BAMIndexContent lastReference = null;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;

    public CachingBAMFileIndex(File file, SAMSequenceDictionary dictionary) {
        super(file, dictionary);
    }

    public CachingBAMFileIndex(SeekableStream stream, SAMSequenceDictionary dictionary) {
        super(stream, dictionary);
    }

    public CachingBAMFileIndex(File file, SAMSequenceDictionary dictionary, boolean useMemoryMapping) {
        super(file, dictionary, useMemoryMapping);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(int referenceIndex, int startPos, int endPos) {
        BAMIndexContent queryResults = this.getQueryResults(referenceIndex);
        if (queryResults == null) {
            return null;
        }
        List<Chunk> chunkList = queryResults.getChunksOverlapping(startPos, endPos);
        if (chunkList == null) {
            return null;
        }
        return new BAMFileSpan(chunkList);
    }

    @Override
    public BinList getBinsOverlapping(int referenceIndex, int startPos, int endPos) {
        BitSet regionBins = GenomicIndexUtil.regionToBins(startPos, endPos);
        if (regionBins == null) {
            return null;
        }
        return new BinList(referenceIndex, regionBins);
    }

    @Override
    public BAMFileSpan getSpanOverlapping(Bin bin) {
        if (bin == null) {
            return null;
        }
        int referenceSequence = bin.getReferenceSequence();
        BAMIndexContent indexQuery = this.getQueryResults(referenceSequence);
        if (indexQuery == null) {
            return null;
        }
        int binLevel = this.getLevelForBin(bin);
        int firstLocusInBin = this.getFirstLocusInBin(bin);
        ArrayList<Bin> binTree = new ArrayList<Bin>();
        if (indexQuery.containsBin(bin)) {
            binTree.add(indexQuery.getBins().getBin(bin.getBinNumber()));
        }
        int currentBinLevel = binLevel;
        while (--currentBinLevel >= 0) {
            int binStart = CachingBAMFileIndex.getFirstBinInLevel(currentBinLevel);
            int binWidth = this.getMaxAddressibleGenomicLocation() / this.getLevelSize(currentBinLevel);
            int binNumber = firstLocusInBin / binWidth + binStart;
            Bin parentBin = indexQuery.getBins().getBin(binNumber);
            if (parentBin == null || !indexQuery.containsBin(parentBin)) continue;
            binTree.add(parentBin);
        }
        List<Chunk> chunkList = new ArrayList<Chunk>();
        for (Bin coveringBin : binTree) {
            for (Chunk chunk : coveringBin.getChunkList()) {
                chunkList.add(chunk.clone());
            }
        }
        int start = this.getFirstLocusInBin(bin);
        chunkList = Chunk.optimizeChunkList(chunkList, indexQuery.getLinearIndex().getMinimumOffset(start));
        return new BAMFileSpan(chunkList);
    }

    @Override
    protected BAMIndexContent getQueryResults(int referenceIndex) {
        if (this.lastReferenceIndex != null && this.lastReferenceIndex == referenceIndex) {
            ++this.cacheHits;
            return this.lastReference;
        }
        BAMIndexContent queryResults = this.query(referenceIndex, 1, -1);
        ++this.cacheMisses;
        this.lastReferenceIndex = referenceIndex;
        this.lastReference = queryResults;
        return this.lastReference;
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }
}

