/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.util.ResourceLimitedMapFunctor;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResourceLimitedMap<Key, Value> {
    private static final float hashTableLoadFactor = 0.75f;
    private final LinkedHashMap<Key, Value> map;
    private final int cacheSize;
    private final ResourceLimitedMapFunctor<Key, Value> functor;

    public ResourceLimitedMap(int cacheSize, ResourceLimitedMapFunctor<Key, Value> functor) {
        this.cacheSize = cacheSize;
        this.functor = functor;
        int hashTableCapacity = (int)Math.ceil((float)cacheSize / 0.75f) + 1;
        this.map = new LinkedHashMap<Key, Value>(hashTableCapacity, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Key, Value> eldest) {
                if (this.size() > ResourceLimitedMap.this.cacheSize) {
                    ResourceLimitedMap.this.functor.finalizeValue(eldest.getKey(), eldest.getValue());
                    return true;
                }
                return false;
            }
        };
    }

    public Value get(Key key) {
        if (!this.map.containsKey(key)) {
            this.map.put(key, this.functor.makeValue(key));
        }
        return this.map.get(key);
    }

    public Value remove(Key key) {
        return (Value)this.map.remove(key);
    }

    public boolean containsKey(Key key) {
        return this.map.containsKey(key);
    }

    public void finalizeAll() {
        for (Map.Entry<Key, Value> entry : this.map.entrySet()) {
            this.functor.finalizeValue(entry.getKey(), entry.getValue());
        }
        this.map.clear();
    }
}

