/*
 * Decompiled with CFR 0.152.
 */
package free.jin.scripter;

import free.jin.event.JinEvent;
import free.jin.scripter.Scripter;

public abstract class Script {
    protected final Scripter scripter;
    private final String eventType;
    private final String[] eventSubtypes;
    private final String name;
    private boolean isEnabled = true;

    public Script(Scripter scripter, String string, String string2, String[] stringArray) {
        if (scripter == null) {
            throw new IllegalArgumentException("A null scripter is not allowed");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("A null event type for a script is not allowed");
        }
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("A null/empty script name is not allowed");
        }
        this.scripter = scripter;
        this.name = string;
        this.eventType = string2;
        this.eventSubtypes = stringArray == null ? null : (String[])stringArray.clone();
    }

    public Scripter getScripter() {
        return this.scripter;
    }

    public String getName() {
        return this.name;
    }

    public String getEventType() {
        return this.eventType;
    }

    public String[] getEventSubtypes() {
        return (String[])this.eventSubtypes.clone();
    }

    public String getType() {
        return this.getClass().getName();
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public abstract void run(JinEvent var1, String var2, Object[][] var3);

    public String toString() {
        return this.getName();
    }

    public abstract Script createCopy();
}

