/*
 * Decompiled with CFR 0.152.
 */
package free.freechess;

import free.util.Struct;
import java.util.StringTokenizer;

public class GameInfoStruct
extends Struct {
    public GameInfoStruct(int n, boolean bl, String string, boolean bl2, boolean bl3, boolean bl4, int n2, int n3, int n4, int n5, int n6, int n7, char c, int n8, char c2, boolean bl5, boolean bl6) {
        super(20);
        if (n2 < 0) {
            throw new IllegalArgumentException("White's initial time (" + n2 + ") may not be negative");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Black's initial time (" + n4 + ") may not be negative");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("White's increment (" + n3 + ") may not be negative");
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Black's increment (" + n5 + ") may not be negative");
        }
        this.setIntegerProperty("GameNumber", n);
        this.setBooleanProperty("IsGamePrivate", bl);
        this.setStringProperty("GameCategory", string);
        this.setBooleanProperty("IsGameRated", bl2);
        this.setBooleanProperty("IsWhiteRegistered", bl3);
        this.setBooleanProperty("IsBlackRegistered", bl4);
        this.setIntegerProperty("WhiteTime", n2);
        this.setIntegerProperty("WhiteInc", n3);
        this.setIntegerProperty("BlackTime", n4);
        this.setIntegerProperty("BlackInc", n5);
        this.setIntegerProperty("PartnerGameNumber", n6);
        this.setIntegerProperty("WhiteRating", n7);
        this.setCharProperty("WhiteProvShow", c);
        this.setIntegerProperty("BlackRating", n8);
        this.setCharProperty("BlackProvShow", c2);
        this.setBooleanProperty("IsWhiteTimesealed", bl5);
        this.setBooleanProperty("IsBlackTimesealed", bl6);
    }

    public static GameInfoStruct parseGameInfoLine(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,=");
        if (!stringTokenizer.nextToken().equals("<g1>")) {
            throw new IllegalArgumentException("Missing \"<g1>\" identifier");
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        GameInfoStruct.assertToken(stringTokenizer, "p");
        boolean bl = GameInfoStruct.parseBoolean(stringTokenizer.nextToken());
        GameInfoStruct.assertToken(stringTokenizer, "t");
        String string2 = stringTokenizer.nextToken();
        GameInfoStruct.assertToken(stringTokenizer, "r");
        boolean bl2 = GameInfoStruct.parseBoolean(stringTokenizer.nextToken());
        GameInfoStruct.assertToken(stringTokenizer, "u");
        boolean bl3 = GameInfoStruct.parseBoolean(stringTokenizer.nextToken());
        boolean bl4 = GameInfoStruct.parseBoolean(stringTokenizer.nextToken());
        GameInfoStruct.assertToken(stringTokenizer, "it");
        int n2 = Integer.parseInt(stringTokenizer.nextToken());
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        GameInfoStruct.assertToken(stringTokenizer, "i");
        int n4 = Integer.parseInt(stringTokenizer.nextToken());
        int n5 = Integer.parseInt(stringTokenizer.nextToken());
        GameInfoStruct.assertToken(stringTokenizer, "pt");
        int n6 = Integer.parseInt(stringTokenizer.nextToken());
        GameInfoStruct.assertToken(stringTokenizer, "rt");
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        char c = ' ';
        char c2 = ' ';
        if (!Character.isDigit(string3.charAt(string3.length() - 1))) {
            c = string3.charAt(string3.length() - 1);
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (!Character.isDigit(string4.charAt(string4.length() - 1))) {
            c2 = string4.charAt(string4.length() - 1);
            string4 = string4.substring(0, string4.length() - 1);
        }
        int n7 = Integer.parseInt(string3);
        int n8 = Integer.parseInt(string4);
        GameInfoStruct.assertToken(stringTokenizer, "ts");
        boolean bl5 = GameInfoStruct.parseBoolean(stringTokenizer.nextToken());
        boolean bl6 = GameInfoStruct.parseBoolean(stringTokenizer.nextToken());
        return new GameInfoStruct(n, bl, string2, bl2, bl3, bl4, n2, n3, n4, n5, n6, n7, c, n8, c2, bl5, bl6);
    }

    private static boolean parseBoolean(String string) {
        if (string.equals("1")) {
            return true;
        }
        if (string.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Bad boolean value: " + string);
    }

    private static void assertToken(StringTokenizer stringTokenizer, String string) {
        String string2 = stringTokenizer.nextToken();
        if (!string2.equals(string)) {
            throw new IllegalArgumentException("Bad token \"" + string2 + "\", expected \"" + string + "\" instead");
        }
    }

    public int getGameNumber() {
        return this.getIntegerProperty("GameNumber");
    }

    public boolean isGamePrivate() {
        return this.getBooleanProperty("IsGamePrivate");
    }

    public String getGameCategory() {
        return this.getStringProperty("GameCategory");
    }

    public boolean isGameRated() {
        return this.getBooleanProperty("IsGameRated");
    }

    public boolean isWhiteRegistered() {
        return this.getBooleanProperty("IsWhiteRegistered");
    }

    public boolean isBlackRegistered() {
        return this.getBooleanProperty("IsBlackRegistered");
    }

    public int getWhiteTime() {
        return this.getIntegerProperty("WhiteTime");
    }

    public int getBlackTime() {
        return this.getIntegerProperty("BlackTime");
    }

    public int getWhiteInc() {
        return this.getIntegerProperty("WhiteInc");
    }

    public int getBlackInc() {
        return this.getIntegerProperty("BlackInc");
    }

    public int getPartnerGameNumber() {
        return this.getIntegerProperty("PartnerGameNumber");
    }

    public int getWhiteRating() {
        return this.getIntegerProperty("WhiteRating");
    }

    public char getWhiteProvShow() {
        return this.getCharProperty("WhiteProvShow");
    }

    public int getBlackRating() {
        return this.getIntegerProperty("BlackRating");
    }

    public char getBlackProvShow() {
        return this.getCharProperty("BlackProvShow");
    }

    public boolean isWhiteTimesealed() {
        return this.getBooleanProperty("IsWhiteTimesealed");
    }

    public boolean isBlackTimesealed() {
        return this.getBooleanProperty("IsBlackTimesealed");
    }
}

