/*
 * Decompiled with CFR 0.152.
 */
package com.birosoft.liquid.borders;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Robot;
import java.awt.Window;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class LiquidFrameBorder
extends AbstractBorder
implements UIResource {
    private static LiquidFrameBorder onlyInstance;
    private static Robot robot;
    private static boolean robotsSupported;
    private static final Insets insets;
    private boolean prevState = false;
    private Window window;
    private int titleHeight;
    private boolean isActive = true;

    public static LiquidFrameBorder getInstance() {
        if (onlyInstance == null) {
            onlyInstance = new LiquidFrameBorder();
            if (robot == null && robotsSupported) {
                try {
                    robot = new Robot();
                }
                catch (AWTException e) {
                    robotsSupported = false;
                }
            }
        }
        return onlyInstance;
    }

    private final void isWindowRealActive(Window window) {
        this.isActive = window.isActive();
        if (this.isActive) {
            this.prevState = true;
        }
        if (!this.prevState && !this.isActive) {
            this.isActive = true;
        }
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
        this.window = SwingUtilities.getWindowAncestor(c);
        if (this.window instanceof JDialog) {
            JDialog d = (JDialog)this.window;
            if (d.isModal()) {
                this.isActive = true;
            } else {
                this.isWindowRealActive(this.window);
            }
        } else {
            this.isWindowRealActive(this.window);
        }
        int frameTitleHeight = UIManager.getInt("InternalFrame.frameTitleHeight");
        boolean index = !this.isActive;
        this.drawLeftTop(g, this.isActive, 4, frameTitleHeight);
        g.translate(0, frameTitleHeight);
        this.drawLeft(g, this.isActive, 4, h - frameTitleHeight - 4);
        g.translate(0, -frameTitleHeight);
        g.translate(0, h - 4);
        this.drawBottom(g, this.isActive, w, 4);
        g.translate(0, -(h - 4));
        g.translate(w - 4, 0);
        this.drawRightTop(g, this.isActive, 4, frameTitleHeight);
        g.translate(0, frameTitleHeight);
        this.drawRight(g, this.isActive, 4, h - frameTitleHeight - 4);
        g.translate(0, -frameTitleHeight);
        g.translate(-(w - 4), 0);
    }

    private final void drawLeftTop(Graphics g, boolean isSelected, int w, int h) {
        Color c = isSelected ? new Color(62, 145, 235) : new Color(175, 214, 255);
        g.setColor(c);
        g.fillRect(0, 0, w, h);
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(0, 0, w, 0);
        g.drawLine(0, 0, 0, h);
        c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
        g.setColor(c);
        g.drawLine(1, 1, w, 1);
        int i = 4;
        while (i < h) {
            c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
            g.setColor(c);
            g.drawLine(1, i, w, i);
            c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
            g.setColor(c);
            g.drawLine(1, i + 1, w, i + 1);
            i += 4;
        }
        c = isSelected ? new Color(47, 111, 180) : new Color(135, 164, 196);
        g.setColor(c);
        g.drawLine(w - 1, h - 1, w - 1, h - 1);
    }

    private final void drawLeft(Graphics g, boolean isSelected, int w, int h) {
        Color c = isSelected ? new Color(62, 145, 235) : new Color(175, 214, 255);
        g.setColor(c);
        g.fillRect(0, 0, w, h);
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(0, 0, 0, h);
        c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
        g.setColor(c);
        g.drawLine(1, 0, w, 0);
        int i = 3;
        while (i < h) {
            c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
            g.setColor(c);
            g.drawLine(1, i, w, i);
            c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
            g.setColor(c);
            g.drawLine(1, i + 1, w, i + 1);
            i += 4;
        }
        c = isSelected ? new Color(47, 111, 180) : new Color(135, 164, 196);
        g.setColor(c);
        g.drawLine(w - 1, 0, w - 1, h);
    }

    private final void drawRightTop(Graphics g, boolean isSelected, int w, int h) {
        Color c = isSelected ? new Color(62, 145, 235) : new Color(175, 214, 255);
        g.setColor(c);
        g.fillRect(0, 0, w, h);
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(0, 0, w - 2, 0);
        c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
        g.setColor(c);
        g.drawLine(0, 1, w - 2, 1);
        int i = 4;
        while (i < h) {
            c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
            g.setColor(c);
            g.drawLine(0, i, w - 2, i);
            c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
            g.setColor(c);
            g.drawLine(0, i + 1, w - 2, i + 1);
            i += 4;
        }
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(0, h - 1, 0, h - 1);
        c = isSelected ? new Color(47, 111, 180) : new Color(135, 164, 196);
        g.setColor(c);
        g.drawLine(w - 1, 0, w - 1, h);
    }

    private final void drawRight(Graphics g, boolean isSelected, int w, int h) {
        Color c = isSelected ? new Color(62, 145, 235) : new Color(175, 214, 255);
        g.setColor(c);
        g.fillRect(0, 0, w, h);
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(0, 0, 0, h);
        c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
        g.setColor(c);
        g.drawLine(1, 0, w, 0);
        int i = 3;
        while (i < h) {
            c = isSelected ? new Color(59, 138, 223) : new Color(166, 203, 242);
            g.setColor(c);
            g.drawLine(1, i, w, i);
            c = isSelected ? new Color(60, 141, 228) : new Color(170, 207, 247);
            g.setColor(c);
            g.drawLine(1, i + 1, w, i + 1);
            i += 4;
        }
        c = isSelected ? new Color(47, 111, 180) : new Color(135, 164, 196);
        g.setColor(c);
        g.drawLine(w - 1, 0, w - 1, h);
    }

    private final void drawBottom(Graphics g, boolean isSelected, int w, int h) {
        Color c = isSelected ? new Color(62, 145, 235) : new Color(175, 214, 255);
        g.setColor(c);
        g.fillRect(1, 0, w - 1, h - 1);
        c = isSelected ? new Color(94, 172, 255) : new Color(226, 240, 255);
        g.setColor(c);
        g.drawLine(3, 0, w - 4, 0);
        g.drawLine(0, 0, 0, h - 2);
        c = isSelected ? new Color(47, 111, 180) : new Color(135, 164, 196);
        g.setColor(c);
        g.drawLine(0, h - 1, w, h - 1);
        g.drawLine(w - 1, 0, w - 1, h - 1);
    }

    public Insets getBorderInsets(Component c) {
        return new Insets(0, 4, 4, 4);
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    static {
        robotsSupported = true;
        insets = new Insets(0, 4, 4, 4);
    }
}

