/*
 * Decompiled with CFR 0.152.
 */
package free.jin.seek;

import free.chess.Chess;
import free.chess.Player;
import free.chess.WildVariant;
import free.jin.I18n;
import free.jin.Preferences;
import free.jin.Seek;
import free.jin.plugin.Plugin;
import free.jin.seek.event.SeekSelectionEvent;
import free.jin.seek.event.SeekSelectionListener;
import free.util.GraphicsUtilities;
import free.util.ImageUtilities;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JComponent;

public class SoughtGraph
extends JComponent {
    protected static final int BULLET_SLOTS = 7;
    protected static final int BLITZ_SLOTS = 28;
    protected static final int STANDARD_SLOTS = 15;
    protected static final int RATING_SLOTS = 32;
    protected static final double GRAPH_WIDTH_PERCENTAGE = 0.9375;
    protected static final double GRAPH_HEIGHT_PERCENTAGE = 0.9;
    protected final Plugin plugin;
    private final int minSeekImageSize;
    protected final Hashtable seeksToLocations = new Hashtable();
    protected final Seek[][] seekMatrix = new Seek[50][32];
    protected Seek curSeek = null;
    protected Point curMouseLocation = null;
    private final Image bgImage;
    private final String fastCategoryName;
    private final String moderateCategoryName;
    private final String slowCategoryName;
    private final Hashtable[] seekImageCache;
    private Font timeStringFont = null;
    private FontMetrics timeStringFontMetrics = null;
    private Font ratingStringFont = null;
    private Font seekFont = null;
    private FontMetrics seekFontMetrics = null;
    private Dimension fontsCachedAtSize = null;

    public SoughtGraph(Plugin plugin) {
        int n;
        Image image;
        this.plugin = plugin;
        Preferences preferences = plugin.getPrefs();
        I18n i18n = plugin.getI18n();
        this.setOpaque(true);
        this.setBackground(preferences.getColor("background-color", Color.white));
        this.setFont(new Font("SansSerif", 0, 10));
        String string = preferences.getString("background.image", null);
        Image image2 = string == null ? null : (image = this.getToolkit().getImage(SoughtGraph.class.getResource("background.gif")));
        if (image != null && ImageUtilities.preload(image) != 1) {
            image = null;
        }
        this.bgImage = image;
        this.fastCategoryName = i18n.getString(preferences.getString("fastCategory.nameKey"));
        this.moderateCategoryName = i18n.getString(preferences.getString("moderateCategory.nameKey"));
        this.slowCategoryName = i18n.getString(preferences.getString("slowCategory.nameKey"));
        int[] nArray = preferences.getIntList("seek-image.sizes");
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        for (n = 0; n < nArray.length; ++n) {
            if (nArray[n] > n2) {
                n2 = nArray[n];
            }
            if (nArray[n] >= n3) continue;
            n3 = nArray[n];
        }
        this.minSeekImageSize = n3;
        this.seekImageCache = new Hashtable[n2 + 1];
        for (n = 0; n < nArray.length; ++n) {
            this.seekImageCache[nArray[n]] = new Hashtable(10);
        }
        this.enableEvents(48L);
    }

    protected Point mapSeek(Seek seek) {
        int n;
        int n2 = 3 * seek.getTime() / 60000 + 2 * seek.getInc() / 1000;
        int n3 = n = seek.isSeekerRated() ? seek.getSeekerRating() : 0;
        int n4 = n2 < 9 ? (n2 - 2) * 7 / 7 : (n2 < 45 ? 7 + (n2 - 7 - 2) * 28 / 36 : (int)(35.0 + 15.0 * (1.0 - Math.pow(1.1, -((double)(n2 - 7 - 36 - 2) / 10.0)))));
        int n5 = n == 0 ? 0 : (n < 1000 ? 1 + n / 200 : (n < 1500 ? 6 + (n - 1000) / 50 : (n < 2000 ? 16 + (n - 1500) / 50 : (n < 3000 ? 26 + (n - 2000) / 200 : 31))));
        return new Point(n4, n5);
    }

    protected Point fitSeek(Seek seek, Point point) {
        if (this.seekMatrix[point.x][point.y] == null) {
            return point;
        }
        int n = 3 * seek.getTime() / 60000 + 2 * seek.getInc() / 1000;
        boolean bl = n < 9;
        boolean bl2 = !bl && n < 45;
        boolean bl3 = n >= 45;
        int n2 = point.x;
        int n3 = point.y;
        int n4 = 0;
        int n5 = 1;
        while (true) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < n5; ++j) {
                    switch (n4) {
                        case 0: {
                            ++n2;
                            break;
                        }
                        case 1: {
                            ++n3;
                            break;
                        }
                        case 2: {
                            --n2;
                            break;
                        }
                        case 3: {
                            --n3;
                        }
                    }
                    if (n2 < 0 || n2 >= this.seekMatrix.length || n3 < 0 || n3 >= this.seekMatrix[0].length || bl && n2 >= 7 || bl2 && (n2 < 7 || n2 >= 35) || bl3 && n2 < 35 || this.seekMatrix[n2][n3] != null) continue;
                    return new Point(n2, n3);
                }
                if (++n4 != 4) continue;
                n4 = 0;
            }
            ++n5;
        }
    }

    public void addSeek(Seek seek) {
        Point point = this.mapSeek(seek);
        Point point2 = this.fitSeek(seek, point);
        this.seeksToLocations.put(seek, point2);
        this.seekMatrix[point2.x][point2.y] = seek;
        Rectangle rectangle = this.getSeekBounds(point2.x, point2.y, null);
        this.repaint(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
        if (this.curMouseLocation != null) {
            this.updateCurrentSeek(this.curMouseLocation.x, this.curMouseLocation.y);
        }
    }

    public void removeSeek(Seek seek) {
        Point point = (Point)this.seeksToLocations.remove(seek);
        if (point == null) {
            throw new IllegalArgumentException("Unknown seek: " + seek.getID());
        }
        this.seekMatrix[point.x][point.y] = null;
        Rectangle rectangle = this.getSeekBounds(point.x, point.y, null);
        this.repaint(rectangle.x - 2, rectangle.y - 2, rectangle.width + 4, rectangle.height + 4);
        if (seek == this.curSeek && this.curMouseLocation != null) {
            this.updateCurrentSeek(this.curMouseLocation.x, this.curMouseLocation.y);
        }
    }

    public void removeAllSeeks() {
        this.seeksToLocations.clear();
        for (int i = 0; i < this.seekMatrix.length; ++i) {
            for (int j = 0; j < this.seekMatrix[i].length; ++j) {
                this.seekMatrix[i][j] = null;
            }
        }
        this.repaint();
    }

    protected Rectangle getSeekBounds(int n, int n2, Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = (int)((double)n3 * 0.0625) + 1;
        int n6 = 0;
        int n7 = (int)((double)n3 * 0.9375);
        int n8 = (int)((double)n4 * 0.9);
        double d = (double)n7 / 50.0;
        double d2 = (double)n8 / 32.0;
        rectangle.x = (int)((double)n5 + (double)n * d);
        rectangle.y = (int)((double)(n6 + n8) - (double)(n2 + 1) * d2);
        rectangle.width = (int)d;
        rectangle.height = (int)d2;
        return rectangle;
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Rectangle rectangle = graphics.getClipBounds();
        int n8 = this.getWidth();
        int n9 = this.getHeight();
        if (this.fontsCachedAtSize == null || n8 != this.fontsCachedAtSize.width || n9 != this.fontsCachedAtSize.height) {
            this.timeStringFont = null;
            this.timeStringFontMetrics = null;
            this.ratingStringFont = null;
            this.seekFont = null;
            this.seekFontMetrics = null;
            this.fontsCachedAtSize = new Dimension(n8, n9);
        }
        Color color = this.getBackground();
        Color color2 = this.getForeground();
        Color color3 = new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
        graphics.setColor(color);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.bgImage != null) {
            Rectangle rectangle2 = new Rectangle(0, 0, this.bgImage.getWidth(null), this.bgImage.getHeight(null));
            while (rectangle2.x < n8) {
                rectangle2.y = 0;
                while (rectangle2.y < n9) {
                    if (rectangle2.intersects(rectangle)) {
                        graphics.drawImage(this.bgImage, rectangle2.x, rectangle2.y, this);
                    }
                    rectangle2.y += rectangle2.height;
                }
                rectangle2.x += rectangle2.width;
            }
        }
        int n10 = (int)((double)n8 * 0.0625);
        int n11 = 0;
        int n12 = (int)((double)n8 * 0.9375);
        int n13 = (int)((double)n9 * 0.9);
        double d = (double)n12 / 50.0;
        double d2 = (double)n13 / 32.0;
        int n14 = (int)(d * 7.0);
        int n15 = (int)(d * 28.0);
        int n16 = (int)(d * 15.0);
        graphics.setColor(color2);
        graphics.drawLine(n10, n11 + n13, n10 + n12, n11 + n13);
        graphics.drawLine(n10, n11, n10, n11 + n13);
        graphics.fillPolygon(new int[]{n10 + 5, n10 - 5, n10}, new int[]{n11 + 9, n11 + 9, n11}, 3);
        graphics.fillPolygon(new int[]{n10 + n12, n10 + n12 - 9, n10 + n12 - 9}, new int[]{n11 + n13, n11 + n13 - 5, n11 + n13 + 5}, 3);
        graphics.setColor(color3);
        int n17 = (int)((double)n10 + 7.0 * d);
        graphics.drawLine(n17, n11, n17, n11 + n13);
        int n18 = (int)((double)n10 + 35.0 * d);
        graphics.drawLine(n18, n11, n18, n11 + n13);
        graphics.setColor(color2);
        Font font = graphics.getFont();
        int n19 = (n9 - (n11 + n13)) / 2;
        if (this.timeStringFont == null) {
            n7 = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)this.fastCategoryName, (int)n14, (int)n19);
            n6 = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)this.moderateCategoryName, (int)n15, (int)n19);
            n5 = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)this.slowCategoryName, (int)n16, (int)n19);
            n4 = Math.min(Math.min(n7, n6), n5);
            this.timeStringFont = new Font(font.getName(), font.getStyle(), n4);
            this.timeStringFontMetrics = graphics.getFontMetrics(this.timeStringFont);
        }
        n7 = this.timeStringFontMetrics.stringWidth(this.fastCategoryName);
        n6 = this.timeStringFontMetrics.stringWidth(this.moderateCategoryName);
        n5 = this.timeStringFontMetrics.stringWidth(this.slowCategoryName);
        graphics.setFont(this.timeStringFont);
        n4 = n11 + n13 + this.timeStringFontMetrics.getMaxAscent() + 1;
        graphics.drawString(this.fastCategoryName, n10 + (n14 - n7) / 2, n4);
        graphics.drawString(this.moderateCategoryName, n10 + n14 + (n15 - n6) / 2, n4);
        graphics.drawString(this.slowCategoryName, n10 + n14 + n15 + (n16 - n5) / 2, n4);
        String string = "1000";
        String string2 = "1500";
        String string3 = "2000";
        int n20 = n13 / 3;
        if (this.ratingStringFont == null) {
            n3 = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)string, (int)(n10 - 4), (int)n20);
            int n21 = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)string2, (int)(n10 - 4), (int)n20);
            n2 = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)string3, (int)(n10 - 4), (int)n20);
            n = Math.min(Math.min(n3, n21), n2);
            this.ratingStringFont = new Font(font.getName(), font.getStyle(), n);
        }
        graphics.setFont(this.ratingStringFont);
        n3 = 1;
        graphics.drawString(string, n3, (int)((double)(n11 + n13) - 6.0 * d2));
        graphics.drawString(string2, n3, (int)((double)(n11 + n13) - 16.0 * d2));
        graphics.drawString(string3, n3, (int)((double)(n11 + n13) - 26.0 * d2));
        if (this.curSeek != null) {
            String string4 = this.getSeekString(this.curSeek);
            n2 = (n9 - (n11 + n13)) / 2;
            if (this.seekFont == null) {
                n = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)string4, (int)n8, (int)n2);
                this.seekFont = new Font(font.getName(), font.getStyle(), n);
                this.seekFontMetrics = graphics.getFontMetrics(this.seekFont);
            }
            graphics.setFont(this.seekFont);
            graphics.drawString(string4, 1, n9 - n2 + this.seekFontMetrics.getMaxAscent());
        }
        Rectangle rectangle3 = new Rectangle();
        for (n2 = 0; n2 < this.seekMatrix.length; ++n2) {
            for (n = 0; n < this.seekMatrix[n2].length; ++n) {
                Seek seek = this.seekMatrix[n2][n];
                if (seek == null || !(rectangle3 = this.getSeekBounds(n2, n, rectangle3)).intersects(rectangle)) continue;
                this.drawSeek(graphics, seek, rectangle3);
            }
        }
    }

    private Image getSeekImage(Rectangle rectangle, Seek seek) {
        int n;
        int n2 = Math.min(rectangle.width, rectangle.height);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Seek bounds size must be positive");
        }
        int n3 = -1;
        if (n2 >= this.seekImageCache.length) {
            n3 = this.seekImageCache.length - 1;
        } else if (this.seekImageCache[n2] != null) {
            n3 = n2;
        }
        if (n3 == -1) {
            for (n = n2; n > 0; --n) {
                if (this.seekImageCache[n] == null) continue;
                n3 = n;
                break;
            }
        }
        if (n3 == -1) {
            for (n = n2 + 1; n < this.seekImageCache.length; ++n) {
                if (this.seekImageCache[n] == null) continue;
                n3 = n;
                break;
            }
        }
        if (n3 == -1) {
            throw new IllegalStateException("Couldn't find suitable seek images");
        }
        Hashtable hashtable = this.seekImageCache[n3];
        String string = seek.isSeekerComputer() ? "computer" : "human";
        String string2 = seek.isRated() ? "rated" : "unrated";
        String string3 = "seek-image." + string2 + "." + string + "." + seek.getVariant();
        Image image = (Image)hashtable.get(string3);
        if (image == null) {
            String string4 = (String)this.plugin.getPrefs().lookup(string3);
            if (string4 == null) {
                return null;
            }
            String string5 = "images/" + n3 + "/" + string4;
            image = this.getToolkit().getImage(SoughtGraph.class.getResource(string5));
            if (ImageUtilities.preload((Image)image) != 1) {
                return null;
            }
            hashtable.put(string3, image);
        }
        return image;
    }

    protected void drawSeek(Graphics graphics, Seek seek, Rectangle rectangle) {
        Image image = this.getSeekImage(rectangle, seek);
        if (image == null) {
            graphics.setColor(Color.black);
            graphics.drawOval(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
            return;
        }
        graphics.drawImage(image, rectangle.x, rectangle.y, null);
    }

    protected String getSeekString(Seek seek) {
        I18n i18n = I18n.get((Class)SoughtGraph.class);
        String string = i18n.getString("provisional");
        String string2 = i18n.getString("rated");
        String string3 = i18n.getString("unrated");
        String string4 = i18n.getString("white");
        String string5 = i18n.getString("black");
        String string6 = i18n.getString("manualAcceptIndicator");
        String string7 = i18n.getString("formulaIndicator");
        String string8 = seek.getSeekerName();
        String string9 = seek.getSeekerTitle();
        int n = seek.getSeekerRating();
        String string10 = seek.isSeekerRated() ? " " + n : "";
        boolean bl = seek.isSeekerProvisional() && seek.isSeekerRegistered();
        int n2 = seek.getTime() / 60000;
        int n3 = seek.getInc() / 1000;
        boolean bl2 = seek.isRated();
        WildVariant wildVariant = seek.getVariant();
        Player player = seek.getSoughtColor();
        boolean bl3 = seek.isRatingLimited();
        boolean bl4 = seek.isManualAccept();
        boolean bl5 = seek.isFormula();
        String string11 = string8 + string9 + string10 + (bl ? " (" + string + ") " : " ") + n2 + " " + n3 + " " + (bl2 ? string2 : string3) + " ";
        if (!(wildVariant instanceof Chess)) {
            string11 = string11 + wildVariant.getName() + " ";
        }
        if (player != null) {
            string11 = string11 + (player.isWhite() ? string4 : string5) + " ";
        }
        if (bl3) {
            int n4 = seek.getMinRating();
            int n5 = seek.getMaxRating();
            string11 = string11 + n4 + "-" + n5 + " ";
        }
        if (bl4) {
            string11 = string11 + string6 + " ";
        }
        if (bl5) {
            string11 = string11 + string7 + " ";
        }
        return string11;
    }

    protected Seek seekAtLocation(int n, int n2) {
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = (int)((double)n3 * 0.0625);
        int n6 = 0;
        int n7 = (int)((double)n3 * 0.9375);
        int n8 = (int)((double)n4 * 0.9);
        double d = (double)n7 / 50.0;
        double d2 = (double)n8 / 32.0;
        if (n < n5) {
            return null;
        }
        if (n6 + n8 < n2) {
            return null;
        }
        int n9 = (int)((double)(n - n5) / d);
        int n10 = (int)((double)(n6 + n8 - n2) / d2);
        if (n9 < 0 || n9 >= this.seekMatrix.length || n10 < 0 || n10 >= this.seekMatrix[n9].length) {
            return null;
        }
        return this.seekMatrix[n9][n10];
    }

    protected void updateCurrentSeek(int n, int n2) {
        Seek seek = this.seekAtLocation(n, n2);
        if (seek != this.curSeek) {
            this.curSeek = seek;
            this.repaint(0, (int)((double)this.getHeight() * 0.9), this.getWidth(), (int)((double)this.getHeight() * 0.09999999999999998));
            if (seek != null) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.getID() == 503) {
            this.updateCurrentSeek(mouseEvent.getX(), mouseEvent.getY());
            this.curMouseLocation = mouseEvent.getPoint();
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        Seek seek;
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.getID() == 505) {
            this.curSeek = null;
            this.curMouseLocation = null;
            this.repaint(0, (int)((double)this.getHeight() * 0.9), this.getWidth(), (int)((double)this.getHeight() * 0.09999999999999998));
        }
        if (mouseEvent.getID() == 504) {
            this.curMouseLocation = mouseEvent.getPoint();
            this.setCursor(Cursor.getDefaultCursor());
        }
        if (mouseEvent.getID() == 500 && mouseEvent.getModifiers() == 16 && (seek = this.seekAtLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            this.fireSeekSelectionEvent(new SeekSelectionEvent(this, seek));
        }
    }

    public void addSeekSelectionListener(SeekSelectionListener seekSelectionListener) {
        this.listenerList.add(SeekSelectionListener.class, seekSelectionListener);
    }

    public void removeSeekSelectionListener(SeekSelectionListener seekSelectionListener) {
        this.listenerList.remove(SeekSelectionListener.class, seekSelectionListener);
    }

    protected void fireSeekSelectionEvent(SeekSelectionEvent seekSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != (class$free$jin$seek$event$SeekSelectionListener == null ? SoughtGraph.class$("free.jin.seek.event.SeekSelectionListener") : class$free$jin$seek$event$SeekSelectionListener)) continue;
            SeekSelectionListener seekSelectionListener = (SeekSelectionListener)objectArray[i + 1];
            seekSelectionListener.seekSelected(seekSelectionEvent);
        }
    }

    public Dimension getMinimumSize() {
        int n = (int)((double)(this.minSeekImageSize * 50) / 0.9375);
        int n2 = (int)((double)(this.minSeekImageSize * 32) / 0.9);
        return new Dimension(n, n2);
    }
}

