/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus;
import org.jetbrains.kotlin.fir.expressions.FirWhenBranch;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J \u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J2\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002R\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\u001d\u001a\u00020\u001e*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0018\u0010 \u001a\u00020\u001e*\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001f\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirWhenExpressionChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)V", "reportEmptyThenInExpression", "whenExpression", "reportNotExhaustive", "reportNoElseInWhen", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "subjectClassSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "missingCases", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "getMissingCases", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)Ljava/util/List;", "reportElseMisplaced", "reportRedundantElse", "isIfExpression", "", "(Lorg/jetbrains/kotlin/KtSourceElement;)Z", "isWhenExpression", "AlgebraicTypeKind", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirExhaustiveWhenChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirExhaustiveWhenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker\n+ 2 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n+ 3 ClassKind.kt\norg/jetbrains/kotlin/descriptors/ClassKindKt\n*L\n1#1,142:1\n40#2:143\n48#2:144\n84#2:145\n37#3:146\n*S KotlinDebug\n*F\n+ 1 FirExhaustiveWhenChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker\n*L\n73#1:143\n94#1:144\n96#1:145\n96#1:146\n*E\n"})
public final class FirExhaustiveWhenChecker
extends FirExpressionChecker<FirWhenExpression> {
    @NotNull
    public static final FirExhaustiveWhenChecker INSTANCE = new FirExhaustiveWhenChecker();

    private FirExhaustiveWhenChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirWhenExpression expression2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(expression2, "expression");
        this.reportNotExhaustive(expression2, context2, reporter);
        this.reportElseMisplaced(expression2, reporter, context2);
        this.reportRedundantElse(expression2, context2, reporter);
    }

    private final void reportEmptyThenInExpression(FirWhenExpression whenExpression, CheckerContext context2, DiagnosticReporter reporter) {
        FirWhenBranch thenBranch;
        KtSourceElement ktSourceElement = whenExpression.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        if (this.isIfExpression(source) && whenExpression.getUsedAsExpression() && ((thenBranch = CollectionsKt.firstOrNull(whenExpression.getBranches())) == null || thenBranch.getResult() instanceof FirEmptyExpressionBlock)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void reportNotExhaustive(FirWhenExpression whenExpression, CheckerContext context2, DiagnosticReporter reporter) {
        FirRegularClassSymbol subjectClassSymbol;
        ConeKotlinType subjectType;
        ExhaustivenessStatus exhaustivenessStatus = whenExpression.getExhaustivenessStatus();
        if (exhaustivenessStatus == null) {
            return;
        }
        ExhaustivenessStatus exhaustivenessStatus2 = exhaustivenessStatus;
        if (!(exhaustivenessStatus2 instanceof ExhaustivenessStatus.NotExhaustive)) {
            this.reportEmptyThenInExpression(whenExpression, context2, reporter);
            return;
        }
        KtSourceElement ktSourceElement = whenExpression.getSource();
        if (ktSourceElement == null) {
            return;
        }
        KtSourceElement source = ktSourceElement;
        ConeKotlinType coneKotlinType = subjectType = ((ExhaustivenessStatus.NotExhaustive)exhaustivenessStatus2).getSubjectType();
        FirRegularClassSymbol firRegularClassSymbol = subjectClassSymbol = coneKotlinType != null ? ToSymbolUtilsKt.toRegularClassSymbol(coneKotlinType, context2.getSession()) : null;
        if (whenExpression.getUsedAsExpression()) {
            if (this.isIfExpression(source)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINVALID_IF_AS_EXPRESSION(), (DiagnosticContext)context2, null, 8, null);
                return;
            }
            if (this.isWhenExpression(source)) {
                this.reportNoElseInWhen(reporter, source, whenExpression, subjectClassSymbol, context2);
            }
        } else {
            AlgebraicTypeKind algebraicTypeKind;
            if (subjectClassSymbol == null) {
                return;
            }
            FirClassLikeSymbol $this$modality$iv = subjectClassSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() == Modality.SEALED) {
                algebraicTypeKind = AlgebraicTypeKind.Sealed;
            } else if (subjectClassSymbol.getClassKind() == ClassKind.ENUM_CLASS) {
                algebraicTypeKind = AlgebraicTypeKind.Enum;
            } else if (ConeBuiltinTypeUtilsKt.isBooleanOrNullableBoolean(subjectType)) {
                algebraicTypeKind = AlgebraicTypeKind.Boolean;
            } else {
                return;
            }
            AlgebraicTypeKind kind = algebraicTypeKind;
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitNonExhaustiveWhenOnAlgebraicTypes)) {
                this.reportNoElseInWhen(reporter, source, whenExpression, subjectClassSymbol, context2);
            } else {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNON_EXHAUSTIVE_WHEN_STATEMENT(), (Object)kind.getDisplayName(), this.getMissingCases(whenExpression), (DiagnosticContext)context2, null, 32, null);
            }
        }
    }

    private final void reportNoElseInWhen(DiagnosticReporter reporter, KtSourceElement source, FirWhenExpression whenExpression, FirRegularClassSymbol subjectClassSymbol, CheckerContext context2) {
        String string;
        Boolean bl;
        FirRegularClassSymbol firRegularClassSymbol = subjectClassSymbol;
        if (firRegularClassSymbol != null) {
            FirClassLikeSymbol $this$isExpect$iv = firRegularClassSymbol;
            boolean $i$f$isExpect = false;
            bl = $this$isExpect$iv.getRawStatus().isExpect();
        } else {
            bl = null;
        }
        if (Intrinsics.areEqual(bl, true)) {
            FirClassSymbol $this$isEnumClass$iv = subjectClassSymbol;
            boolean $i$f$isEnumClass = false;
            ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
            boolean $i$f$isEnumClass2 = false;
            String declarationType = $this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS ? "enum" : "sealed";
            string = " ('when' with expect " + declarationType + " subject cannot be exhaustive without else branch)";
        } else {
            string = "";
        }
        String description = string;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getNO_ELSE_IN_WHEN(), this.getMissingCases(whenExpression), (Object)description, (DiagnosticContext)context2, null, 32, null);
    }

    private final List<WhenMissingCase> getMissingCases(FirWhenExpression $this$missingCases) {
        ExhaustivenessStatus exhaustivenessStatus = $this$missingCases.getExhaustivenessStatus();
        Intrinsics.checkNotNull(exhaustivenessStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatus.NotExhaustive");
        return ((ExhaustivenessStatus.NotExhaustive)exhaustivenessStatus).getReasons();
    }

    private final void reportElseMisplaced(FirWhenExpression expression2, DiagnosticReporter reporter, CheckerContext context2) {
        int branchesCount = expression2.getBranches().size();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)expression2.getBranches())) {
            FirWhenBranch branch = (FirWhenBranch)indexedValue.getValue();
            if (!(branch.getCondition() instanceof FirElseIfTrueCondition) || indexedValue.getIndex() >= branchesCount - 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)branch.getSource(), FirErrors.INSTANCE.getELSE_MISPLACED_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final void reportRedundantElse(FirWhenExpression whenExpression, CheckerContext context2, DiagnosticReporter reporter) {
        if (Intrinsics.areEqual(whenExpression.getExhaustivenessStatus(), ExhaustivenessStatus.RedundantlyExhaustive.INSTANCE)) {
            for (FirWhenBranch branch : whenExpression.getBranches()) {
                if (branch.getSource() == null || !(branch.getCondition() instanceof FirElseIfTrueCondition)) continue;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)branch.getSource(), FirErrors.INSTANCE.getREDUNDANT_ELSE_IN_WHEN(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    private final boolean isIfExpression(KtSourceElement $this$isIfExpression) {
        return Intrinsics.areEqual($this$isIfExpression.getElementType(), KtNodeTypes.IF);
    }

    private final boolean isWhenExpression(KtSourceElement $this$isWhenExpression) {
        return Intrinsics.areEqual($this$isWhenExpression.getElementType(), KtNodeTypes.WHEN);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExhaustiveWhenChecker$AlgebraicTypeKind;", "", "displayName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "Sealed", "Enum", "Boolean", "checkers"})
    private static final class AlgebraicTypeKind
    extends Enum<AlgebraicTypeKind> {
        @NotNull
        private final String displayName;
        public static final /* enum */ AlgebraicTypeKind Sealed = new AlgebraicTypeKind("sealed class/interface");
        public static final /* enum */ AlgebraicTypeKind Enum = new AlgebraicTypeKind("enum");
        public static final /* enum */ AlgebraicTypeKind Boolean = new AlgebraicTypeKind("Boolean");
        private static final /* synthetic */ AlgebraicTypeKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private AlgebraicTypeKind(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static AlgebraicTypeKind[] values() {
            return (AlgebraicTypeKind[])$VALUES.clone();
        }

        public static AlgebraicTypeKind valueOf(String value2) {
            return java.lang.Enum.valueOf(AlgebraicTypeKind.class, value2);
        }

        @NotNull
        public static EnumEntries<AlgebraicTypeKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = algebraicTypeKindArray = new AlgebraicTypeKind[]{AlgebraicTypeKind.Sealed, AlgebraicTypeKind.Enum, AlgebraicTypeKind.Boolean};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

