/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssInspectionsUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CssInvalidMediaFeatureInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssInvalidMediaFeatureInspection.$$$reportNull$$$0(0);
        }
        CssElementVisitor cssElementVisitor = new CssElementVisitor(){

            public void visitMediaFeature(@NotNull CssMediaFeature mediaFeature) {
                if (mediaFeature == null) {
                    1.$$$reportNull$$$0(0);
                }
                String name = mediaFeature.getName();
                PsiElement nameIdentifier = mediaFeature.getNameIdentifier();
                if (name.isEmpty() || nameIdentifier == null) {
                    return;
                }
                Collection descriptors = mediaFeature.getDescriptors();
                if (descriptors.isEmpty()) {
                    holder.registerProblem(nameIdentifier, CssBundle.message((String)"css.inspections.invalid.media.feature.unknown.message", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    return;
                }
                Collection filteredDescriptors = CssInspectionsUtil.filterDescriptorsByContextAndCheck(descriptors, nameIdentifier, holder);
                if (!filteredDescriptors.isEmpty()) {
                    filteredDescriptors = CssInspectionsUtil.filterDescriptorsByMediaTypeAndCheck(descriptors, nameIdentifier, holder);
                }
                if (!filteredDescriptors.isEmpty()) {
                    CssInspectionsUtil.checkDescriptorValue(filteredDescriptors, (CssValueOwner)mediaFeature, holder, "css.inspections.media.feature.mismatched.values");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeature", "com/intellij/psi/css/inspections/invalid/CssInvalidMediaFeatureInspection$1", "visitMediaFeature"));
            }
        };
        if (cssElementVisitor == null) {
            CssInvalidMediaFeatureInspection.$$$reportNull$$$0(1);
        }
        return cssElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/invalid/CssInvalidMediaFeatureInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/invalid/CssInvalidMediaFeatureInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

