/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.suppress;

import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssOneLineStatement;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.inspections.suppress.CssSuppressAllForAtRuleCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressAllForRulesetCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressForAtRuleCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressForRulesetCommentFix;
import com.intellij.psi.css.inspections.suppress.CssSuppressForStatementCommentFix;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSuppressionUtil {
    private static final Pattern SUPPRESS_IN_LINE_COMMENT_PATTERN = Pattern.compile("/\\*\\s*noinspection\\s+([a-zA-Z_0-9.-]+(\\s*,\\s*[a-zA-Z_0-9.-]+)*)\\s*\\w*\\*/");

    public static boolean isSuppressedFor(@Nullable PsiElement element, @NotNull String toolId) {
        if (toolId == null) {
            CssSuppressionUtil.$$$reportNull$$$0(0);
        }
        if (element == null) {
            return true;
        }
        return (Boolean)ReadAction.compute(() -> {
            if (toolId == null) {
                CssSuppressionUtil.$$$reportNull$$$0(9);
            }
            if (CssSuppressionUtil.getSuppressedInStatement(element, toolId) != null) {
                return true;
            }
            if (CssSuppressionUtil.getSuppressedInRuleset(element, toolId) != null) {
                return true;
            }
            if (CssSuppressionUtil.getSuppressedInBlockAtRule(element, toolId) != null) {
                return true;
            }
            return false;
        });
    }

    @Nullable
    public static PsiElement getSuppressibleStatement(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssOneLineStatement.class});
    }

    @Nullable
    public static PsiElement getSuppressibleRuleset(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssRuleset.class});
    }

    @Nullable
    public static PsiElement getSuppressibleAtRule(@Nullable PsiElement context) {
        return PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssAtRule.class});
    }

    @Nullable
    private static PsiElement getSuppressedInStatement(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            CssSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (toolId == null) {
            CssSuppressionUtil.$$$reportNull$$$0(2);
        }
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, CssOneLineStatement.class, (Pattern)SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @Nullable
    private static PsiElement getSuppressedInRuleset(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            CssSuppressionUtil.$$$reportNull$$$0(3);
        }
        if (toolId == null) {
            CssSuppressionUtil.$$$reportNull$$$0(4);
        }
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, CssRuleset.class, (Pattern)SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @Nullable
    private static PsiElement getSuppressedInBlockAtRule(@NotNull PsiElement element, @NotNull String toolId) {
        if (element == null) {
            CssSuppressionUtil.$$$reportNull$$$0(5);
        }
        if (toolId == null) {
            CssSuppressionUtil.$$$reportNull$$$0(6);
        }
        return SuppressionUtil.getStatementToolSuppressedIn((PsiElement)element, (String)toolId, CssAtRule.class, (Pattern)SUPPRESS_IN_LINE_COMMENT_PATTERN);
    }

    @NotNull
    public static SuppressQuickFix[] getSuppressQuickFixes(@NotNull String toolId) {
        if (toolId == null) {
            CssSuppressionUtil.$$$reportNull$$$0(7);
        }
        SuppressQuickFix[] suppressQuickFixArray = new SuppressQuickFix[]{new CssSuppressForStatementCommentFix(toolId), new CssSuppressForRulesetCommentFix(toolId), new CssSuppressAllForRulesetCommentFix(), new CssSuppressForAtRuleCommentFix(toolId), new CssSuppressAllForAtRuleCommentFix()};
        if (suppressQuickFixArray == null) {
            CssSuppressionUtil.$$$reportNull$$$0(8);
        }
        return suppressQuickFixArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/suppress/CssSuppressionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressQuickFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInStatement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInRuleset";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInBlockAtRule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressQuickFixes";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isSuppressedFor$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

