/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.jetbrains.php.phing.dom.PhingReferenceInjector;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTagDefiningNamedElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingDomFileDescription
extends DomFileDescription<PhingPredefinedProject> {
    @NonNls
    private static final String ROOT_TAG_NAME = "project";

    public PhingDomFileDescription() {
        super(PhingPredefinedProject.class, ROOT_TAG_NAME, new String[0]);
    }

    protected void initializeFileDescription() {
        this.registerReferenceInjector(new PhingReferenceInjector());
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        if (file == null) {
            PhingDomFileDescription.$$$reportNull$$$0(0);
        }
        return super.isMyFile(file, module) && PhingDomFileDescription.isPhingFile(file);
    }

    public static boolean isPhingFile(XmlFile xmlFile) {
        XmlDocument document = xmlFile.getDocument();
        if (document != null) {
            XmlTag tag = document.getRootTag();
            if (tag != null && !PlatformUtils.isIdeaUltimate() && ROOT_TAG_NAME.equals(tag.getName()) && tag.getContext() instanceof XmlDocument && tag.getAttributeValue("name") != null && tag.getAttributeValue("default") != null) {
                return true;
            }
            VirtualFile vFile = xmlFile.getOriginalFile().getVirtualFile();
            if (vFile != null && PhingUtils.isPhingMarkedFile(vFile)) {
                return true;
            }
        }
        return false;
    }

    public DomElementsAnnotator createAnnotator() {
        return new PhingTagDefAnnotator();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/phing/dom/PhingDomFileDescription", "isMyFile"));
    }

    private static class PhingTagDefAnnotator
    implements DomElementsAnnotator {
        private PhingTagDefAnnotator() {
        }

        public void annotate(DomElement element, DomElementAnnotationHolder holder) {
            PhingPredefinedTagDefiningNamedElement namedElement;
            String errorMessage;
            if (element instanceof PhingPredefinedTagDefiningNamedElement && (errorMessage = (namedElement = (PhingPredefinedTagDefiningNamedElement)element).getErrorMessage()) != null) {
                holder.createProblem(element, HighlightSeverity.ERROR, errorMessage);
            }
        }
    }
}

