/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.util.XmlUtil;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlDeprecatedElementInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            XmlDeprecatedElementInspection.$$$reportNull$$$0(0);
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                ASTNode nameNode;
                if (XmlDeprecatedElementInspection.checkDeprecated((PsiMetaData)tag.getDescriptor()) && (nameNode = XmlChildRole.START_TAG_NAME_FINDER.findChild(tag.getNode())) != null) {
                    holder.registerProblem(nameNode.getPsi(), "The tag is marked as deprecated", ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            public void visitXmlAttribute(XmlAttribute attribute) {
                if (XmlDeprecatedElementInspection.checkDeprecated((PsiMetaData)attribute.getDescriptor())) {
                    holder.registerProblem((PsiElement)attribute.getNameElement(), "The attribute is marked as deprecated", ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }
        };
        if (xmlElementVisitor == null) {
            XmlDeprecatedElementInspection.$$$reportNull$$$0(1);
        }
        return xmlElementVisitor;
    }

    private static boolean checkDeprecated(@Nullable PsiMetaData metaData) {
        if (metaData == null) {
            return false;
        }
        PsiElement declaration = metaData.getDeclaration();
        if (declaration == null) {
            return false;
        }
        PsiElement comment = XmlUtil.findPreviousComment(declaration);
        if (comment == null) {
            return false;
        }
        return StringUtil.trimStart((String)comment.getText(), (String)"<!--").toLowerCase(Locale.ENGLISH).trim().startsWith("deprecated");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDeprecatedElementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/XmlDeprecatedElementInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

