/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedInternalDocumentListener;
import com.intellij.openapi.editor.impl.BlockInlayImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.InlayImpl;
import com.intellij.openapi.editor.impl.InlineInlayImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.MarkerTreeWithPartialSums;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.util.DocumentUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlayModelImpl
implements InlayModel,
Disposable {
    private static final Logger LOG = Logger.getInstance(InlayModelImpl.class);
    private static final Comparator<Inlay> INLINE_ELEMENTS_COMPARATOR = Comparator.comparingInt(inlay -> inlay.getOffset()).thenComparing(i -> i.isRelatedToPrecedingText());
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_PRIORITY_COMPARATOR = Comparator.comparingInt(i -> -i.myPriority);
    private static final Comparator<BlockInlayImpl> BLOCK_ELEMENTS_COMPARATOR = Comparator.comparing(inlay -> inlay.getVerticalAlignment()).thenComparing(i -> i.getVerticalAlignment() == Inlay.VerticalAlignment.ABOVE_LINE ? i.myPriority : -i.myPriority);
    private static final Processor<InlayImpl> UPDATE_SIZE_PROCESSOR = inlay -> {
        inlay.updateSize();
        return true;
    };
    private final EditorImpl myEditor;
    private final EventDispatcher<InlayModel.Listener> myDispatcher;
    final List<InlayImpl> myInlaysInvalidatedOnMove;
    final RangeMarkerTree<InlineInlayImpl> myInlineElementsTree;
    final MarkerTreeWithPartialSums<BlockInlayImpl> myBlockElementsTree;
    boolean myMoveInProgress;
    boolean myPutMergedIntervalsAtBeginning;
    private List<Inlay> myInlaysAtCaret;

    InlayModelImpl(@NotNull EditorImpl editor) {
        if (editor == null) {
            InlayModelImpl.$$$reportNull$$$0(0);
        }
        this.myDispatcher = EventDispatcher.create(InlayModel.Listener.class);
        this.myInlaysInvalidatedOnMove = new ArrayList<InlayImpl>();
        this.myEditor = editor;
        this.myInlineElementsTree = new InlineElementsTree(editor.getDocument());
        this.myBlockElementsTree = new BlockElementsTree(editor.getDocument());
        this.myEditor.getDocument().addDocumentListener(new PrioritizedInternalDocumentListener(){

            @Override
            public int getPriority() {
                return 150;
            }

            public void beforeDocumentChange(@NotNull DocumentEvent event) {
                List<Inlay> inlays;
                int inlayCount;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (InlayModelImpl.this.myEditor.getDocument().isInBulkUpdate()) {
                    return;
                }
                int offset = event.getOffset();
                if (event.getOldLength() == 0 && offset == InlayModelImpl.this.myEditor.getCaretModel().getOffset() && (inlayCount = (inlays = InlayModelImpl.this.getInlineElementsInRange(offset, offset)).size()) > 0) {
                    VisualPosition inlaysStartPosition = InlayModelImpl.this.myEditor.offsetToVisualPosition(offset, false, false);
                    VisualPosition caretPosition = InlayModelImpl.this.myEditor.getCaretModel().getVisualPosition();
                    if (inlaysStartPosition.line == caretPosition.line && caretPosition.column >= inlaysStartPosition.column && caretPosition.column <= inlaysStartPosition.column + inlayCount) {
                        InlayModelImpl.this.myInlaysAtCaret = inlays;
                        for (int i = 0; i < inlayCount; ++i) {
                            ((InlayImpl)inlays.get(i)).setStickingToRight(i >= caretPosition.column - inlaysStartPosition.column);
                        }
                    }
                }
            }

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (InlayModelImpl.this.myInlaysAtCaret != null) {
                    for (Inlay inlay : InlayModelImpl.this.myInlaysAtCaret) {
                        ((InlayImpl)inlay).setStickingToRight(inlay.isRelatedToPrecedingText());
                    }
                    InlayModelImpl.this.myInlaysAtCaret = null;
                }
            }

            @Override
            public void moveTextHappened(@NotNull Document document, int start2, int end, int base) {
                if (document == null) {
                    1.$$$reportNull$$$0(2);
                }
                for (InlayImpl inlay : InlayModelImpl.this.myInlaysInvalidatedOnMove) {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
                InlayModelImpl.this.myInlaysInvalidatedOnMove.clear();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeDocumentChange";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "documentChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moveTextHappened";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, this);
    }

    void reinitSettings() {
        this.myInlineElementsTree.processAll(UPDATE_SIZE_PROCESSOR);
        this.myBlockElementsTree.processAll(UPDATE_SIZE_PROCESSOR);
    }

    public void dispose() {
        this.myInlineElementsTree.dispose(this.myEditor.getDocument());
        this.myBlockElementsTree.dispose(this.myEditor.getDocument());
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addInlineElement(int offset, boolean relatesToPrecedingText, @NotNull T renderer) {
        if (renderer == null) {
            InlayModelImpl.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        DocumentEx document = this.myEditor.getDocument();
        if (DocumentUtil.isInsideSurrogatePair(document, offset)) {
            return null;
        }
        offset = Math.max(0, Math.min(document.getTextLength(), offset));
        InlineInlayImpl<T> inlay = new InlineInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @Nullable
    public <T extends EditorCustomElementRenderer> Inlay<T> addBlockElement(int offset, boolean relatesToPrecedingText, boolean showAbove, int priority, @NotNull T renderer) {
        if (renderer == null) {
            InlayModelImpl.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        offset = Math.max(0, Math.min(this.myEditor.getDocument().getTextLength(), offset));
        BlockInlayImpl<T> inlay = new BlockInlayImpl<T>(this.myEditor, offset, relatesToPrecedingText, showAbove, priority, renderer);
        this.notifyAdded(inlay);
        return inlay;
    }

    @NotNull
    public List<Inlay> getInlineElementsInRange(int startOffset, int endOffset) {
        List<Inlay> range2;
        List<Inlay> list2 = range2 = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> true, INLINE_ELEMENTS_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getInlineElementsInRange(int startOffset, int endOffset, Class<T> type) {
        List<Inlay<T>> range2;
        List<Inlay<T>> list2 = range2 = InlayModelImpl.getElementsInRange(this.myInlineElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), INLINE_ELEMENTS_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public List<Inlay> getBlockElementsInRange(int startOffset, int endOffset) {
        List<Inlay> range2;
        List<Inlay> list2 = range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> true, BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public <T> List<Inlay<? extends T>> getBlockElementsInRange(int startOffset, int endOffset, Class<T> type) {
        List<Inlay<T>> range2;
        List<Inlay<T>> list2 = range2 = InlayModelImpl.getElementsInRange(this.myBlockElementsTree, startOffset, endOffset, inlay -> type.isInstance(inlay.myRenderer), BLOCK_ELEMENTS_PRIORITY_COMPARATOR);
        if (list2 == null) {
            InlayModelImpl.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private static <T extends Inlay> List<T> getElementsInRange(@NotNull IntervalTreeImpl<? extends T> tree, int startOffset, int endOffset, Predicate<? super T> predicate, Comparator<? super T> comparator2) {
        if (tree == null) {
            InlayModelImpl.$$$reportNull$$$0(7);
        }
        ArrayList result2 = new ArrayList();
        tree.processOverlappingWith(startOffset, endOffset, inlay -> {
            if (predicate.test(inlay)) {
                result2.add(inlay);
            }
            return true;
        });
        Collections.sort(result2, comparator2);
        return result2;
    }

    @NotNull
    public List<Inlay> getBlockElementsForVisualLine(int visualLine, boolean above) {
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine < 0 || visualLine >= visibleLineCount) {
            List<Inlay> list2 = Collections.emptyList();
            if (list2 == null) {
                InlayModelImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList<Inlay> result2 = new ArrayList<Inlay>();
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int endOffset = visualLine == visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<BlockInlayImpl>)((Processor)inlay -> {
            if (inlay.myShowAbove == above && !this.myEditor.getFoldingModel().isOffsetCollapsed(inlay.getOffset())) {
                result2.add((Inlay)inlay);
            }
            return true;
        }));
        Collections.sort(result2, BLOCK_ELEMENTS_COMPARATOR);
        ArrayList<Inlay> arrayList = result2;
        if (arrayList == null) {
            InlayModelImpl.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public int getHeightOfBlockElementsBeforeVisualLine(int visualLine) {
        int endOffset;
        if (visualLine < 0 || !this.hasBlockElements()) {
            return 0;
        }
        int visibleLineCount = this.myEditor.getVisibleLineCount();
        if (visualLine >= visibleLineCount) {
            return this.myBlockElementsTree.getSumOfValuesUpToOffset(Integer.MAX_VALUE) - this.myEditor.getFoldingModel().getTotalHeightOfFoldedBlockInlays();
        }
        int[] result2 = new int[]{0};
        int startOffset = this.myEditor.visualLineStartOffset(visualLine);
        int n = endOffset = visualLine >= visibleLineCount - 1 ? this.myEditor.getDocument().getTextLength() : this.myEditor.visualLineStartOffset(visualLine + 1) - 1;
        if (visualLine > 0) {
            result2[0] = result2[0] + (this.myBlockElementsTree.getSumOfValuesUpToOffset(startOffset - 1) - this.myEditor.getFoldingModel().getHeightOfFoldedBlockInlaysBefore(startOffset));
        }
        this.myBlockElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<BlockInlayImpl>)((Processor)inlay -> {
            if (inlay.myShowAbove && !this.myEditor.getFoldingModel().isOffsetCollapsed(inlay.getOffset())) {
                result2[0] = result2[0] + inlay.getHeightInPixels();
            }
            return true;
        }));
        return result2[0];
    }

    public boolean hasBlockElements() {
        return this.myBlockElementsTree.size() > 0;
    }

    public boolean hasInlineElementsInRange(int startOffset, int endOffset) {
        return !this.myInlineElementsTree.processOverlappingWith(startOffset, endOffset, (Processor<InlineInlayImpl>)((Processor)inlay -> false));
    }

    public boolean hasInlineElements() {
        return this.myInlineElementsTree.size() > 0;
    }

    public boolean hasInlineElementAt(int offset) {
        return !this.myInlineElementsTree.processOverlappingWith(offset, offset, (Processor<InlineInlayImpl>)((Processor)inlay -> false));
    }

    public boolean hasInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        int inlayCount;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(10);
        }
        if ((inlayCount = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset).size()) == 0) {
            return false;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        return visualPosition.line == inlayStartPosition.line && visualPosition.column >= inlayStartPosition.column && visualPosition.column < inlayStartPosition.column + inlayCount;
    }

    @Nullable
    public Inlay getInlineElementAt(@NotNull VisualPosition visualPosition) {
        int offset;
        List<Inlay> inlays;
        if (visualPosition == null) {
            InlayModelImpl.$$$reportNull$$$0(11);
        }
        if ((inlays = this.getInlineElementsInRange(offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition)), offset)).isEmpty()) {
            return null;
        }
        VisualPosition inlayStartPosition = this.myEditor.offsetToVisualPosition(offset, false, false);
        if (visualPosition.line != inlayStartPosition.line) {
            return null;
        }
        int inlayIndex = visualPosition.column - inlayStartPosition.column;
        return inlayIndex >= 0 && inlayIndex < inlays.size() ? inlays.get(inlayIndex) : null;
    }

    @Nullable
    public Inlay getElementAt(@NotNull Point point) {
        if (point == null) {
            InlayModelImpl.$$$reportNull$$$0(12);
        }
        boolean hasInlineElements = this.hasInlineElements();
        boolean hasBlockElements = this.hasBlockElements();
        if (!hasInlineElements && !hasBlockElements) {
            return null;
        }
        VisualPosition visualPosition = this.myEditor.xyToVisualPosition(point);
        if (hasBlockElements) {
            int visualLine = visualPosition.line;
            int baseY = this.myEditor.visualLineToY(visualLine);
            if (point.y < baseY) {
                List<Inlay> inlays = this.getBlockElementsForVisualLine(visualLine, true);
                int yDiff = baseY - point.y;
                for (int i = inlays.size() - 1; i >= 0; --i) {
                    Inlay inlay = inlays.get(i);
                    int height = inlay.getHeightInPixels();
                    if (yDiff <= height) {
                        return inlay;
                    }
                    yDiff -= height;
                }
                throw new IllegalStateException();
            }
            int lineBottom = baseY + this.myEditor.getLineHeight();
            if (point.y >= lineBottom) {
                List<Inlay> inlays = this.getBlockElementsForVisualLine(visualLine, false);
                int yDiff = point.y - lineBottom;
                for (Inlay inlay : inlays) {
                    int height = inlay.getHeightInPixels();
                    if (yDiff < height) {
                        return inlay;
                    }
                    yDiff -= height;
                }
                throw new IllegalStateException();
            }
        }
        if (hasInlineElements) {
            int offset = this.myEditor.logicalPositionToOffset(this.myEditor.visualToLogicalPosition(visualPosition));
            List<Inlay> inlays = this.getInlineElementsInRange(offset, offset);
            if (inlays.isEmpty()) {
                return null;
            }
            VisualPosition startVisualPosition = this.myEditor.offsetToVisualPosition(offset);
            int x = this.myEditor.visualPositionToXY((VisualPosition)startVisualPosition).x;
            for (Inlay inlay : inlays) {
                int endX = x + inlay.getWidthInPixels();
                if (point.x >= x && point.x < endX) {
                    return inlay;
                }
                x = endX;
            }
        }
        return null;
    }

    public void addListener(@NotNull InlayModel.Listener listener2, @NotNull Disposable disposable) {
        if (listener2 == null) {
            InlayModelImpl.$$$reportNull$$$0(13);
        }
        if (disposable == null) {
            InlayModelImpl.$$$reportNull$$$0(14);
        }
        this.myDispatcher.addListener((EventListener)listener2, disposable);
    }

    private void notifyAdded(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onAdded((Inlay)inlay);
    }

    void notifyChanged(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onUpdated((Inlay)inlay);
    }

    void notifyRemoved(InlayImpl inlay) {
        ((InlayModel.Listener)this.myDispatcher.getMulticaster()).onRemoved((Inlay)inlay);
    }

    public void validateState() {
        for (Inlay inlay : this.getInlineElementsInRange(0, this.myEditor.getDocument().getTextLength())) {
            LOG.assertTrue(!DocumentUtil.isInsideSurrogatePair(this.myEditor.getDocument(), inlay.getOffset()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualPosition";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInlineElementsInRange";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockElementsInRange";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockElementsForVisualLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addInlineElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addBlockElement";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getElementsInRange";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasInlineElementAt";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getInlineElementAt";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementAt";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BlockElementsTree
    extends MarkerTreeWithPartialSums<BlockInlayImpl> {
        BlockElementsTree(Document document) {
            if (document == null) {
                BlockElementsTree.$$$reportNull$$$0(0);
            }
            super(document);
        }

        @Override
        void fireBeforeRemoved(@NotNull BlockInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay == null) {
                BlockElementsTree.$$$reportNull$$$0(1);
            }
            if (reason == null) {
                BlockElementsTree.$$$reportNull$$$0(2);
            }
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                InlayModelImpl.this.notifyRemoved(inlay);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$BlockElementsTree";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fireBeforeRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class InlineElementsTree
    extends HardReferencingRangeMarkerTree<InlineInlayImpl> {
        InlineElementsTree(Document document) {
            if (document == null) {
                InlineElementsTree.$$$reportNull$$$0(0);
            }
            super(document);
        }

        @Override
        @NotNull
        protected HardReferencingRangeMarkerTree.Node<InlineInlayImpl> createNewNode(@NotNull InlineInlayImpl key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
            if (key == null) {
                InlineElementsTree.$$$reportNull$$$0(1);
            }
            HardReferencingRangeMarkerTree.Node<InlineInlayImpl> node = new HardReferencingRangeMarkerTree.Node<InlineInlayImpl>((RangeMarkerTree)this, key, start2, end, greedyToLeft, greedyToRight, stickingToRight){

                @Override
                void addIntervalsFrom(@NotNull IntervalTreeImpl.IntervalNode<InlineInlayImpl> otherNode) {
                    if (otherNode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.addIntervalsFrom(otherNode);
                    if (InlayModelImpl.this.myPutMergedIntervalsAtBeginning) {
                        List added = ContainerUtil.subList((List)this.intervals, (int)(this.intervals.size() - otherNode.intervals.size()));
                        ArrayList addedCopy = new ArrayList(added);
                        added.clear();
                        this.intervals.addAll(0, addedCopy);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherNode", "com/intellij/openapi/editor/impl/InlayModelImpl$InlineElementsTree$1", "addIntervalsFrom"));
                }
            };
            if (node == null) {
                InlineElementsTree.$$$reportNull$$$0(2);
            }
            return node;
        }

        @Override
        void fireBeforeRemoved(@NotNull InlineInlayImpl inlay, @NotNull @NonNls Object reason) {
            if (inlay == null) {
                InlineElementsTree.$$$reportNull$$$0(3);
            }
            if (reason == null) {
                InlineElementsTree.$$$reportNull$$$0(4);
            }
            if (inlay.getUserData(InlayImpl.OFFSET_BEFORE_DISPOSAL) == null) {
                if (InlayModelImpl.this.myMoveInProgress) {
                    InlayModelImpl.this.myInlaysInvalidatedOnMove.add(inlay);
                } else {
                    InlayModelImpl.this.notifyRemoved(inlay);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/editor/impl/InlayModelImpl$InlineElementsTree";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inlay";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reason";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/editor/impl/InlayModelImpl$InlineElementsTree";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNewNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createNewNode";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "fireBeforeRemoved";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

