/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RenamePsiElementProcessor {
    public static final ExtensionPointName<RenamePsiElementProcessor> EP_NAME = ExtensionPointName.create((String)"com.intellij.renamePsiElementProcessor");
    public static final RenamePsiElementProcessor DEFAULT = new RenamePsiElementProcessor(){

        @Override
        public boolean canProcessElement(@NotNull PsiElement element) {
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/rename/RenamePsiElementProcessor$1", "canProcessElement"));
        }
    };

    public abstract boolean canProcessElement(@NotNull PsiElement var1);

    @NotNull
    public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor) {
        if (project == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(0);
        }
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(1);
        }
        RenameDialog renameDialog = new RenameDialog(project, element, nameSuggestionContext, editor);
        if (renameDialog == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(2);
        }
        return renameDialog;
    }

    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(3);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(4);
        }
        if (usages == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(5);
        }
        RenameUtil.doRenameGenericNamedElement(element, newName, usages, listener2);
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, boolean searchInCommentsAndStrings) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(6);
        }
        Collection<PsiReference> collection = this.findReferences(element);
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(8);
        }
        Collection collection = ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.projectScope((Project)element.getProject())).findAll();
        if (collection == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(9);
        }
        return collection;
    }

    @Nullable
    public Pair<String, String> getTextOccurrenceSearchStrings(@NotNull PsiElement element, @NotNull String newName) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(10);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(11);
        }
        return null;
    }

    @Nullable
    public String getQualifiedNameAfterRename(@NotNull PsiElement element, @NotNull String newName, boolean nonJava) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(12);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(13);
        }
        return null;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(14);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(15);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(16);
        }
        this.prepareRenaming(element, newName, allRenames, element.getUseScope());
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames, @NotNull SearchScope scope) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(17);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(18);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(19);
        }
        if (scope == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(20);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(21);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(22);
        }
        if (conflicts == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(23);
        }
    }

    public void findExistingNameConflicts(@NotNull PsiElement element, @NotNull String newName, @NotNull MultiMap<PsiElement, String> conflicts, @NotNull Map<PsiElement, String> allRenames) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(24);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(25);
        }
        if (conflicts == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(26);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(27);
        }
        this.findExistingNameConflicts(element, newName, conflicts);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    @NotNull
    public static List<RenamePsiElementProcessor> allForElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(28);
        }
        ArrayList<RenamePsiElementProcessor> result2 = new ArrayList<RenamePsiElementProcessor>();
        for (RenamePsiElementProcessor processor2 : (RenamePsiElementProcessor[])EP_NAME.getExtensions()) {
            if (!processor2.canProcessElement(element)) continue;
            result2.add(processor2);
        }
        ArrayList<RenamePsiElementProcessor> arrayList = result2;
        if (arrayList == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    @NotNull
    public static RenamePsiElementProcessor forElement(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(30);
        }
        for (RenamePsiElementProcessor processor2 : EP_NAME.getExtensionList()) {
            if (!processor2.canProcessElement(element)) continue;
            RenamePsiElementProcessor renamePsiElementProcessor = processor2;
            if (renamePsiElementProcessor == null) {
                RenamePsiElementProcessor.$$$reportNull$$$0(31);
            }
            return renamePsiElementProcessor;
        }
        RenamePsiElementProcessor renamePsiElementProcessor = DEFAULT;
        if (renamePsiElementProcessor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(32);
        }
        return renamePsiElementProcessor;
    }

    @Nullable
    public Runnable getPostRenameCallback(@NotNull PsiElement element, @NotNull String newName, @NotNull RefactoringElementListener elementListener) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(33);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(34);
        }
        if (elementListener == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(35);
        }
        return null;
    }

    @Nullable
    @NonNls
    public String getHelpID(PsiElement element) {
        if (element instanceof PsiFile) {
            return "refactoring.renameFile";
        }
        return "refactoring.renameDialogs";
    }

    public boolean isToSearchInComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(36);
        }
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE;
    }

    public void setToSearchInComments(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(37);
        }
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(38);
        }
        return element instanceof PsiFileSystemItem && RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE;
    }

    public void setToSearchForTextOccurrences(@NotNull PsiElement element, boolean enabled) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(39);
        }
        if (element instanceof PsiFileSystemItem) {
            RefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_FILE = enabled;
        }
    }

    public boolean showRenamePreviewButton(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(40);
        }
        return true;
    }

    @Nullable
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(41);
        }
        return element;
    }

    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<PsiElement> renameCallback) {
        PsiElement psiElement;
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(42);
        }
        if (editor == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(43);
        }
        if (renameCallback == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(44);
        }
        if ((psiElement = this.substituteElementToRename(element, editor)) == null) {
            return;
        }
        if (!PsiElementRenameHandler.canRename(psiElement.getProject(), editor, psiElement)) {
            return;
        }
        renameCallback.pass((Object)psiElement);
    }

    public void findCollisions(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<? extends PsiElement, String> allRenames, @NotNull List<UsageInfo> result2) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(45);
        }
        if (newName == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(46);
        }
        if (allRenames == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(47);
        }
        if (result2 == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(48);
        }
    }

    public boolean forcesShowPreview() {
        return false;
    }

    @Nullable
    public PsiElement getElementToSearchInStringsAndComments(@NotNull PsiElement element) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(49);
        }
        return element;
    }

    @NotNull
    public UsageInfo createUsageInfo(@NotNull PsiElement element, @NotNull PsiReference ref, @NotNull PsiElement referenceElement) {
        if (element == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(50);
        }
        if (ref == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(51);
        }
        if (referenceElement == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(52);
        }
        MoveRenameUsageInfo moveRenameUsageInfo = new MoveRenameUsageInfo(referenceElement, ref, ref.getRangeInElement().getStartOffset(), ref.getRangeInElement().getEndOffset(), element, ref.resolve() == null && (!(ref instanceof PsiPolyVariantReference) || ((PsiPolyVariantReference)ref).multiResolve(true).length <= 0));
        if (moveRenameUsageInfo == null) {
            RenamePsiElementProcessor.$$$reportNull$$$0(53);
        }
        return moveRenameUsageInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 29: 
            case 31: 
            case 32: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 29: 
            case 31: 
            case 32: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 24: 
            case 28: 
            case 30: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 45: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 29: 
            case 31: 
            case 32: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 22: 
            case 25: 
            case 34: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 16: 
            case 19: 
            case 27: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRenames";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementListener";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renameCallback";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenamePsiElementProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenameDialog";
                break;
            }
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "findReferences";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "allForElement";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRenameDialog";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 29: 
            case 31: 
            case 32: 
            case 53: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "renameElement";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findReferences";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTextOccurrenceSearchStrings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameAfterRename";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "prepareRenaming";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findExistingNameConflicts";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "allForElement";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "forElement";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPostRenameCallback";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchInComments";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchInComments";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isToSearchForTextOccurrences";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setToSearchForTextOccurrences";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "showRenamePreviewButton";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "substituteElementToRename";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findCollisions";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getElementToSearchInStringsAndComments";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createUsageInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 29: 
            case 31: 
            case 32: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

