/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupEditorFilterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Cursor;
import java.awt.dnd.DragSource;
import java.io.File;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XLineBreakpointImpl<P extends XBreakpointProperties>
extends XBreakpointBase<XLineBreakpoint<P>, P, LineBreakpointState<P>>
implements XLineBreakpoint<P> {
    @Nullable
    private RangeHighlighter myHighlighter;
    private final XLineBreakpointType<P> myType;
    private XSourcePosition mySourcePosition;

    public XLineBreakpointImpl(XLineBreakpointType<P> type, XBreakpointManagerImpl breakpointManager, @Nullable P properties, LineBreakpointState<P> state) {
        super(type, breakpointManager, properties, state);
        this.myType = type;
    }

    XLineBreakpointImpl(XLineBreakpointType<P> type, XBreakpointManagerImpl breakpointManager, LineBreakpointState<P> breakpointState) {
        super(type, breakpointManager, breakpointState);
        this.myType = type;
    }

    public void updateUI() {
        MarkupModelEx markupModel;
        RangeHighlighter highlighter;
        if (this.isDisposed() || ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        EditorColorsScheme scheme2 = EditorColorsManager.getInstance().getGlobalScheme();
        TextAttributes attributes = scheme2.getAttributes(DebuggerColors.BREAKPOINT_ATTRIBUTES);
        if (!this.isEnabled()) {
            attributes = attributes.clone();
            attributes.setBackgroundColor(null);
        }
        if (!((highlighter = this.myHighlighter) == null || highlighter.isValid() && DocumentUtil.isValidOffset(highlighter.getStartOffset(), document) && Comparing.equal((Object)highlighter.getTextAttributes(), (Object)attributes))) {
            this.removeHighlighter();
            highlighter = null;
        }
        if (highlighter == null) {
            TextRange lineRange;
            markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.getProject(), true);
            TextRange range2 = this.myType.getHighlightRange((XLineBreakpoint)this);
            if (range2 != null && !range2.isEmpty() && range2.intersects(lineRange = DocumentUtil.getLineTextRange(document, this.getLine()))) {
                highlighter = markupModel.addRangeHighlighter(range2.getStartOffset(), range2.getEndOffset(), 3001, attributes, HighlighterTargetArea.EXACT_RANGE);
            }
            if (highlighter == null) {
                highlighter = markupModel.addPersistentLineHighlighter(this.getLine(), 3001, attributes);
            }
            if (highlighter == null) {
                return;
            }
            highlighter.setGutterIconRenderer(this.createGutterIconRenderer());
            highlighter.putUserData(DebuggerColors.BREAKPOINT_HIGHLIGHTER_KEY, (Object)Boolean.TRUE);
            highlighter.setEditorFilter(MarkupEditorFilterFactory.createIsNotDiffFilter());
            this.myHighlighter = highlighter;
        } else {
            markupModel = null;
        }
        this.updateIcon();
        if (markupModel == null && (markupModel = (MarkupModelEx)DocumentMarkupModel.forDocument(document, this.getProject(), false)) != null) {
            markupModel.fireAttributesChanged((RangeHighlighterEx)highlighter, false, false);
        }
    }

    @Nullable
    private Document getDocument() {
        VirtualFile file2 = this.getFile();
        if (file2 == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file2);
    }

    @Nullable
    public VirtualFile getFile() {
        return VirtualFileManager.getInstance().findFileByUrl(this.getFileUrl());
    }

    @NotNull
    public XLineBreakpointType<P> getType() {
        XLineBreakpointType<P> xLineBreakpointType = this.myType;
        if (xLineBreakpointType == null) {
            XLineBreakpointImpl.$$$reportNull$$$0(0);
        }
        return xLineBreakpointType;
    }

    public int getLine() {
        return ((LineBreakpointState)this.myState).getLine();
    }

    public String getFileUrl() {
        return ((LineBreakpointState)this.myState).getFileUrl();
    }

    public String getPresentableFilePath() {
        String url = this.getFileUrl();
        if (url != null && "file".equals(VirtualFileManager.extractProtocol((String)url))) {
            return FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)url));
        }
        return url != null ? url : "";
    }

    public String getShortFilePath() {
        String path = this.getPresentableFilePath();
        if (path.isEmpty()) {
            return "";
        }
        return new File(path).getName();
    }

    @Nullable
    public RangeHighlighter getHighlighter() {
        return this.myHighlighter;
    }

    @Override
    public XSourcePosition getSourcePosition() {
        if (this.mySourcePosition != null) {
            return this.mySourcePosition;
        }
        this.mySourcePosition = super.getSourcePosition();
        if (this.mySourcePosition == null) {
            this.mySourcePosition = XDebuggerUtil.getInstance().createPosition(this.getFile(), this.getLine());
        }
        return this.mySourcePosition;
    }

    @Override
    public boolean isValid() {
        return this.myHighlighter != null && this.myHighlighter.isValid();
    }

    @Override
    protected void doDispose() {
        this.removeHighlighter();
    }

    private void removeHighlighter() {
        if (this.myHighlighter != null) {
            this.myHighlighter.dispose();
            this.myHighlighter = null;
        }
    }

    @Override
    protected GutterDraggableObject createBreakpointDraggableObject() {
        return new GutterDraggableObject(){

            public boolean copy(int line, VirtualFile file2, int actionId) {
                if (XLineBreakpointImpl.this.canMoveTo(line, file2)) {
                    XDebuggerManagerImpl debuggerManager = (XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)XLineBreakpointImpl.this.getProject());
                    XBreakpointManagerImpl breakpointManager = debuggerManager.getBreakpointManager();
                    if (this.isCopyAction(actionId)) {
                        WriteAction.run(() -> breakpointManager.copyLineBreakpoint(XLineBreakpointImpl.this, file2.getUrl(), line));
                    } else {
                        XLineBreakpointImpl.this.setFileUrl(file2.getUrl());
                        XLineBreakpointImpl.this.setLine(line, true);
                        XDebugSessionImpl session2 = debuggerManager.getCurrentSession();
                        if (session2 != null && session2.getActiveNonLineBreakpoint() == XLineBreakpointImpl.this) {
                            session2.clearActiveNonLineBreakpoint(true);
                        }
                    }
                    return true;
                }
                return false;
            }

            public void remove() {
                XDebuggerUtilImpl.removeBreakpointWithConfirmation(XLineBreakpointImpl.this.getProject(), XLineBreakpointImpl.this);
            }

            public Cursor getCursor(int line, int actionId) {
                if (XLineBreakpointImpl.this.canMoveTo(line, XLineBreakpointImpl.this.getFile())) {
                    return this.isCopyAction(actionId) ? DragSource.DefaultCopyDrop : DragSource.DefaultMoveDrop;
                }
                return DragSource.DefaultMoveNoDrop;
            }

            private boolean isCopyAction(int actionId) {
                return (actionId & 1) == 1;
            }
        };
    }

    private boolean canMoveTo(int line, VirtualFile file2) {
        if (file2 != null && this.myType.canPutAt(file2, line, this.getProject())) {
            XLineBreakpoint<P> existing = this.getBreakpointManager().findBreakpointAtLine(this.myType, file2, line);
            return existing == null || existing == this;
        }
        return false;
    }

    public void updatePosition() {
        if (this.myHighlighter != null && this.myHighlighter.isValid()) {
            this.setLine(this.myHighlighter.getDocument().getLineNumber(this.myHighlighter.getStartOffset()), false);
        }
    }

    public void setFileUrl(String newUrl) {
        if (!Comparing.equal((String)this.getFileUrl(), (String)newUrl)) {
            ((LineBreakpointState)this.myState).setFileUrl(newUrl);
            this.mySourcePosition = null;
            this.removeHighlighter();
            this.fireBreakpointChanged();
        }
    }

    private void setLine(int line, boolean removeHighlighter) {
        if (this.getLine() != line) {
            ((LineBreakpointState)this.myState).setLine(line);
            this.mySourcePosition = null;
            if (removeHighlighter) {
                this.removeHighlighter();
            }
            this.fireBreakpointChanged();
        }
    }

    public boolean isTemporary() {
        return ((LineBreakpointState)this.myState).isTemporary();
    }

    public void setTemporary(boolean temporary) {
        if (this.isTemporary() != temporary) {
            ((LineBreakpointState)this.myState).setTemporary(temporary);
            this.fireBreakpointChanged();
        }
    }

    @Override
    protected void updateIcon() {
        Icon icon = this.calculateSpecialIcon();
        if (icon == null) {
            icon = this.isTemporary() ? this.myType.getTemporaryIcon() : this.myType.getEnabledIcon();
        }
        this.setIcon(icon);
    }

    @Override
    public String toString() {
        return "XLineBreakpointImpl(" + this.myType.getId() + " at " + this.getShortFilePath() + ":" + this.getLine() + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/breakpoints/XLineBreakpointImpl", "getType"));
    }
}

