/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpClassHierarchyUtils {
    private static final NextElementsAppender<PhpClass> SUPER_CLASS_APPENDER_NOT_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            PhpClass superClass;
            if (element == null) {
                1.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((superClass = element.getSuperClass()) != null) {
                phpClasses.add(superClass);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$1";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_CLASS_APPENDER_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            if (element == null) {
                2.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                2.$$$reportNull$$$0(1);
            }
            String superFQN = element.getSuperFQN();
            Project project = element.getProject();
            if (superFQN != null) {
                PhpIndex phpIndex = PhpIndex.getInstance(project);
                phpClasses.addAll(phpIndex.getClassesByFQN(superFQN));
            } else {
                PhpClass myClass = PhpClassHierarchyUtils.getObject(project);
                if (myClass != null) {
                    phpClasses.add(myClass);
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$2";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            String[] interfaceNames;
            if (element == null) {
                3.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                3.$$$reportNull$$$0(1);
            }
            PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
            for (String interfaceName : interfaceNames = element.getInterfaceNames()) {
                Collection<PhpClass> interfacesByFQN = phpIndex.getInterfacesByFQN(interfaceName);
                if (interfacesByFQN.size() != 1) continue;
                phpClasses.add(interfacesByFQN.iterator().next());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$3";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_INTERFACE_APPENDER_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            String[] interfaceNames;
            if (element == null) {
                4.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                4.$$$reportNull$$$0(1);
            }
            PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
            for (String interfaceName : interfaceNames = element.getInterfaceNames()) {
                phpClasses.addAll(phpIndex.getInterfacesByFQN(interfaceName));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$4";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_TRAIT_APPENDER_NOT_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            String[] names;
            if (element == null) {
                5.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                5.$$$reportNull$$$0(1);
            }
            PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
            for (String name : names = element.getTraitNames()) {
                Collection<PhpClass> classes = phpIndex.getTraitsByFQN(name);
                if (classes.size() != 1) continue;
                phpClasses.add(classes.iterator().next());
            }
            ContainerUtil.addAll(phpClasses, (Object[])element.getMixins());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$5";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_TRAIT_APPENDER_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            String[] names;
            if (element == null) {
                6.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                6.$$$reportNull$$$0(1);
            }
            PhpIndex phpIndex = PhpIndex.getInstance(element.getProject());
            for (String name : names = element.getTraitNames()) {
                phpClasses.addAll(phpIndex.getTraitsByFQN(name));
            }
            ContainerUtil.addAll(phpClasses, (Object[])element.getMixins());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$6";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_NOT_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            if (element == null) {
                7.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                7.$$$reportNull$$$0(1);
            }
            SUPER_TRAIT_APPENDER_NOT_AMBIGUITY.appendNextElements(element, phpClasses);
            SUPER_CLASS_APPENDER_NOT_AMBIGUITY.appendNextElements(element, phpClasses);
            SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY.appendNextElements(element, phpClasses);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$7";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final NextElementsAppender<PhpClass> SUPER_APPENDER_AMBIGUITY = new NextElementsAppender<PhpClass>(){

        @Override
        public void appendNextElements(@NotNull PhpClass element, @NotNull Collection<PhpClass> phpClasses) {
            if (element == null) {
                8.$$$reportNull$$$0(0);
            }
            if (phpClasses == null) {
                8.$$$reportNull$$$0(1);
            }
            SUPER_TRAIT_APPENDER_AMBIGUITY.appendNextElements(element, phpClasses);
            SUPER_CLASS_APPENDER_AMBIGUITY.appendNextElements(element, phpClasses);
            SUPER_INTERFACE_APPENDER_AMBIGUITY.appendNextElements(element, phpClasses);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "phpClasses";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/PhpClassHierarchyUtils$8";
            objectArray[2] = "appendNextElements";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private PhpClassHierarchyUtils() {
    }

    public static <T> void process(@NotNull T initialElement, boolean processSelf, @NotNull Processor<? super T> processor, @NotNull NextElementsAppender<T> appender) {
        if (initialElement == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(1);
        }
        if (appender == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(2);
        }
        HashSet processed = new HashSet();
        ArrayDeque<T> processorPool = new ArrayDeque<T>();
        if (processSelf) {
            processorPool.add(initialElement);
        } else {
            appender.appendNextElements(initialElement, processorPool);
        }
        while (processorPool.size() > 0) {
            Object first = processorPool.getFirst();
            if (processed.add(first)) {
                if (processor.process(first)) {
                    appender.appendNextElements(first, processorPool);
                } else {
                    return;
                }
            }
            processorPool.removeFirst();
        }
    }

    public static void processSuperClasses(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(4);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_CLASS_APPENDER_AMBIGUITY : SUPER_CLASS_APPENDER_NOT_AMBIGUITY);
    }

    public static void processSuperInterfaces(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(6);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_INTERFACE_APPENDER_AMBIGUITY : SUPER_INTERFACE_APPENDER_NOT_AMBIGUITY);
    }

    public static void processSupers(@NotNull PhpClass clazz, boolean processSelf, boolean allowAmbiguity, @NotNull Processor<? super PhpClass> processor) {
        if (clazz == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(7);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(8);
        }
        PhpClassHierarchyUtils.process(clazz, processSelf, processor, allowAmbiguity ? SUPER_APPENDER_AMBIGUITY : SUPER_APPENDER_NOT_AMBIGUITY);
    }

    public static boolean isSuperClass(@NotNull PhpClass superClass, @NotNull PhpClass subClass, boolean allowAmbiguity) {
        if (superClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(9);
        }
        if (subClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(10);
        }
        Ref isSuperClassRef = new Ref((Object)false);
        PhpClassHierarchyUtils.processSuperClasses(subClass, false, allowAmbiguity, (Processor<? super PhpClass>)((Processor)curClass -> {
            if (superClass == null) {
                PhpClassHierarchyUtils.$$$reportNull$$$0(23);
            }
            if (PhpClassHierarchyUtils.classesEqual(curClass, superClass)) {
                isSuperClassRef.set((Object)true);
            }
            return (Boolean)isSuperClassRef.get() == false;
        }));
        return (Boolean)isSuperClassRef.get();
    }

    public static boolean processMethods(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyMethodProcessor methodProcessor, boolean processOwnMembersOnly) {
        if (methodProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(11);
        }
        return PhpClassHierarchyUtils.processMembersInternal(phpClass, (THashSet<? super PhpClass>)new THashSet(), null, initialClass, methodProcessor, Method.INSTANCEOF, processOwnMembersOnly);
    }

    public static boolean processFields(PhpClass phpClass, PhpClass initialClass, @NotNull HierarchyFieldProcessor fieldProcessor, boolean processOwnMembersOnly) {
        if (fieldProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(12);
        }
        return PhpClassHierarchyUtils.processMembersInternal(phpClass, (THashSet<? super PhpClass>)new THashSet(), null, initialClass, fieldProcessor, Field.INSTANCEOF, processOwnMembersOnly);
    }

    private static boolean processMembersInternal(@Nullable PhpClass phpClass, @NotNull THashSet<? super PhpClass> visited, @Nullable Map<String, PhpTraitUseRule> conflictResolution, PhpClass initialClass, @NotNull HierarchyMemberProcessor processor, Condition<PsiElement> condition, boolean processOwnMembersOnly) {
        if (visited == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(14);
        }
        if (phpClass == null || !visited.add((Object)phpClass)) {
            return true;
        }
        boolean processMethods = condition == Method.INSTANCEOF;
        for (PhpClassMember member : processMethods ? phpClass.getOwnMethodsMap().values() : phpClass.getOwnFieldMap().values()) {
            PhpTraitUseRule rule;
            PhpTraitUseRule phpTraitUseRule = rule = conflictResolution != null ? conflictResolution.get(member.getFQN()) : null;
            if (rule != null && rule.getAlias() == null && processMethods || !(processMethods ? !((HierarchyMethodProcessor)processor).process((Method)member, phpClass, initialClass) : !((HierarchyFieldProcessor)processor).process((Field)member, phpClass, initialClass))) continue;
            return false;
        }
        if (!processOwnMembersOnly && phpClass.hasTraitUses()) {
            HashMap<String, PhpTraitUseRule> newConflictResolution = new HashMap<String, PhpTraitUseRule>();
            List<PhpTraitUseRule> rules = phpClass.getTraitUseRules();
            for (PhpTraitUseRule rule : rules) {
                if (!rule.isInsteadOf()) {
                    if (!processMethods) continue;
                    List<Method> methods = rule.getMethods();
                    for (Method member : methods) {
                        if (!member.isValid() || ((HierarchyMethodProcessor)processor).process(member, phpClass, initialClass)) continue;
                        return false;
                    }
                    continue;
                }
                MethodReference o = rule.getOriginalReference();
                assert (o != null);
                ClassReference override = rule.getOverride();
                assert (override != null);
                newConflictResolution.put(o.getNamespaceName() + override.getName() + "." + o.getName(), rule);
            }
            for (PhpClass trait : phpClass.getTraits()) {
                if (PhpClassHierarchyUtils.processMembersInternal(trait, visited, newConflictResolution, initialClass, processor, condition, processOwnMembersOnly)) continue;
                return false;
            }
        }
        if (!processOwnMembersOnly) {
            if (!PhpClassHierarchyUtils.processMembersInternal(phpClass.getSuperClass(), visited, null, initialClass, processor, condition, processOwnMembersOnly)) {
                return false;
            }
            for (PhpClass phpInterface : phpClass.getImplementedInterfaces()) {
                if (PhpClassHierarchyUtils.processMembersInternal(phpInterface, visited, null, initialClass, processor, condition, processOwnMembersOnly)) continue;
                return false;
            }
            for (PhpClass mixin : phpClass.getMixins()) {
                if (PhpClassHierarchyUtils.processMembersInternal(mixin, visited, null, initialClass, processor, condition, processOwnMembersOnly)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processOverridingMembers(PhpClassMember member, PhpIndex phpIndex, HierarchyClassMemberProcessor memberProcessor) {
        if (member instanceof Method) {
            if (!PhpClassHierarchyUtils.methodCanHaveOverride((Method)member)) {
                return true;
            }
            String methodName = member.getName();
            PhpClass me = member.getContainingClass();
            if (me != null) {
                ArrayList<PhpClass> allSubclasses = new ArrayList<PhpClass>(phpIndex.getAllSubclasses(me.getFQN()));
                if (me.isTrait()) {
                    allSubclasses.addAll(phpIndex.getTraitUsages(me));
                }
                for (PhpClass myChild : allSubclasses) {
                    Method method;
                    if (myChild == null || (method = myChild.findOwnMethodByName(methodName)) == null || memberProcessor.process(method, myChild, me)) continue;
                    return false;
                }
            }
            return true;
        }
        PhpClass me = member.getContainingClass();
        if (me != null) {
            String fieldName = member.getName();
            Collection<PhpClass> allSubclasses = phpIndex.getAllSubclasses(me.getFQN());
            for (PhpClass myChild : allSubclasses) {
                boolean isConstant;
                Field field = myChild.findOwnFieldByName(fieldName, isConstant = ((Field)member).isConstant());
                if (field == null || memberProcessor.process(field, myChild, me)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean methodCanHaveOverride(@NotNull Method element) {
        if (element == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(15);
        }
        return element.getContainingClass() != null && !element.getAccess().isPrivate();
    }

    public static boolean processSuperMembers(@NotNull PhpClassMember member, @NotNull HierarchyClassMemberProcessor memberProcessor) {
        if (member == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(16);
        }
        if (memberProcessor == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(17);
        }
        THashSet processed = new THashSet();
        String memberName = member.getName();
        boolean fieldIsConstant = member instanceof Field && ((Field)member).isConstant();
        ArrayDeque<PhpClassMember> members = new ArrayDeque<PhpClassMember>();
        members.add(member);
        while (!members.isEmpty()) {
            PhpClass me = ((PhpClassMember)members.poll()).getContainingClass();
            if (me == null) {
                return false;
            }
            List<PhpClass> parents = PhpClassHierarchyUtils.getImmediateParents(me);
            for (PhpClass mySuper : parents) {
                PhpClassMember foundMember;
                if (!processed.add((Object)mySuper) || (foundMember = member instanceof Field ? mySuper.findFieldByName(memberName, fieldIsConstant) : mySuper.findMethodByName(memberName)) == null || foundMember.getModifier().isPrivate()) continue;
                members.add(foundMember);
                if (memberProcessor.process(foundMember, me, mySuper)) continue;
                return false;
            }
        }
        return true;
    }

    public static List<PhpClass> getImmediateParents(PhpClass me) {
        ArrayList<PhpClass> parents = new ArrayList<PhpClass>();
        PhpClass superClass = me.getSuperClass();
        if (superClass != null) {
            parents.add(superClass);
        }
        ContainerUtil.addAll(parents, (Object[])me.getImplementedInterfaces());
        ContainerUtil.addAll(parents, (Object[])me.getTraits());
        return parents;
    }

    public static Collection<PhpClass> getDirectSubclasses(@NotNull PhpClass psiClass) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(18);
        }
        if (psiClass.isFinal()) {
            return Collections.emptyList();
        }
        PhpIndex phpIndex = PhpIndex.getInstance(psiClass.getProject());
        return phpIndex.getDirectSubclasses(psiClass.getFQN());
    }

    public static Collection<PhpClass> getAllSubclasses(@NotNull PhpClass psiClass) {
        if (psiClass == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(19);
        }
        if (psiClass.isFinal()) {
            return Collections.emptyList();
        }
        PhpIndex phpIndex = PhpIndex.getInstance(psiClass.getProject());
        return phpIndex.getAllSubclasses(psiClass.getFQN());
    }

    @Nullable
    public static PhpClass getObject(@NotNull Project project) {
        Iterator<PhpClass> iterator;
        if (project == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(20);
        }
        return (iterator = PhpIndex.getInstance(project).getClassesByFQN("\\___PHPSTORM_HELPERS\\object").iterator()).hasNext() ? iterator.next() : null;
    }

    public static boolean isMyTrait(@NotNull PhpClass me, @NotNull PhpClass trait, @Nullable Collection<? super PhpClass> visited) {
        if (me == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(21);
        }
        if (trait == null) {
            PhpClassHierarchyUtils.$$$reportNull$$$0(22);
        }
        if (!trait.isTrait()) {
            return false;
        }
        if (visited == null) {
            visited = new THashSet();
        }
        for (PhpClass candidate : me.getTraits()) {
            if (!visited.add(candidate) || !PhpClassHierarchyUtils.classesEqual(trait, candidate) && !PhpClassHierarchyUtils.isMyTrait(candidate, trait, (Collection<? super PhpClass>)visited)) continue;
            return true;
        }
        return false;
    }

    public static boolean classesEqual(@Nullable PhpClass one, @Nullable PhpClass another) {
        if (one != null && another != null) {
            if (one == another) {
                return true;
            }
            if (one instanceof PhpClassAlias || another instanceof PhpClassAlias) {
                if (one instanceof PhpClassAlias) {
                    one = ((PhpClassAlias)one).getOriginal();
                }
                if (another instanceof PhpClassAlias) {
                    another = ((PhpClassAlias)another).getOriginal();
                }
                return PhpClassHierarchyUtils.classesEqual(one, another);
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)one.getFQN(), (CharSequence)another.getFQN())) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialElement";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appender";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodProcessor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldProcessor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberProcessor";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "me";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/PhpClassHierarchyUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperInterfaces";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "processSupers";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuperClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "processMethods";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "processFields";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "processMembersInternal";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "methodCanHaveOverride";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperMembers";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "getDirectSubclasses";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllSubclasses";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getObject";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isMyTrait";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$isSuperClass$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface HierarchyMemberProcessor {
    }

    @FunctionalInterface
    public static interface HierarchyFieldProcessor
    extends HierarchyMemberProcessor {
        public boolean process(Field var1, PhpClass var2, PhpClass var3);
    }

    @FunctionalInterface
    public static interface HierarchyMethodProcessor
    extends HierarchyMemberProcessor {
        public boolean process(Method var1, PhpClass var2, PhpClass var3);
    }

    @FunctionalInterface
    public static interface HierarchyClassMemberProcessor
    extends HierarchyMemberProcessor {
        public boolean process(PhpClassMember var1, PhpClass var2, PhpClass var3);
    }

    public static interface NextElementsAppender<T> {
        public void appendNextElements(@NotNull T var1, @NotNull Collection<T> var2);
    }
}

