/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.stubs.impl;

import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.ByteFlagsSerializer;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.resolve.BaseJSSymbolProcessor;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.stubs.JSClassIndex;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingDataStructure;
import com.intellij.lang.javascript.psi.stubs.JSGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElementStructure;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceIncludingLocalMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSNamespaceMembersIndex;
import com.intellij.lang.javascript.psi.stubs.JSNonGlobalSymbolIndex;
import com.intellij.lang.javascript.psi.stubs.JSSubclassIndex;
import com.intellij.lang.javascript.psi.stubs.JSSymbolIndex2;
import com.intellij.lang.javascript.psi.stubs.JSSymbolQualifiedNamesIndex;
import com.intellij.lang.javascript.psi.stubs.JSTypedefIndex;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementStructureImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSQualifiedObjectStubBase;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.SmartList;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSElementIndexingDataStructureImpl
implements JSElementIndexingDataStructure {
    private static final BooleanStructureElement HAS_ELEMENTS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_TYPEDEFS_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_BASE_TYPES_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_CLASS_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement IS_INTERFACE_EXPLICITLY_FLAG = new BooleanStructureElement();
    private static final BooleanStructureElement HAS_USER_STRINGS_FLAG = new BooleanStructureElement();
    private static final FlagsStructure OUR_FLAGS_STRUCTURE = new FlagsStructure(HAS_ELEMENTS_FLAG, HAS_TYPEDEFS_FLAG, HAS_BASE_TYPES_FLAG, IS_CLASS_EXPLICITLY_FLAG, IS_INTERFACE_EXPLICITLY_FLAG, HAS_USER_STRINGS_FLAG);
    @Nullable
    protected final Collection<? extends JSImplicitElementStructure> myElements;
    @Nullable
    protected final Collection<Pair<String, String>> myTypedefs;
    @Nullable
    protected final Collection<Pair<String, String>> myBaseTypes;
    protected final boolean myIsClassExplicitly;
    protected final boolean myIsInterfaceExplicitly;
    @Nullable
    protected final Map<String, String> myUserStrings;

    public JSElementIndexingDataStructureImpl(@Nullable Collection<? extends JSImplicitElementStructure> elements, @Nullable Collection<Pair<String, String>> typedefs, @Nullable Collection<Pair<String, String>> baseTypes, boolean isClassExplicitly, boolean isInterfaceExplicitly, @Nullable Map<String, String> userStrings) {
        this.myElements = elements;
        this.myTypedefs = typedefs;
        this.myBaseTypes = baseTypes;
        this.myIsClassExplicitly = isClassExplicitly;
        this.myIsInterfaceExplicitly = isInterfaceExplicitly;
        this.myUserStrings = userStrings;
    }

    @Nullable
    public static JSElementIndexingDataStructureImpl deserialize(StubInputStream dataStream) throws IOException {
        byte flags = dataStream.readByte();
        Boolean hasElements = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_ELEMENTS_FLAG, flags);
        Boolean hasTypedefs = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_TYPEDEFS_FLAG, flags);
        Boolean hasBaseTypes = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_BASE_TYPES_FLAG, flags);
        Boolean isClassExplicitly = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, IS_CLASS_EXPLICITLY_FLAG, flags);
        Boolean isInterfaceExplicitly = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, IS_INTERFACE_EXPLICITLY_FLAG, flags);
        Boolean hasUserStrings = ByteFlagsSerializer.INSTANCE.readValue(OUR_FLAGS_STRUCTURE, HAS_USER_STRINGS_FLAG, flags);
        if (!(hasElements.booleanValue() || hasTypedefs.booleanValue() || hasBaseTypes.booleanValue() || isClassExplicitly.booleanValue() || isInterfaceExplicitly.booleanValue() || hasUserStrings.booleanValue())) {
            return null;
        }
        SmartList elements = null;
        if (hasElements.booleanValue()) {
            int elementsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (elementsCount > 0);
            elements = new SmartList();
            for (int i = 0; i < elementsCount; ++i) {
                elements.add(JSImplicitElementStructureImpl.deserialize((DataInput)dataStream));
            }
        }
        SmartList typedefs = null;
        if (hasTypedefs.booleanValue()) {
            int typedefsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (typedefsCount > 0);
            typedefs = new SmartList();
            for (int i = 0; i < typedefsCount; ++i) {
                String typeName = dataStream.readNameString();
                String type = dataStream.readNameString();
                typedefs.add(Pair.create((Object)typeName, (Object)type));
            }
        }
        SmartList baseTypes = null;
        if (hasBaseTypes.booleanValue()) {
            int baseTypesCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (baseTypesCount > 0);
            baseTypes = new SmartList();
            for (int i = 0; i < baseTypesCount; ++i) {
                String classNameRef = dataStream.readNameString();
                String baseType = dataStream.readNameString();
                if (classNameRef == null || baseType == null) continue;
                baseTypes.add(Pair.create((Object)classNameRef, (Object)baseType));
            }
        }
        THashMap userStrings = null;
        if (hasUserStrings.booleanValue()) {
            int userStringsCount = DataInputOutputUtil.readINT((DataInput)dataStream);
            assert (userStringsCount > 0);
            userStrings = new THashMap(userStringsCount);
            for (int i = 0; i < userStringsCount; ++i) {
                String keyRef = dataStream.readNameString();
                String valueRef = dataStream.readNameString();
                if (keyRef == null || valueRef == null) continue;
                userStrings.put(keyRef, valueRef);
            }
        }
        return new JSElementIndexingDataStructureImpl((Collection<? extends JSImplicitElementStructure>)elements, (Collection<Pair<String, String>>)typedefs, (Collection<Pair<String, String>>)baseTypes, isClassExplicitly, isInterfaceExplicitly, (Map<String, String>)userStrings);
    }

    public static void serialize(@Nullable JSElementIndexingDataStructure indexingData, StubOutputStream dataStream) throws IOException {
        byte flags = 0;
        if (indexingData == null) {
            dataStream.writeByte((int)flags);
            return;
        }
        ByteFlagsSerializer s = ByteFlagsSerializer.INSTANCE;
        Collection elements = indexingData.getImplicitElements();
        boolean hasImplicitElements = elements != null && !elements.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_ELEMENTS_FLAG, hasImplicitElements, flags);
        Collection typedefs = indexingData.getTypedefs();
        boolean hasTypedefs = typedefs != null && !typedefs.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_TYPEDEFS_FLAG, hasTypedefs, flags);
        Collection baseTypes = indexingData.getBaseTypes();
        boolean hasBaseTypes = baseTypes != null && !baseTypes.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_BASE_TYPES_FLAG, hasBaseTypes, flags);
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, IS_CLASS_EXPLICITLY_FLAG, indexingData.isClassExplicitly(), flags);
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, IS_INTERFACE_EXPLICITLY_FLAG, indexingData.isInterfaceExplicitly(), flags);
        Map userStrings = indexingData.getUserStrings();
        boolean hasUserStrings = userStrings != null && !userStrings.isEmpty();
        flags = s.writeValue(OUR_FLAGS_STRUCTURE, HAS_USER_STRINGS_FLAG, hasUserStrings, flags);
        dataStream.writeByte((int)flags);
        if (hasImplicitElements) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)elements.size());
            for (JSImplicitElementStructure jSImplicitElementStructure : elements) {
                jSImplicitElementStructure.serialize((DataOutput)dataStream);
            }
        }
        if (hasTypedefs) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)typedefs.size());
            for (Pair pair : typedefs) {
                dataStream.writeName((String)pair.first);
                dataStream.writeName((String)pair.second);
            }
        }
        if (hasBaseTypes) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)baseTypes.size());
            for (Pair pair : baseTypes) {
                dataStream.writeName((String)pair.first);
                dataStream.writeName((String)pair.second);
            }
        }
        if (hasUserStrings) {
            DataInputOutputUtil.writeINT((DataOutput)dataStream, (int)userStrings.size());
            for (Map.Entry entry : userStrings.entrySet()) {
                dataStream.writeName((String)entry.getKey());
                dataStream.writeName((String)entry.getValue());
            }
        }
    }

    public static void index(@Nullable JSElementIndexingDataStructure data, @NotNull IndexSink sink) {
        Collection baseTypes;
        Collection typedefs;
        if (sink == null) {
            JSElementIndexingDataStructureImpl.$$$reportNull$$$0(0);
        }
        if (data == null) {
            return;
        }
        Collection elements = data.getImplicitElements();
        if (elements != null) {
            Set indexedNamespaces = null;
            for (JSImplicitElementStructure element : elements) {
                JSElementBase.ClassOrInterface classOrInterface;
                if (JSElementIndexingDataStructureImpl.indexImplicitElement(element, sink)) continue;
                String elementName = element.getName();
                sink.occurrence(JSSymbolIndex2.KEY, (Object)elementName);
                if (JSQualifiedObjectStubBase.doIndexGlobalSymbol((JSElementBase)element)) {
                    sink.occurrence(JSGlobalSymbolIndex.KEY, (Object)elementName);
                }
                if (!element.isNamespaceExplicitlyDeclared() || !BaseJSSymbolProcessor.isGlobalNS(element.getNamespace(), false, false)) {
                    sink.occurrence(JSNonGlobalSymbolIndex.KEY, (Object)elementName);
                }
                if ((classOrInterface = element.isClassOrInterface()) != JSElementBase.ClassOrInterface.NONE) {
                    boolean isInterface = classOrInterface == JSElementBase.ClassOrInterface.INTERFACE;
                    sink.occurrence(JSClassIndex.KEY, (Object)JSClassIndex.getNameToIndex(elementName, isInterface));
                }
                if (element.isNamespaceExplicitlyDeclared()) {
                    String ns;
                    JSQualifiedName namespace = element.getNamespace();
                    String string = ns = namespace != null ? namespace.getQualifiedName() : "";
                    if (indexedNamespaces == null) {
                        indexedNamespaces = new THashSet();
                    }
                    if (indexedNamespaces.add(ns)) {
                        sink.occurrence(JSNamespaceMembersIndex.KEY, (Object)ns);
                        sink.occurrence(JSNamespaceIncludingLocalMembersIndex.KEY, (Object)ns);
                    }
                }
                String qName = element.getQualifiedName();
                sink.occurrence(JSSymbolQualifiedNamesIndex.KEY, (Object)qName.hashCode());
            }
        }
        if ((typedefs = data.getTypedefs()) != null) {
            for (Pair typedef : typedefs) {
                sink.occurrence(JSTypedefIndex.KEY, typedef.first);
            }
        }
        if ((baseTypes = data.getBaseTypes()) != null) {
            THashSet addedBaseTypes = new THashSet();
            THashSet addedSubclasses = new THashSet();
            for (Pair baseType : baseTypes) {
                if (addedBaseTypes.add(baseType.first)) {
                    sink.occurrence(JSBaseTypesIndex.KEY, baseType.first);
                }
                if (!addedSubclasses.add(baseType.second)) continue;
                sink.occurrence(JSSubclassIndex.KEY, baseType.second);
            }
        }
    }

    public static boolean indexImplicitElement(@NotNull JSImplicitElementStructure element, @Nullable IndexSink sink) {
        if (element == null) {
            JSElementIndexingDataStructureImpl.$$$reportNull$$$0(1);
        }
        for (FrameworkIndexingHandler handler : FrameworkIndexingHandler.EP_NAME.getExtensionList()) {
            if (!handler.indexImplicitElement(element, sink)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public Collection<? extends JSImplicitElementStructure> getImplicitElements() {
        return this.myElements;
    }

    @Nullable
    public Collection<Pair<String, String>> getTypedefs() {
        return this.myTypedefs;
    }

    @Nullable
    public Collection<Pair<String, String>> getBaseTypes() {
        return this.myBaseTypes;
    }

    public boolean isClassExplicitly() {
        return this.myIsClassExplicitly;
    }

    public boolean isInterfaceExplicitly() {
        return this.myIsInterfaceExplicitly;
    }

    @Nullable
    public Map<String, String> getUserStrings() {
        return this.myUserStrings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/stubs/impl/JSElementIndexingDataStructureImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "index";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "indexImplicitElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

