/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.ecmascript6.types.JSTypeResolvedHashCodeUtil;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeGuard;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class JSParameterTypeDecoratorImpl
implements JSParameterTypeDecorator {
    public static final JSParameterTypeDecorator EMPTY = new JSParameterTypeDecoratorImpl(null, false, false, false);
    @Nullable
    private final JSType myType;
    private final boolean myOptional;
    private final boolean myRest;
    private final boolean myExplicitlyDeclared;

    public JSParameterTypeDecoratorImpl(@Nullable JSType type, boolean optional, boolean rest, boolean explicitlyDeclared) {
        this.myType = type;
        this.myOptional = optional;
        this.myRest = rest;
        this.myExplicitlyDeclared = explicitlyDeclared;
    }

    @Nullable
    public JSType getType() {
        return this.myType;
    }

    @Nullable
    public JSType getTypeWithOptional() {
        JSType type = this.getType();
        return this.isOptional() ? TypeScriptTypeGuard.wrapWithUndefined(type, null) : type;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    public boolean isRest() {
        return this.myRest;
    }

    public boolean isExplicitlyDeclared() {
        return this.myExplicitlyDeclared;
    }

    public int resolvedHashCode() {
        return Objects.hash(JSTypeResolvedHashCodeUtil.getResolvedHashCodeSafe(this.myType), this.myOptional, this.myRest, this.myExplicitlyDeclared);
    }
}

