/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.settings.DockerPathMapping;
import com.intellij.docker.agent.settings.DockerPathMappingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerVolumeBindingConfigurable
implements Configurable {
    private JPanel myMainPanel;
    private JTextField myContainerPathTextField;
    private TextFieldWithBrowseButton myHostPathTextField;
    private JCheckBox myReadOnlyCheckBox;
    private final DockerVolumeBindingImpl myVolumeBinding;
    private final RemoteServer myServer;

    public DockerVolumeBindingConfigurable(DockerVolumeBindingImpl volumeBinding, RemoteServer server) {
        this.myVolumeBinding = volumeBinding;
        this.myServer = server;
        this.$$$setupUI$$$();
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        final Ref mappingsExistRef = new Ref((Object)false);
        if (this.myServer != null) {
            List<DockerPathMappingImpl> mappings = ((DockerCloudConfiguration)server.getConfiguration()).getPathMappings();
            mappingsExistRef.set((Object)(!ContainerUtil.isEmpty(mappings) ? 1 : 0));
            if (!SystemInfo.isLinux && ((Boolean)mappingsExistRef.get()).booleanValue()) {
                fileDescriptor.setRoots(mappings.stream().filter(Objects::nonNull).map(DockerPathMapping::getLocalPath).filter(Objects::nonNull).map(arg_0 -> ((LocalFileSystem)LocalFileSystem.getInstance()).findFileByPath(arg_0)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> actionListener = new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>("Host Path", "Choose volume host path", (ComponentWithBrowseButton)this.myHostPathTextField, null, fileDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            public void actionPerformed(ActionEvent e) {
                if (SystemInfo.isLinux || ((Boolean)mappingsExistRef.get()).booleanValue()) {
                    super.actionPerformed(e);
                } else {
                    Messages.showWarningDialog((Component)DockerVolumeBindingConfigurable.this.myMainPanel, (String)DockerBundle.getText("DockerVolumeBindingConfigurable.mapping.warning", new Object[0]), (String)"Warning");
                }
            }
        };
        this.myHostPathTextField.addActionListener((ActionListener)actionListener);
        this.myHostPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                DockerVolumeBindingConfigurable.this.updateReadOnlyAvailability();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/settings/DockerVolumeBindingConfigurable$2", "textChanged"));
            }
        });
        this.updateReadOnlyAvailability();
    }

    private void updateReadOnlyAvailability() {
        boolean readOnlyAvailable = StringUtil.isNotEmpty((String)this.myHostPathTextField.getText());
        this.myReadOnlyCheckBox.setEnabled(readOnlyAvailable);
        this.myReadOnlyCheckBox.setSelected(readOnlyAvailable && this.myReadOnlyCheckBox.isSelected());
    }

    @Nls
    public String getDisplayName() {
        return "Volume binding";
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    public boolean isModified() {
        return true;
    }

    public void apply() throws ConfigurationException {
        String containerPath = this.myContainerPathTextField.getText();
        if (StringUtil.isEmpty((String)containerPath)) {
            throw new ConfigurationException("Container path required");
        }
        String hostPath = StringUtil.nullize((String)this.myHostPathTextField.getText());
        this.myVolumeBinding.setContainerPath(containerPath);
        this.myVolumeBinding.setHostPath(DockerVolumeBindingConfigurable.toRemotePath(this.myServer, hostPath));
        this.myVolumeBinding.setReadOnly(this.myReadOnlyCheckBox.isSelected());
    }

    public void reset() {
        this.myContainerPathTextField.setText(this.myVolumeBinding.getContainerPath());
        this.myHostPathTextField.setText(DockerVolumeBindingConfigurable.toLocalPath(this.myServer, this.myVolumeBinding.getHostPath()));
        this.myReadOnlyCheckBox.setSelected(this.myVolumeBinding.isReadOnly());
    }

    public void disposeUIResources() {
    }

    public static String toLocalPath(RemoteServer server, String hostPath) {
        if (server != null && hostPath != null && !SystemInfo.isLinux) {
            for (DockerPathMappingImpl mapping : ((DockerCloudConfiguration)server.getConfiguration()).getPathMappings()) {
                String virtualMachinePath = mapping.getVirtualMachinePath();
                if (!hostPath.startsWith(virtualMachinePath)) continue;
                hostPath = mapping.getLocalPath() + StringUtil.trimStart((String)hostPath, (String)virtualMachinePath);
                return FileUtil.toSystemDependentName((String)hostPath);
            }
        }
        return hostPath;
    }

    private static String toRemotePath(RemoteServer server, String hostPath) {
        if (server != null && hostPath != null && !SystemInfo.isLinux) {
            hostPath = FileUtil.toSystemIndependentName((String)hostPath);
            for (DockerPathMappingImpl mapping : ((DockerCloudConfiguration)server.getConfiguration()).getPathMappings()) {
                String localPath = FileUtil.toSystemIndependentName((String)mapping.getLocalPath());
                if (!hostPath.startsWith(localPath)) continue;
                return FileUtil.normalize((String)(mapping.getVirtualMachinePath() + StringUtil.trimStart((String)hostPath, (String)localPath)));
            }
        }
        return hostPath;
    }

    @Nullable
    public String getHelpTopic() {
        return "reference.docker.deploy.volume-bindings";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JTextField jTextField;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Container path:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myContainerPathTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Host path:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myHostPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myReadOnlyCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Read only");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

