/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.settings;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.remoteServer.util.Column;
import com.intellij.remoteServer.util.JTableWrapper;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;

public abstract class TableWithCardEditor<T, C extends Column<T>> {
    private final JBTable myTable = new JBTable(){

        @NotNull
        public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
            if (renderer == null) {
                1.$$$reportNull$$$0(0);
            }
            if (renderer instanceof DefaultTableCellRenderer) {
                ((DefaultTableCellRenderer)renderer).setForeground(TableWithCardEditor.this.isEditable(row) ? UIUtil.getActiveTextColor() : UIUtil.getInactiveTextColor());
            }
            Component component = super.prepareRenderer(renderer, row, column);
            if (component == null) {
                1.$$$reportNull$$$0(1);
            }
            return component;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/docker/settings/TableWithCardEditor$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/docker/settings/TableWithCardEditor$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareRenderer";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };
    private final JTableWrapper<T, C> myTableWrapper;
    private final JPanel myPanel;
    private List<T> myItems;

    public TableWithCardEditor(C[] columns) {
        this.myTableWrapper = new JTableWrapper(this.myTable, columns);
        AnActionButtonUpdater editActionUpdater = new AnActionButtonUpdater(){

            public boolean isEnabled(@NotNull AnActionEvent e) {
                int[] rows;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (int row : rows = TableWithCardEditor.this.myTable.getSelectedRows()) {
                    if (TableWithCardEditor.this.isEditable(row)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/docker/settings/TableWithCardEditor$2", "isEnabled"));
            }
        };
        this.myPanel = ToolbarDecorator.createDecorator((JTable)this.myTable).setAddAction(button -> this.addItem()).setEditAction(button -> this.editItem()).setRemoveAction(button -> this.removeItem()).setEditActionUpdater(editActionUpdater).setRemoveActionUpdater(editActionUpdater).createPanel();
        this.myPanel.setPreferredSize(new Dimension(-1, 200));
    }

    protected boolean isEditable(int row) {
        return true;
    }

    public JPanel getPanel() {
        return this.myPanel;
    }

    private void addItem() {
        T newItem = this.createItem();
        if (!ShowSettingsUtil.getInstance().editConfigurable((Component)this.myPanel, this.createItemConfigurable(newItem))) {
            return;
        }
        this.myItems.add(newItem);
        this.update(this.myItems.size() - 1);
    }

    private void editItem() {
        int selectedIndex = this.myTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        T selectedItem = this.myItems.get(selectedIndex);
        T editedItem = this.cloneItem(selectedItem);
        if (!ShowSettingsUtil.getInstance().editConfigurable((Component)this.myPanel, this.createItemConfigurable(editedItem))) {
            return;
        }
        this.myItems.set(selectedIndex, editedItem);
        this.update(selectedIndex);
    }

    private void removeItem() {
        int selectedIndex = this.myTable.getSelectedRow();
        if (selectedIndex == -1) {
            return;
        }
        this.myItems.remove(selectedIndex);
        this.update();
    }

    private void update() {
        this.myTableWrapper.setInputRows(this.myItems);
    }

    private void update(int selectedIndex) {
        this.update();
        this.myTable.getSelectionModel().setSelectionInterval(selectedIndex, selectedIndex);
    }

    public void setEnabled(boolean enabled) {
        this.myTable.setEnabled(enabled);
    }

    public void setItems(List<T> items) {
        this.myItems = new ArrayList<T>(items);
        this.update();
    }

    public List<T> getItems() {
        return this.myItems;
    }

    protected abstract T createItem();

    protected abstract T cloneItem(T var1);

    protected abstract Configurable createItemConfigurable(T var1);
}

