/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.blade.injection;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileInfoManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.blade.BladeFileType;
import com.jetbrains.php.lang.PhpFileType;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BladeFileReferenceSet
extends FileReferenceSet {
    @NonNls
    public static final String BLADE_PHP_EXTENSION = ".blade.php";
    private static final FileType[] FILE_TYPES = new FileType[]{BladeFileType.INSTANCE, PhpFileType.INSTANCE};
    private static final String NAMESPACE_SEPARATOR = "::";

    public BladeFileReferenceSet(String str, @NotNull PsiElement element, int startInElement) {
        if (element == null) {
            BladeFileReferenceSet.$$$reportNull$$$0(0);
        }
        super(BladeFileReferenceSet.trimNamespace(str), element, BladeFileReferenceSet.getStartOffset(str, startInElement), null, SystemInfo.isFileSystemCaseSensitive, true, FILE_TYPES);
        this.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, file -> {
            PsiFileSystemItem viewsRoot = BladeFileReferenceSet.findViewsRoot((PsiFileSystemItem)file.getParent());
            return Collections.singleton(viewsRoot == null ? file : viewsRoot);
        });
    }

    @Nullable
    private static PsiFileSystemItem findViewsRoot(PsiFileSystemItem item) {
        PsiFileSystemItem viewsRoot = null;
        while (item != null) {
            if (item.isDirectory() && "views".equals(item.getName())) {
                viewsRoot = item;
                break;
            }
            item = item.getParent();
        }
        return viewsRoot;
    }

    private static String trimNamespace(String fullName) {
        int i = fullName.lastIndexOf(NAMESPACE_SEPARATOR);
        return i < 0 ? fullName : fullName.substring(i + NAMESPACE_SEPARATOR.length());
    }

    private static int getStartOffset(String fullName, int beginningOffset) {
        int i = fullName.lastIndexOf(NAMESPACE_SEPARATOR);
        return i < 0 ? beginningOffset : beginningOffset + i + NAMESPACE_SEPARATOR.length();
    }

    @NotNull
    private String getCurrentPath() {
        PsiFile file = this.getContainingFile();
        if (file == null) {
            if ("" == null) {
                BladeFileReferenceSet.$$$reportNull$$$0(1);
            }
            return "";
        }
        PsiFileSystemItem root = BladeFileReferenceSet.findViewsRoot((PsiFileSystemItem)file);
        if (root == null) {
            String string = file.getName();
            if (string == null) {
                BladeFileReferenceSet.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)VfsUtilCore.getRelativePath((VirtualFile)file.getVirtualFile(), (VirtualFile)root.getVirtualFile()));
        if (string == null) {
            BladeFileReferenceSet.$$$reportNull$$$0(3);
        }
        return string;
    }

    public String getSeparatorString() {
        return ".";
    }

    public FileReference createFileReference(TextRange range, int index, String text) {
        return new BladeFileReference(this, range, index, text);
    }

    public boolean isAbsolutePathReference() {
        return false;
    }

    protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
        return item -> item.isDirectory() || item.getVirtualFile().getFileType() == BladeFileType.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/blade/injection/BladeFileReferenceSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/blade/injection/BladeFileReferenceSet";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BladeFileReference
    extends FileReference {
        private BladeFileReference(BladeFileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
            if (fileReferenceSet == null) {
                BladeFileReference.$$$reportNull$$$0(0);
            }
            super((FileReferenceSet)fileReferenceSet, range, index, text);
        }

        public String getText() {
            FileReferenceSet refSet = this.getFileReferenceSet();
            if (this == refSet.getLastReference()) {
                return super.getText() + BladeFileReferenceSet.BLADE_PHP_EXTENSION;
            }
            return super.getText();
        }

        protected Object createLookupItem(PsiElement candidate) {
            FileReferenceSet refSet = this.getFileReferenceSet();
            if (this == refSet.getLastReference()) {
                if (!(candidate instanceof PsiFile) || !candidate.isPhysical()) {
                    return candidate;
                }
                PsiFile file = (PsiFile)candidate;
                String name = file.getName();
                name = StringUtil.trimEnd((String)name, (String)BladeFileReferenceSet.BLADE_PHP_EXTENSION);
                return FileInfoManager.getFileInfoManager()._getLookupItem(file, name, file.getIcon(0));
            }
            return super.createLookupItem(candidate);
        }

        protected PsiElement rename(String newName) throws IncorrectOperationException {
            newName = StringUtil.trimEnd((String)newName, (String)BladeFileReferenceSet.BLADE_PHP_EXTENSION);
            List newPathPieces = StringUtil.split((String)newName, (String)"/");
            String currentPath = BladeFileReferenceSet.this.getCurrentPath();
            List currentPathPieces = StringUtil.split((String)currentPath, (String)"/");
            currentPathPieces.remove(currentPathPieces.size() - 1);
            while (!newPathPieces.isEmpty() && "..".equals(newPathPieces.get(0))) {
                newPathPieces.remove(0);
                if (currentPathPieces.isEmpty()) continue;
                currentPathPieces.remove(currentPathPieces.size() - 1);
            }
            currentPathPieces.addAll(newPathPieces);
            newName = StringUtil.join((Collection)currentPathPieces, (String)".");
            return super.rename(newName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/jetbrains/php/blade/injection/BladeFileReferenceSet$BladeFileReference", "<init>"));
        }
    }
}

