/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommenter
implements Commenter,
SelfManagingCommenter<MyCommenterData> {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.php.lang.PhpCommenter");
    public static final String LINE_COMMENT_PREFIX = "//";
    public static final String BLOCK_COMMENT_PREFIX = "/*";
    public static final String BLOCK_COMMENT_SUFFIX = "*/";

    public String getLineCommentPrefix() {
        return LINE_COMMENT_PREFIX;
    }

    public String getBlockCommentPrefix() {
        return BLOCK_COMMENT_PREFIX;
    }

    public String getBlockCommentSuffix() {
        return BLOCK_COMMENT_SUFFIX;
    }

    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    public MyCommenterData createLineCommentingState(int startLine, int endLine, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpCommenter.$$$reportNull$$$0(1);
        }
        int lineStartOffset = document.getLineStartOffset(startLine);
        int endOffset = Math.min(document.getLineEndOffset(endLine) + 1, document.getTextLength());
        return PhpCommenter.buildCommenterData(startLine, endLine, document, file, lineStartOffset, endOffset);
    }

    private static MyCommenterData buildCommenterData(int startLine, int endLine, Document document, PsiFile file, int lineStartOffset, int endOffset) {
        IElementType type;
        boolean withinCode;
        Project project = file.getProject();
        boolean addSpace = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE).LINE_COMMENT_ADD_SPACE;
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file.getVirtualFile());
        editorHighlighter.setText(document.getCharsSequence());
        HighlighterIterator iterator = editorHighlighter.createIterator(lineStartOffset);
        List[] lists = new List[endLine - startLine + 1];
        FileViewProvider fileViewProvider = file.getViewProvider();
        PhpLanguage phpLanguage = PhpLanguage.INSTANCE;
        PsiElement at = fileViewProvider.findElementAt(lineStartOffset, (Language)phpLanguage);
        if (at == null && lineStartOffset > 0) {
            at = fileViewProvider.findElementAt(lineStartOffset - 1, (Language)phpLanguage);
        }
        boolean bl = withinCode = at != null && !PhpPsiUtil.isOfType(at.getParent(), PhpElementTypes.HTML) && at.getLanguage() == PhpLanguage.INSTANCE;
        if (at != null && ((type = at.getNode().getElementType()) == PhpTokenTypes.PHP_OPENING_TAG || type == PhpTokenTypes.PHP_ECHO_OPENING_TAG)) {
            withinCode = false;
        }
        int segmentStart = lineStartOffset;
        int writableOffset = 0;
        int currentLine = 0;
        lists[currentLine] = new SmartList();
        while (!iterator.atEnd() && iterator.getEnd() <= endOffset + 1) {
            int segmentEnd;
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == PhpTokenTypes.PHP_OPENING_TAG || tokenType == PhpTokenTypes.PHP_ECHO_OPENING_TAG) {
                if (withinCode) {
                    PhpCommenter.dumpErrorInfo(document, lineStartOffset, endOffset, lineStartOffset + ":");
                    assert (false);
                }
                withinCode = true;
                segmentEnd = iterator.getStart();
                PhpCommenter.addRangeInfo(Math.min(segmentStart, segmentEnd), segmentEnd, writableOffset, PhpCommenter.detectTemplateLanguageAt(fileViewProvider, segmentStart), currentLine, lineStartOffset, document, lists);
                segmentStart = segmentEnd;
                writableOffset = iterator.getEnd() - iterator.getStart();
                if (tokenType == PhpTokenTypes.PHP_ECHO_OPENING_TAG) {
                    --writableOffset;
                } else if (tokenType == PhpTokenTypes.PHP_OPENING_TAG && writableOffset > "<?".length()) {
                    ++writableOffset;
                }
            } else if (tokenType == PhpTokenTypes.PHP_CLOSING_TAG) {
                if (!withinCode) {
                    PhpCommenter.dumpErrorInfo(document, lineStartOffset, endOffset, lineStartOffset + ":");
                    assert (false);
                }
                withinCode = false;
                segmentEnd = iterator.getEnd();
                PhpCommenter.addRangeInfo(segmentStart, segmentEnd, writableOffset, (Language)phpLanguage, currentLine, lineStartOffset, document, lists);
                segmentStart = segmentEnd;
                writableOffset = 0;
            }
            int wsStart = Math.max(iterator.getStart(), lineStartOffset);
            int wsEnd = iterator.getEnd();
            CharSequence docCharSequence = document.getCharsSequence();
            if (PhpCommenter.checkValidRange(docCharSequence, iterator, wsStart, wsEnd)) {
                CharSequence wsText = docCharSequence.subSequence(wsStart, wsEnd);
                int newLines = StringUtil.countChars((CharSequence)wsText, (char)'\n');
                for (int i = 0; i < newLines && lists.length != currentLine + 1; ++i) {
                    lists[++currentLine] = new SmartList();
                }
            }
            iterator.advance();
        }
        int lastMarkerOffset = endOffset + (segmentStart == endOffset ? 1 : 0);
        if (lastMarkerOffset <= document.getTextLength()) {
            PhpCommenter.addRangeInfo(segmentStart, lastMarkerOffset, writableOffset, (Language)(withinCode ? phpLanguage : PhpCommenter.detectTemplateLanguageAt(fileViewProvider, segmentStart)), currentLine, lineStartOffset, document, lists);
            for (int i = currentLine + 1; i < lists.length; ++i) {
                lists[i] = new SmartList();
            }
        }
        return new MyCommenterData(lists, startLine, addSpace);
    }

    private static boolean checkValidRange(@NotNull CharSequence charSequence, @NotNull HighlighterIterator iterator, int start, int end) {
        if (charSequence == null) {
            PhpCommenter.$$$reportNull$$$0(2);
        }
        if (iterator == null) {
            PhpCommenter.$$$reportNull$$$0(3);
        }
        if (start > end || end > charSequence.length()) {
            LOG.error("Invalid PHP commenter range: doc length = " + charSequence.length() + ", start = " + start + ", end = " + end + ", iterator.tokenType = " + iterator.getTokenType() + ", iterator.start = " + iterator.getStart() + ", iterator.end = " + iterator.getEnd() + ", iterator.text = " + charSequence.subSequence(iterator.getStart(), iterator.getEnd()), new Throwable(), new Attachment[]{AttachmentFactory.createContext((Object)charSequence, (Object[])new Object[0])});
            return false;
        }
        return true;
    }

    private static Language detectTemplateLanguageAt(@NotNull FileViewProvider viewProvider, int offset) {
        if (viewProvider == null) {
            PhpCommenter.$$$reportNull$$$0(4);
        }
        if (!(viewProvider instanceof TemplateLanguageFileViewProvider)) {
            LOG.error("TemplateLanguageFileViewProvider expected, got " + viewProvider.getClass().getSimpleName() + " with base language " + viewProvider.getBaseLanguage());
            return viewProvider.getBaseLanguage();
        }
        Language rootLanguage = ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage();
        PsiElement currElement = viewProvider.findElementAt(offset, rootLanguage);
        if (currElement instanceof PsiWhiteSpace) {
            currElement = currElement.getNextSibling();
        }
        return currElement != null && !(currElement instanceof OuterLanguageElement) ? currElement.getLanguage() : rootLanguage;
    }

    private static void dumpErrorInfo(Document document, int lineStartOffset, int endOffset, String s) {
        LOG.error(s + document.getCharsSequence().subSequence(lineStartOffset, endOffset));
    }

    private static void addRangeInfo(int segmentStart, int segmentEnd, int writableOffset, Language templateLanguage, int currentLine, int lineStartOffset, Document document, List<RangeInfo>[] lists) {
        boolean specialCase = segmentStart == lineStartOffset && segmentStart + 1 == segmentEnd && document.getLineEndOffset(document.getLineNumber(segmentStart)) == segmentStart;
        RangeMarker rangeMarker = document.createRangeMarker(segmentStart, !specialCase || segmentEnd < document.getTextLength() ? segmentEnd : segmentEnd - 1, false);
        if (segmentStart == lineStartOffset || specialCase) {
            rangeMarker.setGreedyToLeft(true);
        }
        lists[currentLine].add(new RangeInfo(rangeMarker, templateLanguage, writableOffset));
    }

    public MyCommenterData createBlockCommentingState(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull PsiFile file) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(5);
        }
        if (file == null) {
            PhpCommenter.$$$reportNull$$$0(6);
        }
        int startLine = document.getLineNumber(selectionStart);
        int endLine = document.getLineNumber(selectionStart != selectionEnd ? selectionEnd - 1 : selectionStart);
        MyCommenterData data = PhpCommenter.buildCommenterData(startLine, endLine, document, file, selectionStart, selectionEnd);
        data.myBlockRangeStart = selectionStart;
        return data;
    }

    public void commentLine(final int line, final int offset, final @NotNull Document document, final @NotNull MyCommenterData data) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(7);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(8);
        }
        final int originalLineEndOffset = document.getLineEndOffset(line);
        data.processRangeInfos(document, offset, originalLineEndOffset, new Processor<RangeInfo>(){
            private RangeInfo prev;
            private int lineEndOffset;
            {
                this.lineEndOffset = originalLineEndOffset;
            }

            public boolean process(RangeInfo r) {
                int rEndOffset = ((RangeMarker)r.getFirst()).getEndOffset();
                int nearestEnd = Math.min(this.lineEndOffset, rEndOffset);
                PhpCommenter.lineCommentForPair(this.prev != null ? ((RangeMarker)this.prev.getFirst()).getEndOffset() : offset, nearestEnd, r, document, (Language)PhpLanguage.INSTANCE, data.myAddSpace);
                this.prev = r;
                if (nearestEnd != rEndOffset) {
                    return false;
                }
                this.lineEndOffset = document.getLineEndOffset(line);
                return true;
            }
        });
    }

    private static void lineCommentForPair(int startOffset, int endOffset, RangeInfo rangePair, Document document, Language phpLanguage, boolean addSpace) {
        if (rangePair.second == phpLanguage) {
            if ((startOffset = rangePair.correctToWritableOffset(startOffset)) <= endOffset) {
                int adjustedEndOffset;
                CharSequence text = document.getCharsSequence();
                if (PhpCommenter.containsPhpClosingTagSymbols(text, startOffset, adjustedEndOffset = PhpCommenter.getEndOffsetWithoutPhpClosingTag(text, endOffset))) {
                    document.insertString(adjustedEndOffset, (CharSequence)BLOCK_COMMENT_SUFFIX);
                    document.insertString(startOffset, (CharSequence)BLOCK_COMMENT_PREFIX);
                } else {
                    document.insertString(startOffset, (CharSequence)PhpCommenter.getPhpLineCommentPrefix(document, startOffset, addSpace));
                }
            }
        } else {
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)rangePair.second);
            if (commenter.getLineCommentPrefix() != null) {
                document.insertString(startOffset, (CharSequence)commenter.getLineCommentPrefix());
            } else if (commenter.getBlockCommentPrefix() != null && commenter.getBlockCommentSuffix() != null) {
                document.insertString(endOffset, (CharSequence)commenter.getBlockCommentSuffix());
                document.insertString(startOffset, (CharSequence)commenter.getBlockCommentPrefix());
            }
        }
    }

    private static String getPhpLineCommentPrefix(@NotNull Document document, int offset, boolean addSpace) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(9);
        }
        return addSpace && PhpCommenter.isOnNewLineBeforeNonSpace(document, offset) ? "// " : LINE_COMMENT_PREFIX;
    }

    private static boolean isOnNewLineBeforeNonSpace(@NotNull Document document, int offset) {
        CharSequence documentCharsSequence;
        int nonSpaceIndex;
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(10);
        }
        if ((nonSpaceIndex = CharArrayUtil.shiftBackward((CharSequence)(documentCharsSequence = document.getCharsSequence()), (int)(offset - 1), (String)" \t\r")) >= 0 && documentCharsSequence.charAt(nonSpaceIndex) == '\n' && (nonSpaceIndex = CharArrayUtil.shiftForward((CharSequence)documentCharsSequence, (int)offset, (String)" \t\r")) >= 0) {
            return documentCharsSequence.charAt(nonSpaceIndex) != '\n';
        }
        return false;
    }

    public void uncommentLine(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(11);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(12);
        }
        if (document.getLineNumber(offset) != line) {
            offset = document.getLineStartOffset(line);
        }
        int offsetFinal = offset;
        data.processRangeInfos(document, offsetFinal, document.getLineEndOffset(line), (Processor<RangeInfo>)((Processor)rangeInfo -> {
            if (document == null) {
                PhpCommenter.$$$reportNull$$$0(32);
            }
            if (data == null) {
                PhpCommenter.$$$reportNull$$$0(33);
            }
            int commentStart = Math.max(rangeInfo.getWritableOffset(), offsetFinal);
            Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)rangeInfo.second);
            int markerEndOffset = ((RangeMarker)rangeInfo.getFirst()).getEndOffset();
            int rangeEnd = Math.min(document.getLineEndOffset(line), markerEndOffset);
            String commentPrefix = commenter.getLineCommentPrefix();
            if (commenter instanceof PhpCommenter) {
                commentPrefix = PhpCommenter.getPhpLineCommentPrefix(document, commentStart, data.myAddSpace);
            }
            CharSequence text = document.getCharsSequence();
            if (commentPrefix != null && !PhpCommenter.blockCommentedBecauseOfPhpClosingTag(rangeInfo, document, commentStart, line)) {
                if (CharArrayUtil.regionMatches((CharSequence)text, (int)commentStart, (CharSequence)commentPrefix)) {
                    document.deleteString(commentStart, commentStart + commentPrefix.length());
                } else if (CharArrayUtil.regionMatches((CharSequence)text, (int)commentStart, (CharSequence)commentPrefix.trim())) {
                    document.deleteString(commentStart, commentStart + commentPrefix.trim().length());
                }
            } else {
                int newRangeEnd = commentPrefix == null ? rangeEnd : PhpCommenter.getEndOffsetWithoutPhpClosingTag(text, rangeEnd);
                PhpCommenter.deleteBlockCommentSuffix(commenter, newRangeEnd, document);
                PhpCommenter.deleteBlockCommentPrefix(commenter, commentStart, document);
            }
            return rangeEnd == markerEndOffset;
        }));
    }

    private static void deleteBlockCommentSuffix(Commenter commenter, int rangeEnd, Document document) {
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        if (blockCommentSuffix != null && CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)(rangeEnd - blockCommentSuffix.length()), (CharSequence)blockCommentSuffix)) {
            document.deleteString(rangeEnd - blockCommentSuffix.length(), rangeEnd);
        }
    }

    private static void deleteBlockCommentPrefix(Commenter commenter, int commentStart, Document document) {
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        if (blockCommentPrefix != null && CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)commentStart, (CharSequence)blockCommentPrefix)) {
            document.deleteString(commentStart, commentStart + blockCommentPrefix.length());
        }
    }

    public boolean isLineCommented(int line, int offset, @NotNull Document document, @NotNull MyCommenterData data) {
        String commentPrefix;
        RangeInfo rangePair;
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(13);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(14);
        }
        if ((rangePair = data.findFragmentDescriptorPair(line, offset)) != null && (commentPrefix = PhpCommenter.getCommentPrefix(rangePair)) != null) {
            offset = rangePair.correctToWritableOffset(offset);
            if (CharArrayUtil.regionMatches((CharSequence)document.getCharsSequence(), (int)offset, (CharSequence)commentPrefix)) {
                return true;
            }
            if (PhpCommenter.blockCommentedBecauseOfPhpClosingTag(rangePair, document, offset, line)) {
                return true;
            }
        }
        return false;
    }

    private static boolean blockCommentedBecauseOfPhpClosingTag(@NotNull RangeInfo rangeInfo, @NotNull Document document, int startOffset, int line) {
        if (rangeInfo == null) {
            PhpCommenter.$$$reportNull$$$0(15);
        }
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(16);
        }
        if (rangeInfo.second == PhpLanguage.INSTANCE) {
            CharSequence text = document.getCharsSequence();
            int endOffset = PhpCommenter.getEndOffsetWithoutPhpClosingTag(text, document.getLineEndOffset(line));
            if (CharArrayUtil.regionMatches((CharSequence)text, (int)startOffset, (CharSequence)BLOCK_COMMENT_PREFIX) && CharArrayUtil.regionMatches((CharSequence)text, (int)(endOffset - BLOCK_COMMENT_SUFFIX.length()), (CharSequence)BLOCK_COMMENT_SUFFIX) && PhpCommenter.containsPhpClosingTagSymbols(text, startOffset, endOffset)) {
                return true;
            }
        }
        return false;
    }

    private static int getEndOffsetWithoutPhpClosingTag(@NotNull CharSequence text, int endOffset) {
        if (text == null) {
            PhpCommenter.$$$reportNull$$$0(17);
        }
        if (CharArrayUtil.regionMatches((CharSequence)text, (int)(endOffset - "?>".length()), (CharSequence)"?>")) {
            return endOffset - "?>".length();
        }
        return endOffset;
    }

    private static boolean containsPhpClosingTagSymbols(@NotNull CharSequence text, int startOffset, int endOffset) {
        if (text == null) {
            PhpCommenter.$$$reportNull$$$0(18);
        }
        return CharArrayUtil.indexOf((CharSequence)text, (CharSequence)"?>", (int)startOffset, (int)endOffset) != -1;
    }

    @Nullable
    private static String getCommentPrefix(@NotNull RangeInfo rangePair) {
        Commenter commenter;
        if (rangePair == null) {
            PhpCommenter.$$$reportNull$$$0(19);
        }
        if ((commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)rangePair.second)) != null) {
            String commentPrefix = commenter.getLineCommentPrefix();
            if (commentPrefix == null) {
                commentPrefix = commenter.getBlockCommentPrefix();
            }
            return commentPrefix;
        }
        return null;
    }

    public String getCommentPrefix(int line, @NotNull Document document, @NotNull MyCommenterData data) {
        RangeInfo rangePair;
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(20);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(21);
        }
        return (rangePair = data.findFragmentDescriptorPair(line, document.getLineStartOffset(line))) != null ? PhpCommenter.getCommentPrefix(rangePair) : null;
    }

    private static boolean blockProcess(int selectionStart, int selectionEnd, @NotNull Document document, @NotNull MyCommenterData data, BlockRangeProcessor blockRangeProcessor) {
        Ref lastTemplateRange;
        Ref firstTemplateRange;
        boolean b;
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(22);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(23);
        }
        if ((b = data.processRangeInfos(document, selectionStart, selectionEnd, (Processor<RangeInfo>)((Processor)arg_0 -> PhpCommenter.lambda$blockProcess$1(firstTemplateRange = new Ref(), lastTemplateRange = new Ref(), blockRangeProcessor, document, arg_0)))) && firstTemplateRange.get() != null) {
            b = blockRangeProcessor.processTemplateData((RangeInfo)((Object)firstTemplateRange.get()), (RangeInfo)((Object)lastTemplateRange.get()), document.getCharsSequence());
        }
        return b;
    }

    public TextRange getBlockCommentRange(int selectionStart, final int selectionEnd, @NotNull Document document, @NotNull MyCommenterData data) {
        boolean allRangesAreCommented;
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(24);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(25);
        }
        return (allRangesAreCommented = PhpCommenter.blockProcess(selectionStart, PhpCommenter.fixSelectionEnd(selectionEnd, data), document, data, new BlockRangeProcessor(){

            @Override
            public boolean processPhpBlock(RangeInfo r, CharSequence seq) {
                int writableOffset = r.getWritableOffset();
                if (writableOffset > selectionEnd) {
                    return true;
                }
                int writableEndOffset = r.getWritableEndOffset(seq, true);
                if (writableEndOffset < writableOffset) {
                    return true;
                }
                return this.blockCommented(writableOffset, writableEndOffset, PhpCommenter.BLOCK_COMMENT_PREFIX, PhpCommenter.BLOCK_COMMENT_SUFFIX, seq);
            }

            private boolean blockCommented(int offset, int endOffset, String prefix, String suffix, CharSequence seq) {
                return prefix != null && suffix != null && CharArrayUtil.regionMatches((CharSequence)seq, (int)offset, (CharSequence)prefix) && CharArrayUtil.regionMatches((CharSequence)seq, (int)(endOffset - suffix.length()), (CharSequence)suffix);
            }

            @Override
            public boolean processTemplateData(RangeInfo s, RangeInfo e, CharSequence seq) {
                String blockCommentSuffix = PhpCommenter.getBlockCommentSuffix(s);
                String blockCommentPrefix = PhpCommenter.getBlockCommentPrefix(s);
                return this.blockCommented(s.getWritableOffset(), e.getWritableEndOffset(seq, false), blockCommentPrefix, blockCommentSuffix, seq);
            }
        })) ? new TextRange(selectionStart, selectionEnd) : null;
    }

    public String getBlockCommentPrefix(int selectionStart, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(26);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(27);
        }
        RangeInfo rangePair = data.findFragmentDescriptorPair(document, selectionStart);
        return PhpCommenter.getBlockCommentPrefix(rangePair);
    }

    @Nullable
    private static String getBlockCommentPrefix(@Nullable RangeInfo rangePair) {
        Commenter commenter;
        if (rangePair != null && (commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)rangePair.second)) != null) {
            return commenter.getBlockCommentPrefix();
        }
        return null;
    }

    public String getBlockCommentSuffix(int selectionEnd, @NotNull Document document, @NotNull MyCommenterData data) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(28);
        }
        if (data == null) {
            PhpCommenter.$$$reportNull$$$0(29);
        }
        RangeInfo rangePair = data.findFragmentDescriptorPair(document, PhpCommenter.fixSelectionEnd(selectionEnd, data));
        return PhpCommenter.getBlockCommentSuffix(rangePair);
    }

    private static int fixSelectionEnd(int selectionEnd, MyCommenterData data) {
        return data.myBlockRangeStart != selectionEnd ? selectionEnd - 1 : selectionEnd;
    }

    @Nullable
    private static String getBlockCommentSuffix(@Nullable RangeInfo rangePair) {
        Commenter commenter;
        if (rangePair != null && (commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)rangePair.second)) != null) {
            return commenter.getBlockCommentSuffix();
        }
        return null;
    }

    public void uncommentBlockComment(int startOffset, int endOffset, final Document document, MyCommenterData data) {
        PhpCommenter.blockProcess(startOffset, PhpCommenter.fixSelectionEnd(endOffset, data), document, data, new BlockRangeProcessor(){

            private void uncomment(RangeInfo r, int writableStart, int writableEnd, Document document2) {
                Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage((Language)r.getSecond());
                PhpCommenter.deleteBlockCommentSuffix(commenter, writableEnd, document2);
                PhpCommenter.deleteBlockCommentPrefix(commenter, writableStart, document2);
            }

            @Override
            public boolean processPhpBlock(RangeInfo r, CharSequence seq) {
                this.uncomment(r, r.getWritableOffset(), r.getWritableEndOffset(seq, true), document);
                return true;
            }

            @Override
            public boolean processTemplateData(RangeInfo s, RangeInfo e, CharSequence seq) {
                this.uncomment(s, s.getWritableOffset(), e.getWritableEndOffset(seq, false), document);
                return true;
            }
        });
    }

    @NotNull
    public TextRange insertBlockComment(int startOffset, int endOffset, final Document document, MyCommenterData data) {
        final RangeMarker rangeMarker = document.createRangeMarker(startOffset, endOffset);
        rangeMarker.setGreedyToRight(true);
        rangeMarker.setGreedyToLeft(true);
        PhpCommenter.blockProcess(startOffset, PhpCommenter.fixSelectionEnd(endOffset, data), document, data, new BlockRangeProcessor(){

            @Override
            public boolean processPhpBlock(RangeInfo r, CharSequence seq) {
                int writableOffset = r.getWritableOffset();
                int writableEndOffset = Math.max(writableOffset, r.getWritableEndOffset(seq, true));
                if (writableOffset >= rangeMarker.getEndOffset()) {
                    return true;
                }
                document.insertString(writableEndOffset, (CharSequence)PhpCommenter.BLOCK_COMMENT_SUFFIX);
                document.insertString(writableOffset, (CharSequence)PhpCommenter.BLOCK_COMMENT_PREFIX);
                return true;
            }

            @Override
            public boolean processTemplateData(RangeInfo s, RangeInfo e, CharSequence seq) {
                String commentPrefix = PhpCommenter.getBlockCommentPrefix(s);
                String commentSuffix = PhpCommenter.getBlockCommentSuffix(s);
                if (commentPrefix != null && commentSuffix != null) {
                    document.insertString(e.getWritableEndOffset(seq, false), (CharSequence)commentSuffix);
                    document.insertString(((RangeMarker)s.first).getStartOffset(), (CharSequence)commentPrefix);
                }
                return true;
            }
        });
        TextRange textRange = TextRange.create((Segment)rangeMarker);
        if (textRange == null) {
            PhpCommenter.$$$reportNull$$$0(30);
        }
        return textRange;
    }

    private static /* synthetic */ boolean lambda$blockProcess$1(Ref firstTemplateRange, Ref lastTemplateRange, BlockRangeProcessor blockRangeProcessor, @NotNull Document document, RangeInfo r) {
        if (document == null) {
            PhpCommenter.$$$reportNull$$$0(31);
        }
        if (r.second != PhpLanguage.INSTANCE) {
            if (firstTemplateRange.get() == null) {
                firstTemplateRange.set((Object)r);
            }
            lastTemplateRange.set((Object)r);
            return true;
        }
        return blockRangeProcessor.processPhpBlock(r, document.getCharsSequence());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 8: 
            case 12: 
            case 14: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInfo";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangePair";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpCommenter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpCommenter";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "insertBlockComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentingState";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkValidRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectTemplateLanguageAt";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentingState";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "commentLine";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPhpLineCommentPrefix";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isOnNewLineBeforeNonSpace";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "uncommentLine";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isLineCommented";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "blockCommentedBecauseOfPhpClosingTag";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEndOffsetWithoutPhpClosingTag";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "containsPhpClosingTagSymbols";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCommentPrefix";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "blockProcess";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentRange";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentPrefix";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getBlockCommentSuffix";
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$blockProcess$1";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$uncommentLine$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MyCommenterData
    extends CommenterDataHolder {
        final List<RangeInfo>[] myLists;
        final int myLineIndexOffset;
        int myBlockRangeStart;
        boolean myAddSpace;

        MyCommenterData(List<RangeInfo>[] lists, int lineIndexOffset, boolean addSpace) {
            this.myLists = lists;
            this.myLineIndexOffset = lineIndexOffset;
            this.myAddSpace = addSpace;
        }

        private RangeInfo findFragmentDescriptorPair(Document document, int offset) {
            return this.findFragmentDescriptorPair(document.getLineNumber(offset), offset);
        }

        @Nullable
        private RangeInfo findFragmentDescriptorPair(int line, int lineStart) {
            Pair<RangeInfo, Integer> infoIntegerPair = this.findFragmentDescriptorAndLineIndex(line, lineStart);
            return (RangeInfo)((Object)Pair.getFirst(infoIntegerPair));
        }

        @Nullable
        private Pair<RangeInfo, Integer> findFragmentDescriptorAndLineIndex(int line, int lineStart) {
            RangeInfo pair;
            int lineIndex = line - this.myLineIndexOffset;
            if (lineIndex < 0 || lineIndex >= this.myLists.length) {
                return null;
            }
            int originalLineIndex = lineIndex;
            RangeInfo rangePair = this.findInLine(lineStart, lineIndex);
            if (rangePair == null) {
                if (lineIndex > 0) {
                    --lineIndex;
                    while (lineIndex >= 0 && this.myLists[lineIndex].size() == 0) {
                        --lineIndex;
                    }
                }
                if (lineIndex >= 0 && this.myLists[lineIndex].size() > 0 && MyCommenterData.containsInRange(lineStart, pair = this.myLists[lineIndex].get(this.myLists[lineIndex].size() - 1))) {
                    rangePair = pair;
                }
            }
            if (rangePair == null && (lineIndex = this.skipEmptiesForward(originalLineIndex)) < this.myLists.length && (rangePair = this.findInLine(lineStart, lineIndex)) == null && (lineIndex = this.skipEmptiesForward(lineIndex)) < this.myLists.length && this.myLists[lineIndex].size() > 0 && MyCommenterData.containsInRange(lineStart, pair = this.myLists[lineIndex].get(0))) {
                rangePair = pair;
            }
            return rangePair != null ? new Pair((Object)rangePair, (Object)lineIndex) : null;
        }

        private int skipEmptiesForward(int originalLineIndex) {
            int lineIndex;
            for (lineIndex = originalLineIndex + 1; lineIndex < this.myLists.length && this.myLists[lineIndex].size() == 0; ++lineIndex) {
            }
            return lineIndex;
        }

        private RangeInfo findInLine(int lineStart, int lineIndex) {
            RangeInfo rangePair = null;
            for (RangeInfo pair : this.myLists[lineIndex]) {
                if (!MyCommenterData.containsInRange(lineStart, pair)) continue;
                rangePair = pair;
                break;
            }
            return rangePair;
        }

        private static boolean containsInRange(int lineStart, Pair<RangeMarker, Language> pair) {
            return lineStart >= ((RangeMarker)pair.first).getStartOffset() && lineStart < ((RangeMarker)pair.first).getEndOffset();
        }

        private Collection<RangeInfo> buildRanges(Document document, int startOffset, int endOffset) {
            int line = document.getLineNumber(startOffset);
            Pair<RangeInfo, Integer> startPosition = this.findFragmentDescriptorAndLineIndex(line, startOffset);
            if (startPosition != null) {
                Pair<RangeInfo, Integer> endPosition;
                int endLine = document.getLineNumber(endOffset > 0 ? endOffset - 1 : 0);
                Pair<RangeInfo, Integer> pair = endPosition = startOffset < endOffset ? this.findFragmentDescriptorAndLineIndex(endLine, endOffset - 1) : startPosition;
                if (endPosition != null) {
                    LinkedHashSet<RangeInfo> rangeInfos = new LinkedHashSet<RangeInfo>();
                    RangeInfo rangeInfo = (RangeInfo)((Object)startPosition.first);
                    int atLine = (Integer)startPosition.second;
                    int atPosition = this.myLists[atLine].indexOf((Object)rangeInfo);
                    while (true) {
                        rangeInfos.add(rangeInfo);
                        if (rangeInfo == endPosition.first) break;
                        if (++atPosition == this.myLists[atLine].size()) {
                            atPosition = 0;
                            ++atLine;
                            while (this.myLists[atLine].size() == 0) {
                                ++atLine;
                            }
                        }
                        rangeInfo = this.myLists[atLine].get(atPosition);
                    }
                    return rangeInfos;
                }
            }
            return Collections.emptyList();
        }

        public boolean processRangeInfos(Document document, int lineStartOffset, int lineEndOffset, Processor<RangeInfo> processor) {
            return ContainerUtil.process(this.buildRanges(document, lineStartOffset, lineEndOffset), processor);
        }
    }

    static class RangeInfo
    extends Pair<RangeMarker, Language> {
        private final int myActualCodeOffset;

        RangeInfo(RangeMarker first, Language second, int actualCodeOffset) {
            super((Object)first, (Object)second);
            first.setGreedyToRight(true);
            this.myActualCodeOffset = actualCodeOffset;
        }

        public int getWritableOffset() {
            return ((RangeMarker)this.first).getStartOffset() + this.myActualCodeOffset;
        }

        public int correctToWritableOffset(int startOffset) {
            if (startOffset == ((RangeMarker)this.first).getStartOffset()) {
                startOffset += this.myActualCodeOffset;
            }
            return startOffset;
        }

        public int getWritableEndOffset(CharSequence chars, boolean incode) {
            int offset = ((RangeMarker)this.first).getEndOffset();
            if (incode) {
                if (CharArrayUtil.regionMatches((CharSequence)chars, (int)(offset - "?>".length()), (CharSequence)"?>")) {
                    offset -= "?>".length();
                } else if (offset > 0 && chars.charAt(offset - 1) == '\n') {
                    --offset;
                }
            }
            return offset;
        }
    }

    static interface BlockRangeProcessor {
        public boolean processPhpBlock(RangeInfo var1, CharSequence var2);

        public boolean processTemplateData(RangeInfo var1, RangeInfo var2, CharSequence var3);
    }
}

