/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocPsiElementImpl;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocTypeImpl
extends PhpDocPsiElementImpl
implements PhpDocType {
    private static final ResolveCache.PolyVariantResolver<PhpDocType> MY_RESOLVER = (expression, incompleteCode) -> PsiElementResolveResult.createResults((Collection)expression.resolveGlobal(incompleteCode));

    public PhpDocTypeImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor psiElementVisitor) {
        if (psiElementVisitor == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(0);
        }
        if (psiElementVisitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)psiElementVisitor).visitPhpDocType((PhpDocType)this);
        } else {
            super.accept(psiElementVisitor);
        }
    }

    @NotNull
    public PsiElement getElement() {
        PhpDocTypeImpl phpDocTypeImpl = this;
        if (phpDocTypeImpl == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(1);
        }
        return phpDocTypeImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            PsiElement psi = nameNode.getPsi();
            int startOffset = psi != null ? psi.getStartOffsetInParent() : 0;
            TextRange textRange = new TextRange(startOffset, startOffset + nameNode.getTextLength());
            if (textRange == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        TextRange textRange = new TextRange(0, this.getTextLength());
        if (textRange == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(3);
        }
        return textRange;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        if (!incompleteCode) {
            ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
            if (resolveResultArray == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = MY_RESOLVER.resolve((PsiPolyVariantReference)this, true);
        if (resolveResultArray == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(5);
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode nameNode;
        if (newElementName == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(7);
        }
        if ((nameNode = this.getNameNode()) != null && !newElementName.equals(nameNode.getText())) {
            String text = "/** " + newElementName + " */";
            PsiElement renamed = PhpPsiElementFactory.createFromText(this.getProject(), nameNode.getElementType(), text);
            nameNode.getTreeParent().replaceChild(nameNode, renamed.getNode());
        }
        return this;
    }

    @Nullable
    public ASTNode getNameNode() {
        PsiElement child = this.findChildByType(PhpDocTokenTypes.DOC_IDENTIFIER);
        if (child == null) {
            child = this.findChildByType(PhpDocTokenTypes.DOC_VARIABLE);
        }
        if (child != null) {
            return child.getNode();
        }
        return null;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        Collection<? extends PhpNamedElement> collection = PhpDocTypeImpl.resolveLocal(this);
        if (collection == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = PhpCodeInsightUtil.getLocalType((PhpReference)this);
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> resolveLocal(@NotNull PhpDocType docType) {
        String text;
        if (docType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(10);
        }
        if ((text = docType.getText()) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        String name = docType.getName();
        if (name != null && PhpType.isPrimitiveType((String)name) && !PhpLangUtil.mayBeReferenceToUserDefinedClass(name, docType.getProject())) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(12);
            }
            return set;
        }
        Set<? extends PhpNamedElement> set = ClassReferenceImpl.resolveLocal((PhpReference)docType, name, PhpDocTypeImpl.getNamespaceName(docType, false));
        if (set == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(13);
        }
        return set;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        String text = this.getText();
        if (text == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(14);
            }
            return set;
        }
        String name = this.getName();
        Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveGlobal((PhpReference)this, name, PhpDocTypeImpl.getNamespaceName(this, false), false);
        if (collection == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(15);
        }
        return collection;
    }

    @NotNull
    public String getSignature() {
        if ("" == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(16);
        }
        return "";
    }

    @NotNull
    public String getName() {
        ASTNode node = this.getNameNode();
        String string = node != null ? node.getText() : "";
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    public String getNamespaceName() {
        String string = PhpDocTypeImpl.getNamespaceName(this, true);
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String getNamespaceName(@NotNull PhpDocType type, boolean checkPrimitives) {
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(19);
        }
        String string = PhpReferenceImpl.findNamespaceName(PhpDocTypeImpl.getImmediateNamespaceName(type, checkPrimitives), (PhpPsiElement)type);
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public String getImmediateNamespaceName() {
        String string = PhpDocTypeImpl.getImmediateNamespaceName(this, true);
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static String getImmediateNamespaceName(@NotNull PhpDocType type, boolean checkPrimitives) {
        PhpNamespaceReference reference;
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(22);
        }
        return (reference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)type, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF)) != null ? reference.getFullName() : (checkPrimitives && PhpType.isPrimitiveType((String)type.getName()) ? "\\" : "");
    }

    public boolean isAbsolute() {
        String local = this.getImmediateNamespaceName();
        return StringUtil.startsWithChar((CharSequence)local, (char)'\\');
    }

    @NotNull
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(23);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(24);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(25);
        }
        if (element instanceof PhpClass) {
            if (PhpLangUtil.equalsClassNames(this.getFQN(), ((PhpClass)element).getFQN())) {
                return true;
            }
            return Arrays.stream(this.multiResolve(false)).anyMatch(result -> {
                if (element == null) {
                    PhpDocTypeImpl.$$$reportNull$$$0(28);
                }
                return result.isValidResult() && result.getElement() == element;
            });
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = this.multiResolve(true);
        if (objectArray == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(26);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public PhpType getType() {
        String aClass;
        String name = this.getName();
        PhpType type = new PhpType();
        if ("self".equals(name) && this.isForTraitMethod()) {
            aClass = "static";
        } else if ("parent".equals(name)) {
            aClass = "parent";
        } else if ("static".equals(name)) {
            aClass = "static";
        } else if ("$this".equals(name)) {
            aClass = "$this";
        } else {
            Collection<? extends PhpNamedElement> elements = PhpDocTypeImpl.resolveLocal(this);
            if (elements.size() > 0) {
                PhpType type1 = elements.iterator().next().getType();
                aClass = type1.toString();
            } else {
                aClass = "self".equals(name) ? "self" : PhpDocUtil.getTypeString(this.getNamespaceName() + name, this);
            }
        }
        String text = this.getText();
        int plural = text.indexOf("[");
        if (plural >= 0) {
            aClass = aClass + text.substring(plural);
        }
        type.add(aClass);
        PhpType phpType = type;
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(27);
        }
        return phpType;
    }

    private boolean isForTraitMethod() {
        PhpClass containingClass;
        PhpPsiElement next = PhpPsiElementImpl.findNextPhpPsiElement(this.getParent().getParent().getNextSibling());
        return next instanceof Method && (containingClass = ((Method)next).getContainingClass()) != null && containingClass.isTrait();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocTypeImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 24: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignature";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateNamespaceName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceName";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateNamespaceName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isReferenceTo$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

