/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor.enterHandlers;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.jetbrains.php.lang.editor.enterHandlers.PhpEnterHandlerBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCommentEnterHandler
extends PhpEnterHandlerBase {
    private static final String END_OF_COMMENT = "*/";

    @Override
    public boolean beforeEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext, @NotNull Project project, @NotNull Document document, int lineNumber, int caret, @NotNull PsiElement comment) {
        boolean addAsterisk;
        ASTNode commentNode;
        if (file == null) {
            PhpCommentEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpCommentEnterHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PhpCommentEnterHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpCommentEnterHandler.$$$reportNull$$$0(3);
        }
        if (document == null) {
            PhpCommentEnterHandler.$$$reportNull$$$0(4);
        }
        if (comment == null) {
            PhpCommentEnterHandler.$$$reportNull$$$0(5);
        }
        if ((commentNode = comment.getNode()) == null || commentNode.getElementType() != C_STYLE_COMMENT) {
            return false;
        }
        if (comment.getTextRange().getStartOffset() >= caret) {
            return false;
        }
        if (comment.getText().endsWith(END_OF_COMMENT) && comment.getTextRange().getEndOffset() <= caret) {
            return false;
        }
        PsiWhiteSpace whiteSpaceBefore = PhpCommentEnterHandler.getWhitespaceBefore(comment);
        String whitespace = "";
        if (whiteSpaceBefore != null) {
            whitespace = whiteSpaceBefore.getText();
            int lastLfPos = (whitespace = StringUtil.trimEnd((String)whitespace, (String)"\n")).lastIndexOf(10);
            if (lastLfPos > -1) {
                whitespace = whitespace.substring(lastLfPos + 1);
            }
        }
        PhpEnterHandlerBase.CommentInserter commentInserter = new PhpEnterHandlerBase.CommentInserter(project, document, editor, lineNumber);
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        if (lineStart > caret || lineEnd < caret) {
            return false;
        }
        String lineBeforeCaret = StringUtil.trimLeading((String)document.getText(new TextRange(lineStart, caret)));
        String lineAfterCaret = document.getText(new TextRange(caret, lineEnd)).trim();
        boolean bl = addAsterisk = lineBeforeCaret.startsWith("*") || "/*".equals(lineBeforeCaret);
        if (comment.getText().endsWith(END_OF_COMMENT) && comment.getTextOffset() + comment.getText().lastIndexOf("/*") < caret) {
            commentInserter.insertLine(whitespace, "", addAsterisk, false, addAsterisk ? "* " : "");
        } else if (addAsterisk) {
            commentInserter.insertLine(whitespace, "\n" + whitespace + " " + END_OF_COMMENT, true, false, "* ");
            editor.getCaretModel().moveCaretRelatively(0, -1, false, false, true);
        } else if (lineBeforeCaret.trim().equals("/*") && lineAfterCaret.isEmpty()) {
            commentInserter.insertLine(whitespace, "\n" + whitespace + END_OF_COMMENT, false, false, "");
            editor.getCaretModel().moveCaretRelatively(-END_OF_COMMENT.length(), -1, false, false, true);
        } else {
            commentInserter.insertLine(whitespace, "", false, false, "");
        }
        commentInserter.commitChanges();
        return true;
    }

    @Nullable
    private static PsiWhiteSpace getWhitespaceBefore(@NotNull PsiElement element) {
        PsiElement prev;
        if (element == null) {
            PhpCommentEnterHandler.$$$reportNull$$$0(6);
        }
        if ((prev = element.getPrevSibling()) instanceof PsiWhiteSpace) {
            return (PsiWhiteSpace)prev;
        }
        PsiElement parent = element.getParent();
        if (parent != null && !(parent instanceof PsiFile)) {
            return PhpCommentEnterHandler.getWhitespaceBefore(parent);
        }
        return null;
    }

    @Override
    public EnterHandlerDelegate.Result getNextAction() {
        return EnterHandlerDelegate.Result.Stop;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/editor/enterHandlers/PhpCommentEnterHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeEnter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getWhitespaceBefore";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

