/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections.probablyBug.missingParentCall;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public abstract class PhpMissingParentAbstractInspection
extends PhpInspection {
    private static boolean isParentCall(PhpCallInstruction instruction, @NotNull PhpClass parent, @NotNull String name) {
        PsiElement resolve;
        MethodReference mReference;
        String mReferenceName;
        FunctionReference functionReference;
        if (parent == null) {
            PhpMissingParentAbstractInspection.$$$reportNull$$$0(0);
        }
        if (name == null) {
            PhpMissingParentAbstractInspection.$$$reportNull$$$0(1);
        }
        if ((functionReference = instruction.getFunctionReference()) instanceof MethodReference && (mReferenceName = (mReference = (MethodReference)functionReference).getName()) != null && mReferenceName.equals(name) && (resolve = mReference.resolve()) instanceof Method) {
            PhpClass aClass = ((Method)resolve).getContainingClass();
            if (aClass != null) {
                return aClass.equals(parent);
            }
            return false;
        }
        return false;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpMissingParentAbstractInspection.$$$reportNull$$$0(2);
        }
        PhpElementVisitor phpElementVisitor = new PhpElementVisitor(){

            public void visitPhpClass(PhpClass clazz) {
                super.visitPhpClass(clazz);
                PhpClass superClass = clazz.getSuperClass();
                if (superClass != null) {
                    for (Method it : clazz.getOwnMethods()) {
                        PsiElement nameIdentifier;
                        String name;
                        Method superClassMethodByName;
                        if (!PhpMissingParentAbstractInspection.this.isMethodToCheck(it) || it instanceof PhpDocMethod || (superClassMethodByName = superClass.findMethodByName((CharSequence)(name = it.getName()))) == null || superClassMethodByName.isAbstract() || superClassMethodByName instanceof PhpDocMethod) continue;
                        final Ref answer = new Ref((Object)false);
                        PhpControlFlowUtil.processFlow(it.getControlFlow(), new PhpInstructionProcessor(){

                            public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                                PhpClass superMethodClass = superClassMethodByName.getContainingClass();
                                if (superMethodClass != null && PhpMissingParentAbstractInspection.isParentCall(instruction, superMethodClass, name)) {
                                    answer.set((Object)true);
                                    return false;
                                }
                                return true;
                            }
                        });
                        if (((Boolean)answer.get()).booleanValue() || (nameIdentifier = it.getNameIdentifier()) == null) continue;
                        holder.registerProblem(nameIdentifier, PhpBundle.message("inspection.missing.parent.call.message", new Object[0]), new LocalQuickFix[0]);
                    }
                }
            }
        };
        if (phpElementVisitor == null) {
            PhpMissingParentAbstractInspection.$$$reportNull$$$0(3);
        }
        return phpElementVisitor;
    }

    abstract boolean isMethodToCheck(Method var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/probablyBug/missingParentCall/PhpMissingParentAbstractInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/probablyBug/missingParentCall/PhpMissingParentAbstractInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isParentCall";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

