/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.psi.elements.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.PhpExpressionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringLiteralExpressionImpl
extends PhpExpressionImpl
implements StringLiteralExpression {
    private String contents;

    public StringLiteralExpressionImpl(ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof PhpElementVisitor) {
            ((PhpElementVisitor)visitor).visitPhpStringLiteralExpression((StringLiteralExpression)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean isValidHost() {
        int length = this.getTextLength();
        if (this.isHeredoc()) {
            return length > 7;
        }
        ASTNode node = this.getNode();
        if (node.getElementType() == PhpDocElementTypes.phpDocString) {
            CharSequence text = node.getChars();
            return length >= 2 && StringUtil.startsWithChar((CharSequence)text, (char)'\"') && StringUtil.endsWithChar((CharSequence)text, (char)'\"');
        }
        ASTNode[] children = node.getChildren(null);
        return children.length >= 2 && PhpTokenTypes.tsSTRING_EDGE.contains(children[0].getElementType()) && PhpTokenTypes.tsSTRING_EDGE.contains(children[children.length - 1].getElementType());
    }

    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        if (text == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(1);
        }
        if (this.isHeredoc()) {
            if (!text.startsWith("<<<")) {
                text = "echo <<<" + this.getName() + "\n" + text + "\n" + this.getName() + ";\n";
            } else if (!text.endsWith("\n")) {
                text = text + "\n";
            }
        } else {
            text = StringUtil.unquoteString((String)text);
            char q = this.getNode().getChars().charAt(0);
            text = text.replaceAll(Character.toString(q), "\\\\" + q);
            text = q + text + q;
        }
        StringLiteralExpression newExpr = PhpPsiElementFactory.createFirstFromText(this.getProject(), StringLiteralExpression.class, text);
        assert (newExpr != null) : text;
        this.replace((PsiElement)newExpr);
        return newExpr;
    }

    @NotNull
    public LiteralTextEscaper<? extends PsiLanguageInjectionHost> createLiteralTextEscaper() {
        StringLiteralEscaper stringLiteralEscaper = new StringLiteralEscaper((PsiLanguageInjectionHost)this);
        if (stringLiteralEscaper == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(2);
        }
        return stringLiteralEscaper;
    }

    @NotNull
    public TextRange getValueRange() {
        if (!this.isHeredoc()) {
            TextRange textRange = new TextRange(1, Math.max(1, this.getTextLength() - 1));
            if (textRange == null) {
                StringLiteralExpressionImpl.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        PsiElement firstChild = this.getFirstChild();
        assert (firstChild != null) : this.getText();
        int s = firstChild.getTextLength();
        PsiElement end = this.findChildByType(PhpTokenTypes.HEREDOC_END);
        int e = end != null ? this.getTextLength() - end.getTextLength() : this.getTextLength();
        TextRange textRange = new TextRange(s, e);
        if (textRange == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.contents = null;
    }

    @NotNull
    public String getContents() {
        if (this.contents == null) {
            this.contents = this.getValueRange().substring(this.getText());
        }
        String string = this.contents;
        if (string == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isHeredoc() {
        return this.getNode().getElementType() == HEREDOC;
    }

    public boolean isSingleQuote() {
        PsiElement first = this.getFirstChild();
        IElementType firstType = first.getNode().getElementType();
        return firstType == PhpTokenTypes.chLSINGLE_QUOTE || firstType == PhpTokenTypes.HEREDOC_START && first.textToCharArray()[0] == '\'';
    }

    public String getName() {
        if (this.isHeredoc()) {
            String text;
            PsiElement firstChild = this.getFirstChild();
            assert (firstChild != null) : this.getText();
            if ((text = text.substring((text = firstChild.getText().trim()).charAt(3) == ' ' ? 4 : 3)).charAt(0) == '\'' || text.charAt(0) == '\"') {
                text = text.substring(1, text.length() - 1);
            }
            return text;
        }
        return null;
    }

    public static boolean parseStringCharacters(@NotNull String chars, @NotNull StringBuilder outChars, @Nullable int[] sourceOffsets, boolean isHeredoc, boolean isSingleQuote) {
        if (chars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(6);
        }
        if (outChars == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(7);
        }
        assert (sourceOffsets == null || sourceOffsets.length == chars.length() + 1);
        if (chars.indexOf(92) < 0) {
            outChars.append(chars);
            if (sourceOffsets != null) {
                for (int i = 0; i < sourceOffsets.length; ++i) {
                    sourceOffsets[i] = i;
                }
            }
            return true;
        }
        int index = 0;
        int outOffset = outChars.length();
        while (index < chars.length()) {
            char c = chars.charAt(index++);
            if (sourceOffsets != null) {
                sourceOffsets[outChars.length() - outOffset] = index - 1;
                sourceOffsets[outChars.length() + 1 - outOffset] = index;
            }
            if (c != '\\') {
                outChars.append(c);
                continue;
            }
            if (index == chars.length()) {
                return false;
            }
            c = chars.charAt(index++);
            switch (c) {
                case 'b': {
                    outChars.append('\b');
                    break;
                }
                case 't': {
                    outChars.append('\t');
                    break;
                }
                case 'n': {
                    outChars.append('\n');
                    break;
                }
                case 'f': {
                    outChars.append('\f');
                    break;
                }
                case 'r': {
                    outChars.append('\r');
                    break;
                }
                case '\"': {
                    if (isHeredoc) {
                        outChars.append('\\');
                    }
                    outChars.append('\"');
                    break;
                }
                case '\'': {
                    if (!isSingleQuote || isHeredoc) {
                        outChars.append('\\');
                    }
                    outChars.append('\'');
                    break;
                }
                case '\\': {
                    outChars.append('\\');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    char startC = c;
                    int v = c - 48;
                    if (index < chars.length()) {
                        if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                            v <<= 3;
                            v += c - 48;
                            if (startC <= '3' && index < chars.length()) {
                                if ('0' <= (c = chars.charAt(index++)) && c <= '7') {
                                    v <<= 3;
                                    v += c - 48;
                                } else {
                                    --index;
                                }
                            }
                        } else {
                            --index;
                        }
                    }
                    outChars.append((char)v);
                    break;
                }
                case 'x': {
                    if (index + 2 <= chars.length()) {
                        try {
                            int code = Integer.parseInt(chars.substring(index, index + 2), 16);
                            if (code == 10 || code == 13) {
                                return false;
                            }
                            c = chars.charAt(index);
                            if (c == '+' || c == '-') {
                                return false;
                            }
                            outChars.append((char)code);
                            index += 2;
                            break;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                    return false;
                }
                default: {
                    outChars.append('\\');
                    outChars.append(c);
                }
            }
            if (sourceOffsets == null) continue;
            sourceOffsets[outChars.length() - outOffset] = index;
        }
        return true;
    }

    @NotNull
    public PsiReference[] getReferences() {
        PsiReference[] psiReferenceArray = ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this);
        if (psiReferenceArray == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(8);
        }
        return psiReferenceArray;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType phpType = PhpType.STRING;
        if (phpType == null) {
            StringLiteralExpressionImpl.$$$reportNull$$$0(9);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/psi/elements/impl/StringLiteralExpressionImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/StringLiteralExpressionImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContents";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseStringCharacters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class StringLiteralEscaper
    extends LiteralTextEscaper<StringLiteralExpression> {
        private int[] outSourceOffsets;

        protected StringLiteralEscaper(@NotNull PsiLanguageInjectionHost host) {
            if (host == null) {
                StringLiteralEscaper.$$$reportNull$$$0(0);
            }
            super((PsiLanguageInjectionHost)((StringLiteralExpression)host));
        }

        public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
            if (rangeInsideHost == null) {
                StringLiteralEscaper.$$$reportNull$$$0(1);
            }
            if (outChars == null) {
                StringLiteralEscaper.$$$reportNull$$$0(2);
            }
            String text = rangeInsideHost.substring(((StringLiteralExpression)this.myHost).getText());
            outChars.ensureCapacity(text.length());
            this.outSourceOffsets = new int[text.length() + 1];
            try {
                boolean b = StringLiteralExpressionImpl.parseStringCharacters(text, outChars, this.outSourceOffsets, ((StringLiteralExpression)this.myHost).isHeredoc(), ((StringLiteralExpression)this.myHost).isSingleQuote());
                return b;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException("Error decoding " + text + " out = " + outChars, e);
            }
        }

        public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
            int result;
            if (rangeInsideHost == null) {
                StringLiteralEscaper.$$$reportNull$$$0(3);
            }
            int n = result = offsetInDecoded < this.outSourceOffsets.length ? this.outSourceOffsets[offsetInDecoded] : -1;
            if (result == -1) {
                return -1;
            }
            return (result <= rangeInsideHost.getLength() ? result : rangeInsideHost.getLength()) + rangeInsideHost.getStartOffset();
        }

        public boolean isOneLine() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "host";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideHost";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outChars";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/psi/elements/impl/StringLiteralExpressionImpl$StringLiteralEscaper";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "decode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOffsetInHost";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

