/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.navigation;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.Collection;

public class PhpQualifiedNameProvider
implements QualifiedNameProvider {
    public static final String SEPARATOR = "::";

    public PsiElement adjustElementToCopy(PsiElement element) {
        return element instanceof PhpNamedElement ? element : null;
    }

    public String getQualifiedName(PsiElement element) {
        return element instanceof PhpNamedElement ? ((PhpNamedElement)element).getFQN().replace(".", SEPARATOR) : null;
    }

    public PsiElement qualifiedNameToElement(String fqn, Project project) {
        int separator = fqn.indexOf(SEPARATOR);
        String memberName = separator >= 0 ? fqn.substring(separator + SEPARATOR.length()) : null;
        fqn = separator >= 0 ? fqn.substring(0, separator) : fqn;
        Collection classes = PhpIndex.getInstance((Project)project).getClassesByFQN(fqn);
        if (classes.size() == 1) {
            PhpClass aClass = (PhpClass)classes.iterator().next();
            if (memberName == null) {
                return aClass;
            }
            Method member = aClass.findMethodByName((CharSequence)memberName);
            if (member == null) {
                member = aClass.findFieldByName((CharSequence)memberName, false);
            }
            if (member == null) {
                member = aClass.findFieldByName((CharSequence)memberName, true);
            }
            return member;
        }
        return null;
    }
}

