/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.profiler.xdebug.model2;

import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.profiler.PhpSnapshotFormatException;
import com.jetbrains.php.profiler.model.impl.ProfilerSourcePositionData;
import com.jetbrains.php.profiler.xdebug.model2.XCall;
import com.jetbrains.php.profiler.xdebug.model2.XCallable;
import com.jetbrains.php.profiler.xdebug.model2.XModel;
import com.jetbrains.php.profiler.xdebug.model2.XModelBuilderInterface;
import com.jetbrains.php.profiler.xdebug.model2.statistics.XCallableStatisticsData;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class XModelBuilder
implements XModelBuilderInterface {
    private final Deque<XCall> myPendingList = new ArrayDeque<XCall>();
    public final XModel myModel = new XModel();
    private final XCall.Builder myCurrentCallBuilder = new XCall.Builder();

    @Override
    public void onFinished() {
        this.myModel.calculateStatistics();
    }

    @Override
    public void onSnapshotStarted() throws PhpSnapshotFormatException {
        if (this.myPendingList.size() > 0) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
    }

    @Override
    public void onSnapshotFinished() throws PhpSnapshotFormatException {
        if (this.myPendingList.size() == 0) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
        this.myModel.myXModelStorage.addTreeRoots(this.myPendingList);
        this.myPendingList.clear();
    }

    @Override
    public void callStarted(@NotNull String fileName, @NotNull String functionName, int lineNumber, long ownTime) throws PhpSnapshotFormatException {
        if (fileName == null) {
            XModelBuilder.$$$reportNull$$$0(0);
        }
        if (functionName == null) {
            XModelBuilder.$$$reportNull$$$0(1);
        }
        if (!this.myCurrentCallBuilder.isClear()) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
        if (fileName.startsWith("php:internal")) {
            lineNumber = 0;
        }
        XCallable callable = XCallable.createCallable(this.myModel.myXModelStorage, ProfilerSourcePositionData.createSourcePosition(fileName, lineNumber), functionName);
        this.myCurrentCallBuilder.setFunction(callable).setOwnTime(ownTime).setCumulativeTime(ownTime);
    }

    @Override
    public void callFinished() throws PhpSnapshotFormatException {
        if (this.myCurrentCallBuilder.isClear()) {
            throw new PhpSnapshotFormatException("unbalanced call");
        }
        XCall builtCall = this.myCurrentCallBuilder.build(this.myModel.myXModelStorage);
        this.myModel.myXModelStatistics.getSnapshotSummaryData().addToNumberOfCall(builtCall.getInvocationCount());
        this.myModel.myXModelStatistics.getSnapshotSummaryData().addToSummaryTime(builtCall.getOwnTime());
        XCallable callable = builtCall.getCallable();
        XCallableStatisticsData statistics = this.myModel.getStatistics(callable);
        statistics.addToNumberOfCall(builtCall.getInvocationCount());
        statistics.addToCumulativeTime(builtCall.getCumulativeTime());
        statistics.addToMyOwnTime(builtCall.getOwnTime());
        statistics.myCallees.addAll(builtCall.getChildren(this.myModel).stream().map(e -> e.getCallable()).collect(Collectors.toList()));
        this.myPendingList.addLast(builtCall);
        this.myCurrentCallBuilder.clear();
    }

    @Override
    public void processSubCall(long time) throws PhpSnapshotFormatException {
        if (this.myCurrentCallBuilder.isClear()) {
            throw new PhpSnapshotFormatException("unbalanced calls");
        }
        this.myCurrentCallBuilder.myCumulativeTime += time;
        if (this.myPendingList.size() == 0) {
            this.myPendingList.addLast(new XCall.Builder().setCumulativeTime(0L).setOwnTime(0L).setFunction(XCallable.UNKNOWN).build(this.myModel.myXModelStorage));
            this.myModel.getStatistics(this.myModel.myXModelStorage.createOrGet(XCallable.UNKNOWN)).addToNumberOfCall(1L);
            this.myModel.myXModelStatistics.getSnapshotSummaryData().addToNumberOfCall(1L);
        }
        this.myCurrentCallBuilder.addChild(this.myPendingList.pollLast());
    }

    public XModel getModel() {
        return this.myModel;
    }

    public void addVirtualFile(VirtualFile file) {
        this.myModel.addVirtualFile(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fileName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "functionName";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/profiler/xdebug/model2/XModelBuilder";
        objectArray[2] = "callStarted";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

