/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.makeStatic;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.util.AbstractParameterTablePanel;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.refactoring.PhpNameUtil;
import com.jetbrains.php.refactoring.changeSignature.PhpParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticParameterInfo;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticProcessor;
import com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticSettings;
import com.jetbrains.php.refactoring.makeStatic.PhpMethodPreprocessedData;
import com.jetbrains.php.refactoring.move.member.PhpAbstractMemberConflicts;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberDelegate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMakeStaticDialog
extends RefactoringDialog
implements PhpMakeStaticSettings {
    private static final String DIMENSION_SERVICE_KEY_BASE = "#com.jetbrains.php.refactoring.makeStatic.PhpMakeStaticDialog";
    private JCheckBox myParametersForFieldCb;
    private JCheckBox myObjectAsParameterCb;
    private JPanel myParametersPanel;
    private JPanel wholePanel;
    private JPanel mySignaturePanel;
    private JTextField myObjectName;
    private final Method myMethod;
    private final Project myProject;
    private final String[] myNameSuggestions;
    private PhpMethodPreprocessedData myMethodData;
    private AbstractParameterTablePanel<PhpMakeStaticParameterInfo> myParameterInfoPanel;
    public static final String HELP_ID = "refactoring.makeStatic";

    public PhpMakeStaticDialog(Project project, Method member, String[] nameSuggestions) {
        super(project, true);
        this.myMethod = member;
        this.myProject = project;
        this.myNameSuggestions = nameSuggestions;
        this.$$$setupUI$$$();
        this.myObjectName.setText(nameSuggestions[0]);
        this.myObjectAsParameterCb.setSelected(true);
        this.setTitle(RefactoringBundle.message((String)"make.0.static", (Object[])new Object[]{"Method"}));
    }

    public static PhpMakeStaticDialog createForm(Method member, PhpMethodPreprocessedData data) {
        PhpMakeStaticDialog form = new PhpMakeStaticDialog(member.getProject(), member, new String[]{"instance"});
        form.setData(data);
        form.init();
        return form;
    }

    protected void doAction() {
        String message = this.validateAllInfo();
        if (message != null) {
            CommonRefactoringUtil.showErrorMessage((String)PhpMoveMemberDelegate.REFACTORING_NAME, (String)message, (String)HELP_ID, (Project)this.myProject);
            return;
        }
        PhpMakeStaticProcessor makeStaticProcessor = new PhpMakeStaticProcessor(this.myProject, this.myMethod, this);
        this.invokeRefactoring(makeStaticProcessor);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.myParameterInfoPanel = new AbstractParameterTablePanel<PhpMakeStaticParameterInfo>(this.myMethodData.getParameterInfo(), new ColumnInfo[]{new AbstractParameterTablePanel.PassParameterColumnInfo(), new AbstractParameterTablePanel.NameColumnInfo((Language)PhpLanguage.INSTANCE, this.myProject)}){

            protected void updateSignature() {
            }

            protected void doEnterAction() {
                PhpMakeStaticDialog.this.clickDefaultButton();
            }

            protected void doCancelAction() {
            }
        };
        this.myObjectName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                PhpMakeStaticDialog.this.updateControls();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticDialog$2", "textChanged"));
            }
        });
        this.myParametersPanel.add((Component)this.myParameterInfoPanel, "Center");
        ActionListener inputFieldValidator = e -> this.updateControls();
        this.myObjectAsParameterCb.addActionListener(inputFieldValidator);
        this.myParametersForFieldCb.addActionListener(inputFieldValidator);
        this.updateControls();
        return this.wholePanel;
    }

    @Override
    public boolean isPassedByFields() {
        return this.myParametersForFieldCb.isSelected();
    }

    @Override
    public boolean isPassedByObject() {
        return this.myObjectAsParameterCb.isSelected();
    }

    @Override
    public String getObjectName() {
        return this.myObjectName.getText();
    }

    @Override
    public PhpMakeStaticParameterInfo[] getSelectedParameterInfos() {
        ArrayList<PhpMakeStaticParameterInfo> infos = new ArrayList<PhpMakeStaticParameterInfo>();
        if (this.isPassedByFields()) {
            for (PhpMakeStaticParameterInfo it : (PhpMakeStaticParameterInfo[])this.myParameterInfoPanel.getVariableData()) {
                if (!it.passAsParameter) continue;
                infos.add(it);
            }
        }
        return infos.toArray(new PhpMakeStaticParameterInfo[0]);
    }

    @Override
    @NotNull
    public Method getMethod() {
        Method method = this.myMethod;
        if (method == null) {
            PhpMakeStaticDialog.$$$reportNull$$$0(0);
        }
        return method;
    }

    @Override
    public boolean isObjectNeeded() {
        return this.myMethodData.isObjectIsNeeded();
    }

    @Override
    public List<MemberReference> getCalls() {
        return this.myMethodData.getMethodReferences();
    }

    @Override
    public PhpMethodPreprocessedData getData() {
        return this.myMethodData;
    }

    @Override
    public void setData(PhpMethodPreprocessedData data) {
        this.myMethodData = data;
    }

    public PhpClass getPhpClass() {
        return this.myMethod.getContainingClass();
    }

    public static List<PhpParameterInfo> getAllParametersList(PhpMakeStaticSettings settings, String classReferenceText) {
        ArrayList<PhpParameterInfo> list = new ArrayList<PhpParameterInfo>();
        if (settings.isPassedByObject()) {
            PhpMakeStaticParameterInfo makeStaticParameterInfo = new PhpMakeStaticParameterInfo(-1, settings.getObjectName(), true);
            makeStaticParameterInfo.info.setDefaultValue(classReferenceText);
            list.add(makeStaticParameterInfo.info);
        }
        if (settings.isPassedByFields()) {
            PhpMakeStaticParameterInfo[] parameterInfos;
            for (PhpMakeStaticParameterInfo it : parameterInfos = settings.getSelectedParameterInfos()) {
                it.info.setDefaultValue(classReferenceText + "->" + it.getName());
                list.add(it.info);
            }
        }
        return list;
    }

    private void updateControls() {
        if (this.isPassedByObject()) {
            String classParameterName = this.getObjectName();
            if (classParameterName == null) {
                this.setOKActionEnabled(false);
            } else {
                this.setOKActionEnabled(PhpLangUtil.isPhpIdentifier(classParameterName.trim()));
            }
        } else {
            this.setOKActionEnabled(true);
        }
        if (this.myObjectName != null) {
            this.myObjectName.setEnabled(this.isPassedByObject());
        }
        if (this.myParameterInfoPanel != null) {
            this.myParameterInfoPanel.setEnabled(this.isPassedByFields());
        }
    }

    @Nullable
    protected ValidationInfo doValidate() {
        String message = this.validateAllInfo();
        if (message != null) {
            return new ValidationInfo(message);
        }
        return super.doValidate();
    }

    private String validateAllInfo() {
        ArrayList<String> validationResults = new ArrayList<String>();
        String name = this.myObjectName.getText();
        if (!PhpNameUtil.isValidParameterName(name) && this.isPassedByObject()) {
            validationResults.add(name + " is invalid identifier");
        }
        return PhpAbstractMemberConflicts.createMessage(validationResults);
    }

    public String getHelpId() {
        return HELP_ID;
    }

    public String getDimensionServiceKey() {
        return DIMENSION_SERVICE_KEY_BASE;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myObjectName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/refactoring/makeStatic/PhpMakeStaticDialog", "getMethod"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.wholePanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myParametersPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        ((Component)jPanel2).setVisible(true);
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/PhpBundle").getString("PhpExtractMethodDialog.parameters"), (int)0, (int)0, null, null));
        this.myParametersForFieldCb = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/RefactoringBundle").getString("add.parameters.for.fields"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myObjectAsParameterCb = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/RefactoringBundle").getString("add.object.as.a.parameter.with.name"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mySignaturePanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myObjectName = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 0, 1, 7, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.wholePanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

