/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.refactoring.move.clazz;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpCallbackReferenceBase;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocRefImpl;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassDeclarationInfo;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassMultiDeclarationInfo;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassSettings;
import com.jetbrains.php.refactoring.move.clazz.PhpMoveClassUsageInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMoveClassUsageInfoProvider {
    @NotNull
    public static PhpMoveClassUsageInfo createDeclarationUsageInfo(@Nullable PhpPsiElement scopeHolder, @NotNull PhpMoveClassSettings settings) {
        if (settings == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(0);
        }
        PhpClass clazz = settings.getClassForRefactoring();
        if (settings.isScopeContainsMultipleClasses()) {
            if (settings.isExtractClassOptionEnabled()) {
                PsiDirectory baseDirectory = settings.getBaseDirectory();
                String filePath = settings.getFilePath();
                assert (baseDirectory != null && filePath != null);
                PhpMoveClassDeclarationInfo.NewFileScopeHolderUsage newFileScopeHolderUsage = new PhpMoveClassDeclarationInfo.NewFileScopeHolderUsage((PsiElement)clazz, baseDirectory, filePath);
                if (newFileScopeHolderUsage == null) {
                    PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(1);
                }
                return newFileScopeHolderUsage;
            }
            if (scopeHolder instanceof PhpNamespace) {
                PhpMoveClassMultiDeclarationInfo.MultiNamespaceScopeHolderUsage multiNamespaceScopeHolderUsage = new PhpMoveClassMultiDeclarationInfo.MultiNamespaceScopeHolderUsage((PsiElement)clazz, (PhpNamespace)scopeHolder);
                if (multiNamespaceScopeHolderUsage == null) {
                    PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(2);
                }
                return multiNamespaceScopeHolderUsage;
            }
            PhpMoveClassMultiDeclarationInfo.MultiFileScopeHolderUsage multiFileScopeHolderUsage = new PhpMoveClassMultiDeclarationInfo.MultiFileScopeHolderUsage((PsiElement)clazz, scopeHolder);
            if (multiFileScopeHolderUsage == null) {
                PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(3);
            }
            return multiFileScopeHolderUsage;
        }
        if (scopeHolder instanceof PhpNamespace) {
            PhpMoveClassDeclarationInfo.NamespaceScopeHolderUsage namespaceScopeHolderUsage = new PhpMoveClassDeclarationInfo.NamespaceScopeHolderUsage((PhpNamespace)scopeHolder, settings.getFilePath(), settings.getBaseDirectory());
            if (namespaceScopeHolderUsage == null) {
                PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(4);
            }
            return namespaceScopeHolderUsage;
        }
        PhpMoveClassDeclarationInfo.FileScopeHolderUsage fileScopeHolderUsage = new PhpMoveClassDeclarationInfo.FileScopeHolderUsage((PsiElement)clazz.getContainingFile(), settings.getFilePath(), settings.getBaseDirectory());
        if (fileScopeHolderUsage == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(5);
        }
        return fileScopeHolderUsage;
    }

    @Nullable
    public static PhpMoveClassUsageInfo createReferenceUsageInfo(@Nullable PhpPsiElement scopeHolder, @NotNull PhpMoveClassSettings settings, @NotNull PsiReference reference) {
        if (settings == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(6);
        }
        if (reference == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(7);
        }
        String scopeNamespaceName = PhpMoveClassUsageInfoProvider.getScopeNamespaceName(scopeHolder);
        if (reference instanceof ClassReference) {
            PhpClass clazz;
            PhpClass parentClass = (PhpClass)PhpPsiUtil.getParentByCondition(reference.getElement(), (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (parentClass != null && (parentClass == (clazz = settings.getClassForRefactoring()) ? PhpLangUtil.isSelfReference((ClassReference)reference) || PhpLangUtil.equalsClassNames(((ClassReference)reference).getNameCS(), clazz.getNameCS()) : PhpLangUtil.isParentReference((ClassReference)reference) && PhpClassHierarchyUtils.isSuperClass((PhpClass)clazz, (PhpClass)parentClass, (boolean)true))) {
                return null;
            }
            PhpPsiElement referenceScope = PhpCodeInsightUtil.findScopeForUseOperator(reference.getElement());
            if (referenceScope != scopeHolder || settings.isScopeContainsMultipleClasses()) {
                String referenceScopeNamespaceName = PhpMoveClassUsageInfoProvider.getScopeNamespaceName(referenceScope);
                if (PhpLangUtil.equalsNamespaceNames(referenceScopeNamespaceName, scopeNamespaceName)) {
                    return new PhpMoveClassUsageInfo.InternalNamespaceUsage(reference);
                }
                return new PhpMoveClassUsageInfo.ExternalNamespaceUsage(reference);
            }
        } else {
            if (reference instanceof PhpCallbackReferenceBase) {
                return new PhpMoveClassUsageInfo.CallbackClassUsage(reference.getElement());
            }
            if (reference instanceof PhpDocType || reference instanceof PhpDocRefImpl.PhpDocElementReference) {
                boolean moved = PhpMoveClassUsageInfoProvider.isMoved(scopeHolder, settings, reference.getElement());
                return new PhpMoveClassUsageInfo.PhpDocClassReferenceUsage(reference, moved);
            }
        }
        return null;
    }

    private static boolean isMoved(@Nullable PhpPsiElement scopeHolder, @NotNull PhpMoveClassSettings settings, @NotNull PsiElement element) {
        if (settings == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(8);
        }
        if (element == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(9);
        }
        if (settings.isScopeContainsMultipleClasses()) {
            PhpClass targetClass = settings.getClassForRefactoring();
            PhpClass parentClass = (PhpClass)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (parentClass == targetClass) {
                return true;
            }
            PhpDocComment comment = (PhpDocComment)PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF);
            return comment == targetClass.getDocComment();
        }
        PhpPsiElement movedScopeHolder = PhpCodeInsightUtil.findScopeForUseOperator(element);
        return movedScopeHolder == scopeHolder;
    }

    @NotNull
    protected static String getScopeNamespaceName(@Nullable PhpPsiElement scopeHolder) {
        String name;
        if (scopeHolder instanceof PhpNamespace && StringUtil.isNotEmpty((String)(name = scopeHolder.getName()))) {
            String string = StringUtil.trimEnd((String)name, (String)"\\");
            if (string == null) {
                PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(10);
            }
            return string;
        }
        if ("" == null) {
            PhpMoveClassUsageInfoProvider.$$$reportNull$$$0(11);
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfoProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/refactoring/move/clazz/PhpMoveClassUsageInfoProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeclarationUsageInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeNamespaceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarationUsageInfo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createReferenceUsageInfo";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isMoved";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

