/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.rmi.ConnectException;
import java.rmi.NotBoundException;
import org.intellij.plugins.xsltDebugger.EDTGuard;
import org.intellij.plugins.xsltDebugger.XsltDebuggerSession;
import org.intellij.plugins.xsltDebugger.impl.XsltDebugProcess;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.intellij.plugins.xsltDebugger.rt.engine.OutputEventQueue;
import org.intellij.plugins.xsltDebugger.rt.engine.remote.RemoteDebuggerClient;
import org.intellij.plugins.xsltDebugger.ui.StructureTabComponent;
import org.jetbrains.annotations.Nullable;

class DebuggerConnector
implements Runnable {
    private final Project myProject;
    private final ProcessHandler myProcess;
    private final int myPort;

    DebuggerConnector(Project project, ProcessHandler process, int port) {
        this.myProject = project;
        this.myProcess = process;
        this.myPort = port;
    }

    @Override
    public void run() {
        final Debugger client = this.connect();
        if (client == null) {
            if (!this.myProcess.isProcessTerminated()) {
                this.myProcess.notifyTextAvailable("Failed to connect to debugged process. Terminating.\n", ProcessOutputTypes.SYSTEM);
                this.myProcess.destroyProcess();
            }
            return;
        }
        XsltDebuggerSession session = XsltDebuggerSession.create(this.myProject, this.myProcess, client);
        XsltDebugProcess dbgp = XsltDebugProcess.getInstance(this.myProcess);
        assert (dbgp != null);
        dbgp.init(client);
        session.addListener(new XsltDebuggerSession.Listener(){

            @Override
            public void debuggerSuspended() {
                OutputEventQueue queue = client.getEventQueue();
                StructureTabComponent.getInstance(DebuggerConnector.this.myProcess).getEventModel().update(queue.getEvents());
            }

            @Override
            public void debuggerResumed() {
            }

            @Override
            public void debuggerStopped() {
                try {
                    OutputEventQueue queue = client.getEventQueue();
                    StructureTabComponent.getInstance(DebuggerConnector.this.myProcess).getEventModel().finalUpdate(queue.getEvents());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        session.start();
    }

    @Nullable
    private Debugger connect() {
        Exception lastException = null;
        for (int i = 0; i < 10; ++i) {
            if (this.myProcess.isProcessTerminated()) {
                return null;
            }
            try {
                Debugger realClient = (Debugger)EDTGuard.create(new RemoteDebuggerClient(this.myPort), this.myProcess);
                this.myProcess.notifyTextAvailable("Connected to XSLT debugger on port " + this.myPort + "\n", ProcessOutputTypes.SYSTEM);
                return realClient;
            }
            catch (ConnectException e) {
                lastException = e;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e1) {
                    break;
                }
            }
            catch (NotBoundException e) {
                lastException = e;
                try {
                    Thread.sleep(200L);
                    continue;
                }
                catch (InterruptedException e1) {
                    break;
                }
            }
            catch (IOException e) {
                lastException = e;
                break;
            }
        }
        if (lastException != null) {
            Logger.getInstance((String)this.getClass().getName()).info("Could not connect to debugger", (Throwable)lastException);
            if (lastException.getMessage() != null) {
                this.myProcess.notifyTextAvailable("Connection error: " + lastException.getMessage() + "\n", ProcessOutputTypes.SYSTEM);
            }
        }
        return null;
    }
}

