/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.ui;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeIndex;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseBatchIndicesEditor;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.models.BatchIndicesEditorModel;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DbBatchIndicesDialog
extends AbstractDbRefactoringDialog<DatabaseBatchIndicesEditor> {
    protected BatchIndicesEditorModel myBatchIndicesModel;

    protected DbBatchIndicesDialog(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(0);
        }
        super(context);
    }

    public static boolean canAddAnything(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasColumn> columns) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(1);
        }
        if (columns == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(2);
        }
        if (columns.isEmpty()) {
            return false;
        }
        for (DasColumn dasColumn : columns) {
            DasTable table = dasColumn.getTable();
            if (table.getKind() == ObjectKind.TABLE) continue;
            return false;
        }
        DatabaseDialectEx dialect = context.getDialect();
        return DbBatchIndicesDialog.getIndexCaps(dialect, false).canDoAnything();
    }

    public static boolean canModifyAnything(@NotNull DatabaseEditorContext context, @NotNull List<? extends DasIndex> indices) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(3);
        }
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(4);
        }
        if (indices.isEmpty()) {
            return false;
        }
        DatabaseDialectEx dialect = context.getDialect();
        return DbBatchIndicesDialog.getIndexCaps(dialect, true).canDoAnything();
    }

    @Override
    @NotNull
    protected String getTitle(boolean modify) {
        String string = modify ? "Batch Modify Indices" : "Batch Add Indices";
        if (string == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setIndices(@NotNull List<DeIndex> indices) {
        boolean edit;
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(6);
        }
        if (indices.isEmpty()) {
            throw new AssertionError((Object)"Invalid indices");
        }
        for (DeIndex index2 : indices) {
            if (index2.model != this.myModel) {
                throw new AssertionError((Object)"Invalid indices");
            }
        }
        this.myBatchIndicesModel = new BatchIndicesEditorModel(indices, this.myModel, this.myEditorModelsCache);
        boolean bl = edit = indices.get(0).getEditedObject() == null;
        if (edit) {
            this.myBatchIndicesModel.setNameGenerator(BatchIndicesEditorModel.DEFAULT_NAME_GENERATOR);
            this.myBatchIndicesModel.setUniqueGenerator(BatchIndicesEditorModel.FALSE_UNIQUE_GENERATOR);
        } else {
            this.myBatchIndicesModel.setNameGenerator(BatchIndicesEditorModel.PREV_NAME_GENERATOR);
            this.myBatchIndicesModel.setUniqueGenerator(BatchIndicesEditorModel.PREV_UNIQUE_GENERATOR);
        }
        this.myBatchIndicesModel.commit();
        this.setEditor(new DatabaseBatchIndicesEditor(this.myState, this.myBatchIndicesModel, DbBatchIndicesDialog.getIndexCaps(this.getContext().getDialect(), edit)));
        if (edit) {
            ((DatabaseBatchIndicesEditor)this.myEditor).setUniqueRevertStateEnabled(false);
        } else {
            ((DatabaseBatchIndicesEditor)this.myEditor).setUniqueRevertStateEnabled(this.myBatchIndicesModel.isUnique() == ThreeState.UNSURE);
            ((DatabaseBatchIndicesEditor)this.myEditor).setHintText("Edit to override existing names");
        }
    }

    @NotNull
    private static DatabaseEditorCapabilities.IndexEditorCaps getIndexCaps(DatabaseDialectEx dialect, boolean existing) {
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = dialect.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(true).getIndexCaps(existing);
        if (indexEditorCaps == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(7);
        }
        return indexEditorCaps;
    }

    @Override
    protected boolean isRefactoringValid() {
        return super.isRefactoringValid() && this.areIndicesNamesUnique();
    }

    private boolean areIndicesNamesUnique() {
        Set names = DasUtil.newCaseAwareSet((boolean)DasUtil.isCaseSensitive((Casing)this.getContext().getCasingProvider().getCasing(ObjectKind.INDEX, null)));
        for (DeIndex index2 : this.myBatchIndicesModel.getIndices()) {
            if (names.contains(index2.name)) {
                return false;
            }
            names.add(index2.name);
        }
        return true;
    }

    @NotNull
    public List<DeIndex> createIndices(@NotNull List<? extends BasicTableColumn> columns) {
        if (columns == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(8);
        }
        ArrayList indices = ContainerUtil.newArrayListWithCapacity((int)columns.size());
        for (BasicTableColumn basicTableColumn : columns) {
            DeTable table = (DeTable)this.export(basicTableColumn.getTable(), true);
            DeIndex index2 = new DeIndex("", table, this.myModel);
            index2.items.add(new DeIndex.Item((DeColumn)this.export(basicTableColumn, false), DasIndex.Sorting.NONE));
            indices.add(index2);
            table.indices.add(index2);
        }
        ArrayList arrayList = indices;
        if (arrayList == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    public List<DeIndex> existingIndices(@NotNull List<? extends BasicIndex> indices) {
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(10);
        }
        ArrayList deIndices = ContainerUtil.newArrayListWithCapacity((int)indices.size());
        for (BasicIndex basicIndex : indices) {
            this.checkObjectInContext(basicIndex);
            deIndices.add(this.export(basicIndex, true));
        }
        ArrayList arrayList = deIndices;
        if (arrayList == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @NotNull
    public static DbBatchIndicesDialog newBatchAddIndicesDialog(@NotNull DatabaseEditorContext context, @NotNull List<? extends BasicTableColumn> columns) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(12);
        }
        if (columns == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(13);
        }
        DbBatchIndicesDialog dialog = new DbBatchIndicesDialog(context);
        dialog.setIndices(dialog.createIndices(columns));
        DbBatchIndicesDialog dbBatchIndicesDialog = dialog;
        if (dbBatchIndicesDialog == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(14);
        }
        return dbBatchIndicesDialog;
    }

    @NotNull
    public static DbBatchIndicesDialog newBatchModifyIndicesDialog(@NotNull DatabaseEditorContext context, @NotNull List<? extends BasicIndex> indices) {
        if (context == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(15);
        }
        if (indices == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(16);
        }
        DbBatchIndicesDialog dialog = new DbBatchIndicesDialog(context);
        dialog.setIndices(dialog.existingIndices(indices));
        dialog.setRefactoring(true);
        DbBatchIndicesDialog dbBatchIndicesDialog = dialog;
        if (dbBatchIndicesDialog == null) {
            DbBatchIndicesDialog.$$$reportNull$$$0(17);
        }
        return dbBatchIndicesDialog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 4: 
            case 6: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/ui/DbBatchIndicesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/ui/DbBatchIndicesDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexCaps";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndices";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "existingIndices";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newBatchAddIndicesDialog";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "newBatchModifyIndicesDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canAddAnything";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canModifyAnything";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setIndices";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createIndices";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "existingIndices";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "newBatchAddIndicesDialog";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "newBatchModifyIndicesDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

