/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.framework.generators.zendtool.second;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.jetbrains.php.framework.FrameworkUtils;
import com.jetbrains.php.framework.data.FrameworkCommand;
import com.jetbrains.php.framework.data.FrameworkDescription;
import com.jetbrains.php.framework.generators.FrameworkDescriptionProvider;
import com.jetbrains.php.framework.generators.zendtool.second.Zend2DescriptionProvider;
import com.jetbrains.php.framework.generators.zendtool.second.Zend2HelpParser;
import com.jetbrains.php.framework.ui.FrameworkPathDialog;
import java.util.List;
import org.jetbrains.annotations.Nullable;

class Zend2Utils {
    private static final String DEFAULT_ALIAS = "zf2";

    private Zend2Utils() {
    }

    public static FrameworkDescription getFrameworkDescription(FrameworkPathDialog.Data data) {
        String path = data.getPath(true);
        String phpCommand = data.getPhpPath(true);
        return new FrameworkDescription(Zend2DescriptionProvider.FRAMEWORK_NAME + "_" + FrameworkUtils.getCurrentFormattedDate(), phpCommand + " " + path, DEFAULT_ALIAS, "", true, "com.zend.framework2", null);
    }

    public static List<FrameworkCommand> getFrameworkCommands(FrameworkPathDialog.Data data, @Nullable String workingDirectory) throws FrameworkDescriptionProvider.FrameworkParseException, FrameworkDescriptionProvider.FrameworkExecutionException {
        try {
            String[] helpCommand = Zend2Utils.getHelpCommand(data);
            ScriptRunnerUtil.ScriptOutput help = FrameworkUtils.executeCommandWithFullOutput(helpCommand, workingDirectory, true, false, false, !SystemInfo.isWindows);
            FrameworkDescription frameworkDescription = Zend2Utils.getFrameworkDescription(data);
            String executableName = VfsUtil.extractFileName((String)FileUtil.toSystemIndependentName((String)data.getPath(false)));
            Zend2HelpParser parser = new Zend2HelpParser(help, helpCommand, frameworkDescription, executableName);
            List<FrameworkCommand> commands = parser.getCommands();
            if (commands.isEmpty()) {
                throw new FrameworkDescriptionProvider.FrameworkParseException(helpCommand, help.getDescriptiveOutput(), "No commands were found");
            }
            return commands;
        }
        catch (ExecutionException e) {
            throw new FrameworkDescriptionProvider.FrameworkExecutionException(e);
        }
    }

    private static String[] getHelpCommand(FrameworkPathDialog.Data data) {
        return data.createCommand(new String[0]);
    }
}

