/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.operations;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RefreshForVcs {
    private final List<File> myFiles = ContainerUtil.newArrayList();
    private final List<File> myDirs = ContainerUtil.newArrayList();

    public void refreshFile(File file) {
        this.myFiles.add(file);
    }

    public void addDeletedFile(File file) {
        this.myDirs.add(file.getParentFile());
    }

    public void run(Project project) {
        LocalFileSystem.getInstance().refreshIoFiles(this.myFiles);
        LocalFileSystem.getInstance().refreshIoFiles(this.myDirs);
        ArrayList vFiles = ContainerUtil.newArrayList();
        for (File file : this.myFiles) {
            ContainerUtil.addIfNotNull((Collection)vFiles, (Object)LocalFileSystem.getInstance().findFileByIoFile(file));
        }
        ArrayList vDirs = ContainerUtil.newArrayList();
        for (File dir : this.myDirs) {
            ContainerUtil.addIfNotNull((Collection)vDirs, (Object)RefreshForVcs.refreshDir(dir));
        }
        VcsDirtyScopeManager.getInstance((Project)project).filesDirty((Collection)vFiles, (Collection)vDirs);
    }

    private static VirtualFile refreshDir(@Nullable File dir) {
        if (dir == null) {
            return null;
        }
        VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(dir);
        if (vf == null) {
            return RefreshForVcs.refreshDir(dir.getParentFile());
        }
        ((NewVirtualFile)vf).markDirtyRecursively();
        vf.refresh(false, true);
        return vf;
    }
}

