/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.twig.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.twig.TwigFile;
import com.jetbrains.twig.TwigTokenTypes;
import com.jetbrains.twig.elements.TwigElementTypes;
import com.jetbrains.twig.elements.TwigTag;
import com.jetbrains.twig.parser.TwigBlockStatements;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TwigFoldingBuilder
extends CustomFoldingBuilder {
    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (root == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(2);
        }
        if (root instanceof TwigFile) {
            TwigFoldingBuilder.collectTwigFoldingRegions(root, descriptors);
        }
    }

    private static void collectTwigFoldingRegions(PsiElement element, List<FoldingDescriptor> descriptors) {
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiElement lastChild;
            IElementType childType = child.getNode().getElementType();
            if (TwigFoldingBuilder.isFoldable(childType) && ((lastChild = child.getLastChild()) != null && (TwigTag.isStructural(lastChild.getNode().getElementType()) || lastChild.getNode().getElementType() == TwigElementTypes.TAG) || TwigFoldingBuilder.isMultilineComment(child))) {
                descriptors.add(new FoldingDescriptor(child, child.getTextRange()));
            }
            TwigFoldingBuilder.collectTwigFoldingRegions(child, descriptors);
        }
    }

    private static boolean isMultilineComment(@NotNull PsiElement comment) {
        if (comment == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (comment.getNode().getElementType() == TwigTokenTypes.COMMENT && comment.textContains('\n')) {
            return StringUtil.countChars((CharSequence)comment.getNode().getChars(), (char)'\n') > 1;
        }
        return false;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        IElementType nodeType;
        if (node == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(4);
        }
        if (range == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(5);
        }
        if (TwigFoldingBuilder.isFoldable(nodeType = node.getElementType())) {
            return TwigFoldingBuilder.getBlockPlaceholderText(node);
        }
        return "...";
    }

    protected static String getBlockPlaceholderText(@NotNull ASTNode topNode) {
        if (topNode == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(6);
        }
        if (topNode.getElementType() == TwigTokenTypes.COMMENT) {
            return TwigFoldingBuilder.getFoldedComment(topNode);
        }
        ASTNode child = topNode.getFirstChildNode();
        if (child.getElementType() instanceof TwigTag) {
            StringBuilder buf = new StringBuilder();
            for (child = child.getFirstChildNode(); child != null && child.getElementType() != TwigTokenTypes.STATEMENT_BLOCK_END; child = child.getTreeNext()) {
                buf.append(child.getText());
            }
            buf.append("...%}");
            return buf.toString();
        }
        return "???";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(7);
        }
        return false;
    }

    private static boolean isFoldable(IElementType nodeType) {
        if (nodeType == TwigElementTypes.ELSE_STATEMENT || nodeType == TwigElementTypes.ELSEIF_STATEMENT) {
            return false;
        }
        if (nodeType == TwigTokenTypes.COMMENT) {
            return true;
        }
        return TwigBlockStatements.isBlockStatement(nodeType);
    }

    private static String getFoldedComment(@NotNull ASTNode commentNode) {
        if (commentNode == null) {
            TwigFoldingBuilder.$$$reportNull$$$0(8);
        }
        CharSequence commentText = commentNode.getChars();
        StringBuilder buf = new StringBuilder();
        char prev = '\u0000';
        for (int i = 0; i < commentText.length(); ++i) {
            char c = commentText.charAt(i);
            if (c == '\n') {
                if (buf.length() > 2) {
                    break;
                }
            } else {
                if (c == '}' && prev == '#') {
                    buf.deleteCharAt(buf.length() - 1);
                    break;
                }
                buf.append(c);
            }
            prev = c;
        }
        buf.append("...");
        buf.append("#}");
        return buf.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentNode";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/twig/folding/TwigFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isMultilineComment";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBlockPlaceholderText";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getFoldedComment";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

