/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.commons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.MalformedInputException;
import java.util.logging.Logger;

public final class StreamUtil {
    private static final Logger LOG = Logger.getLogger(StreamUtil.class.getName());

    private StreamUtil() {
    }

    private static CharBuffer decodeHelper(byte[] byteArray, int numberOfBytes, Charset charset) throws IOException {
        CharsetDecoder decoder = charset.newDecoder();
        CharBuffer charBuffer = null;
        try {
            charBuffer = decoder.decode(ByteBuffer.wrap(byteArray, 0, numberOfBytes));
        }
        catch (MalformedInputException ex) {
            charBuffer = null;
        }
        return charBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStream2String(InputStream is, Charset charset) throws IOException {
        try {
            int n2;
            StringBuilder out = new StringBuilder();
            byte[] b = new byte[4096];
            byte[] savedBytes = new byte[1];
            boolean hasSavedBytes = false;
            CharsetDecoder decoder = charset.newDecoder();
            while ((n2 = is.read(b)) != -1) {
                CharBuffer charBuffer;
                if (hasSavedBytes) {
                    byte[] bTmp = new byte[savedBytes.length + b.length];
                    System.arraycopy(savedBytes, 0, bTmp, 0, savedBytes.length);
                    System.arraycopy(b, 0, bTmp, savedBytes.length, b.length);
                    b = bTmp;
                    hasSavedBytes = false;
                    n2 += savedBytes.length;
                }
                if ((charBuffer = StreamUtil.decodeHelper(b, n2, charset)) == null) {
                    int nrOfChars = 0;
                    while (charBuffer == null) {
                        charBuffer = StreamUtil.decodeHelper(b, n2 - ++nrOfChars, charset);
                        if (nrOfChars <= 10 || nrOfChars >= n2) continue;
                        try {
                            charBuffer = decoder.decode(ByteBuffer.wrap(b, 0, n2));
                        }
                        catch (MalformedInputException ex) {
                            throw new IOException("File not in supported encoding (" + charset.displayName() + ")", ex);
                        }
                    }
                    savedBytes = new byte[nrOfChars];
                    hasSavedBytes = true;
                    for (int i = 0; i < nrOfChars; ++i) {
                        savedBytes[i] = b[n2 - nrOfChars + i];
                    }
                }
                charBuffer.rewind();
                out.append(charBuffer.toString());
            }
            if (hasSavedBytes) {
                try {
                    CharBuffer n2 = decoder.decode(ByteBuffer.wrap(savedBytes, 0, savedBytes.length));
                }
                catch (MalformedInputException ex) {
                    throw new IOException("File not in supported encoding (" + charset.displayName() + ")", ex);
                }
            }
            String string = out.toString();
            return string;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStream2Bytes(InputStream is) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8192];
            int len = -1;
            while ((len = is.read(buf)) != -1) {
                baos.write(buf, 0, len);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        try (ReadableByteChannel inChannel = Channels.newChannel(is);
             WritableByteChannel outChannel = Channels.newChannel(os);){
            int bytesRead;
            ByteBuffer buffer = ByteBuffer.allocate(65536);
            while ((bytesRead = inChannel.read(buffer)) != -1) {
                buffer.flip();
                while (buffer.hasRemaining()) {
                    outChannel.write(buffer);
                }
                buffer.clear();
            }
        }
    }
}

