/*
 * Decompiled with CFR 0.152.
 */
package org.wiztools.restclient.bean;

public enum KeyStoreType {
    JKS,
    PKCS12,
    PEM;


    public String[] getFileExtns() {
        switch (this) {
            case JKS: {
                return new String[]{".jks"};
            }
            case PKCS12: {
                return new String[]{".p12", ".pfx", ".pkcs12"};
            }
            case PEM: {
                return new String[]{".pem", ".cert", ".cer", ".crt"};
            }
        }
        return new String[0];
    }

    public static KeyStoreType detectByExtn(String fileName) {
        if (KeyStoreType.isOfType(fileName = fileName.toLowerCase(), JKS)) {
            return JKS;
        }
        if (KeyStoreType.isOfType(fileName, PKCS12)) {
            return PKCS12;
        }
        if (KeyStoreType.isOfType(fileName, PEM)) {
            return PEM;
        }
        return null;
    }

    private static boolean isOfType(String fileName, KeyStoreType type) {
        for (String extn : type.getFileExtns()) {
            if (!fileName.endsWith(extn)) continue;
            return true;
        }
        return false;
    }
}

