/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.io;

import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import sbt.internal.io.EventMonitor;
import sbt.internal.io.EventMonitor$;
import sbt.internal.io.EventMonitor$Cancelled$;
import sbt.internal.io.EventMonitor$NullLogger$;
import sbt.internal.io.Source;
import sbt.internal.io.WatchState;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyBoolean;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class EventMonitor$ {
    public static EventMonitor$ MODULE$;
    private final AtomicInteger sbt$internal$io$EventMonitor$$eventThreadId;
    private final AtomicInteger sbt$internal$io$EventMonitor$$userInputId;

    static {
        new EventMonitor$();
    }

    public EventMonitor apply(WatchState state, FiniteDuration delay, FiniteDuration antiEntropy, Function0<Object> terminationCondition, EventMonitor.Logger logger) {
        return this.applyImpl(state, delay, antiEntropy, terminationCondition, logger, true);
    }

    public EventMonitor.Logger apply$default$5() {
        return EventMonitor$NullLogger$.MODULE$;
    }

    public EventMonitor applyImpl(WatchState state, FiniteDuration delay, FiniteDuration antiEntropy, Function0<Object> terminationCondition, EventMonitor.Logger logger, boolean closeService) {
        ArrayBlockingQueue<EventMonitor.Event> events = new ArrayBlockingQueue<EventMonitor.Event>(1);
        EventMonitor.Looper eventThread = this.newEventsThread(delay, antiEntropy, state, events, logger);
        EventMonitor.Looper userInputThread = this.newUserInputThread(terminationCondition, events, logger);
        return new EventMonitor.EventMonitorImpl(state.service(), events, eventThread, userInputThread, logger, closeService);
    }

    public EventMonitor legacy(WatchState state, FiniteDuration delay, Function0<Object> terminationCondition) {
        JFunction0.mcZ.sp & Serializable & scala.Serializable tc = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            void var1_1;
            block0: {
                boolean res = terminationCondition.apply$mcZ$sp();
                if (res) break block0;
                Thread.sleep(10L);
            }
            return (boolean)var1_1;
        };
        return this.applyImpl(state, delay, new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(40)).milliseconds(), (Function0<Object>)tc, EventMonitor$NullLogger$.MODULE$, false);
    }

    private EventMonitor.Looper newEventsThread(FiniteDuration delay, FiniteDuration antiEntropy, WatchState s, ArrayBlockingQueue<EventMonitor.Event> events, EventMonitor.Logger logger) {
        ObjectRef recentEvents = ObjectRef.create((Object)Predef$.MODULE$.Map().empty());
        ObjectRef registered = ObjectRef.create(s.registered());
        IntRef count = IntRef.create((int)s.count());
        Object lock = new Object();
        return new EventMonitor.HasWatchState(delay, antiEntropy, s, events, logger, recentEvents, registered, count, lock){
            private final FiniteDuration delay$1;
            private final FiniteDuration antiEntropy$1;
            public final WatchState s$1;
            private final ArrayBlockingQueue events$1;
            private final EventMonitor.Logger logger$1;
            private final ObjectRef recentEvents$1;
            public final ObjectRef registered$1;
            private final IntRef count$1;
            private final Object lock$1;

            public void incrementCount() {
                Object object = this.lock$1;
                synchronized (object) {
                    ++this.count$1.elem;
                }
            }

            public WatchState state() {
                WatchState watchState;
                Object object = this.lock$1;
                synchronized (object) {
                    watchState = this.s$1.withCount(this.count$1.elem).withRegistered((Map<Path, WatchKey>)((Map)this.registered$1.elem));
                }
                return watchState;
            }

            public void loop() {
                this.recentEvents$1.elem = (Map)((Map)this.recentEvents$1.elem).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$loop$1(x$1)));
                this.getFilesForKey(this.s$1.service().poll((Duration)this.delay$1)).foreach((Function1 & Serializable & scala.Serializable)path -> {
                    anon.1.$anonfun$loop$2(this, path);
                    return BoxedUnit.UNIT;
                });
            }

            private Vector<Path> getFilesForKey(WatchKey key) {
                Vector vector;
                WatchKey watchKey = key;
                if (watchKey == null) {
                    vector = package$.MODULE$.Vector().empty();
                } else {
                    Vector vector2;
                    WatchKey watchKey2 = watchKey;
                    synchronized (watchKey2) {
                        Vector events = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(watchKey.pollEvents()).asScala()).toVector();
                        watchKey.reset();
                        vector2 = events;
                    }
                    Vector rawEvents = vector2;
                    Path keyPath = (Path)watchKey.watchable();
                    Vector allEvents = (Vector)rawEvents.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        WatchEvent watchEvent = x0$1;
                        Iterable iterable = watchEvent.kind().equals(StandardWatchEventKinds.OVERFLOW) ? this.handleOverflow(watchKey) : (!watchEvent.kind().equals(StandardWatchEventKinds.OVERFLOW) && watchEvent.context() != null ? Option$.MODULE$.option2Iterable((Option)new Some((Object)keyPath.resolve((Path)watchEvent.context()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$));
                        return iterable;
                    }, Vector$.MODULE$.canBuildFrom());
                    this.logger$1.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Received events:\n").append(allEvents.mkString("\n")).toString());
                    Tuple2 tuple2 = allEvents.partition((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$getFilesForKey$3(x$2)));
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Vector exist = (Vector)tuple2._1();
                    Vector notExist = (Vector)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)exist, (Object)notExist);
                    Tuple2 tuple23 = tuple22;
                    Vector exist2 = (Vector)tuple23._1();
                    Vector notExist2 = (Vector)tuple23._2();
                    Tuple2 tuple24 = exist2.partition((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$getFilesForKey$4(x$4)));
                    if (tuple24 == null) {
                        throw new MatchError((Object)tuple24);
                    }
                    Vector updatedDirectories = (Vector)tuple24._1();
                    Vector updatedFiles = (Vector)tuple24._2();
                    Tuple2 tuple25 = new Tuple2((Object)updatedDirectories, (Object)updatedFiles);
                    Tuple2 tuple26 = tuple25;
                    Vector updatedDirectories2 = (Vector)tuple26._1();
                    Vector updatedFiles2 = (Vector)tuple26._2();
                    Vector newFiles = (Vector)updatedDirectories2.flatMap((Function1 & Serializable & scala.Serializable)dir -> this.filesForNewDirectory((Path)dir), Vector$.MODULE$.canBuildFrom());
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.registered$1.elem = (Map)((Map)this.registered$1.elem).$minus$minus((GenTraversableOnce)notExist2);
                    }
                    notExist2.foreach((Function1 & Serializable & scala.Serializable)path -> {
                        anon.1.$anonfun$getFilesForKey$6(this, path);
                        return BoxedUnit.UNIT;
                    });
                    vector = (Vector)((Vector)updatedFiles2.$plus$plus((GenTraversableOnce)newFiles, Vector$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)notExist2, Vector$.MODULE$.canBuildFrom());
                }
                return vector;
            }

            private Vector<Path> handleOverflow(WatchKey key) {
                Vector vector;
                Object object = this.lock$1;
                synchronized (object) {
                    HashSet hashSet;
                    Set set;
                    HashSet allFiles = new HashSet();
                    Set oldFiles = Set$.MODULE$.empty();
                    do {
                        oldFiles = allFiles;
                        this.getNewFiles$1(key, allFiles);
                        set = oldFiles;
                        hashSet = allFiles;
                    } while (set == null ? hashSet != null : !set.equals(hashSet));
                    this.registered$1.elem = (Map)((Map)this.registered$1.elem).$minus$minus((GenTraversableOnce)((Map)this.registered$1.elem).collect((PartialFunction)new scala.Serializable(null){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Path, WatchKey>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                Path d = (Path)A1._1();
                                WatchKey k = (WatchKey)A1._2();
                                if (!Files.exists(d, new LinkOption[0])) {
                                    k.reset();
                                    k.cancel();
                                    object = d;
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<Path, WatchKey> x1) {
                            Path d;
                            Tuple2<Path, WatchKey> tuple2 = x1;
                            boolean bl = tuple2 != null && !Files.exists(d = (Path)tuple2._1(), new LinkOption[0]);
                            return bl;
                        }
                    }, Iterable$.MODULE$.canBuildFrom()));
                    vector = allFiles.toVector();
                }
                return vector;
            }

            private Iterator<Path> filesForNewDirectory(Path dir) {
                Iterator iterator;
                LazyBoolean recursive$lzy = new LazyBoolean();
                if (!((Map)this.registered$1.elem).contains((Object)dir) && this.recursive$1(dir, recursive$lzy)) {
                    Iterator dirs = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(dir, new FileVisitOption[0]).iterator()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$filesForNewDirectory$2(x$6)));
                    IndexedSeq newDirs = dirs.map((Function1 & Serializable & scala.Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(d), (Object)$this.s$1.register((Path)d))).toIndexedSeq();
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.registered$1.elem = ((Map)this.registered$1.elem).$plus$plus((GenTraversableOnce)newDirs);
                    }
                    iterator = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.walk(dir, new FileVisitOption[0]).iterator()).asScala();
                } else {
                    iterator = Nil$.MODULE$.iterator();
                }
                return iterator;
            }

            private void maybeTrigger(Path path) {
                block6: {
                    if (!this.s$1.accept(path)) break block6;
                    if (BoxesRunTime.unboxToBoolean((Object)((Map)this.recentEvents$1.elem).get((Object)path).fold((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false, (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$maybeTrigger$2(x$7))))) {
                        this.logger$1.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Ignoring watch event for ").append(path).append(" due to anti-entropy constraint").toString());
                    } else {
                        EventMonitor.Event event = (EventMonitor.Event)this.events$1.peek();
                        if (EventMonitor$Cancelled$.MODULE$.equals(event)) {
                            this.logger$1.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Watch cancelled, not offering event for path ").append(path).toString());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            BoxedUnit boxedUnit;
                            this.recentEvents$1.elem = ((Map)this.recentEvents$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)path), (Object)this.antiEntropy$1.fromNow()));
                            if (!this.events$1.offer(new EventMonitor.Triggered(path))) {
                                this.logger$1.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Event already pending, dropping event for path: ").append(path).toString());
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                        }
                    }
                }
            }

            public static final /* synthetic */ boolean $anonfun$loop$1(Tuple2 x$1) {
                return ((Deadline)x$1._2()).isOverdue();
            }

            public static final /* synthetic */ void $anonfun$loop$2(anon.1 $this, Path path) {
                $this.maybeTrigger(path);
            }

            public static final /* synthetic */ boolean $anonfun$getFilesForKey$3(Path x$2) {
                return Files.exists(x$2, new LinkOption[0]);
            }

            public static final /* synthetic */ boolean $anonfun$getFilesForKey$4(Path x$4) {
                return Files.isDirectory(x$4, new LinkOption[0]);
            }

            public static final /* synthetic */ void $anonfun$getFilesForKey$6(anon.1 $this, Path path) {
                $this.s$1.unregister(path);
            }

            private final void getNewFiles$1(WatchKey key$1, HashSet allFiles$1) {
                allFiles$1.clear();
                Path path = (Path)key$1.watchable();
                Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(this, allFiles$1){
                    private final /* synthetic */ anon.1 $outer;
                    private final HashSet allFiles$1;

                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                        block0: {
                            this.allFiles$1.$plus$eq((Object)dir);
                            if (((Map)this.$outer.registered$1.elem).contains((Object)dir)) break block0;
                            this.$outer.registered$1.elem = ((Map)this.$outer.registered$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)dir), (Object)this.$outer.s$1.register(dir)));
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        this.allFiles$1.$plus$eq((Object)file);
                        return FileVisitResult.CONTINUE;
                    }

                    public FileVisitResult visitFileFailed(Path file, IOException exc) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }

                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                        return FileVisitResult.CONTINUE;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.allFiles$1 = allFiles$1;
                    }
                });
            }

            public static final /* synthetic */ boolean $anonfun$filesForNewDirectory$1(Path dir$1, Source src) {
                return dir$1.startsWith(src.base().toPath()) && src.recursive();
            }

            private final /* synthetic */ boolean recursive$lzycompute$1(Path dir$1, LazyBoolean recursive$lzy$1) {
                boolean bl;
                LazyBoolean lazyBoolean = recursive$lzy$1;
                synchronized (lazyBoolean) {
                    bl = recursive$lzy$1.initialized() ? recursive$lzy$1.value() : recursive$lzy$1.initialize(this.s$1.sources().exists((Function1 & Serializable & scala.Serializable)src -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$filesForNewDirectory$1(dir$1, src))));
                }
                return bl;
            }

            private final boolean recursive$1(Path dir$1, LazyBoolean recursive$lzy$1) {
                return recursive$lzy$1.initialized() ? recursive$lzy$1.value() : this.recursive$lzycompute$1(dir$1, recursive$lzy$1);
            }

            public static final /* synthetic */ boolean $anonfun$filesForNewDirectory$2(Path x$6) {
                return Files.isDirectory(x$6, new LinkOption[0]);
            }

            public static final /* synthetic */ boolean $anonfun$maybeTrigger$2(Deadline x$7) {
                return !x$7.isOverdue();
            }
            {
                this.delay$1 = delay$1;
                this.antiEntropy$1 = antiEntropy$1;
                this.s$1 = s$1;
                this.events$1 = events$1;
                this.logger$1 = logger$1;
                this.recentEvents$1 = recentEvents$1;
                this.registered$1 = registered$1;
                this.count$1 = count$1;
                this.lock$1 = lock$1;
                super(new StringBuilder(25).append("watch-state-event-thread-").append(EventMonitor$.MODULE$.sbt$internal$io$EventMonitor$$eventThreadId().incrementAndGet()).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$loop$1$adapted(scala.Tuple2 ), $anonfun$loop$2$adapted(sbt.internal.io.EventMonitor$$anon$1 java.nio.file.Path ), $anonfun$getFilesForKey$1(sbt.internal.io.EventMonitor$$anon$1 java.nio.file.Path java.nio.file.WatchKey java.nio.file.WatchEvent ), $anonfun$getFilesForKey$2(scala.collection.immutable.Vector ), $anonfun$getFilesForKey$3$adapted(java.nio.file.Path ), $anonfun$getFilesForKey$4$adapted(java.nio.file.Path ), $anonfun$getFilesForKey$5(sbt.internal.io.EventMonitor$$anon$1 java.nio.file.Path ), $anonfun$getFilesForKey$6$adapted(sbt.internal.io.EventMonitor$$anon$1 java.nio.file.Path ), $anonfun$filesForNewDirectory$2$adapted(java.nio.file.Path ), $anonfun$filesForNewDirectory$3(sbt.internal.io.EventMonitor$$anon$1 java.nio.file.Path ), $anonfun$maybeTrigger$1(), $anonfun$maybeTrigger$2$adapted(scala.concurrent.duration.Deadline ), $anonfun$maybeTrigger$3(java.nio.file.Path ), $anonfun$maybeTrigger$4(java.nio.file.Path ), $anonfun$maybeTrigger$5(java.nio.file.Path ), $anonfun$filesForNewDirectory$1$adapted(java.nio.file.Path sbt.internal.io.Source )}, serializedLambda);
            }
        };
    }

    public void sbt$internal$io$EventMonitor$$ignoreArg(Function0<Object> arg) {
    }

    private EventMonitor.Looper newUserInputThread(Function0<Object> terminationCondition, ArrayBlockingQueue<EventMonitor.Event> events, EventMonitor.Logger logger) {
        return new EventMonitor.Looper(terminationCondition, events, logger){
            private final Function0 terminationCondition$1;
            private final ArrayBlockingQueue events$2;
            private final EventMonitor.Logger logger$2;

            public final void loop() {
                block3: {
                    Thread.sleep(10L);
                    if (!this.terminationCondition$1.apply$mcZ$sp()) break block3;
                    this.logger$2.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Received termination condition. Stopping watch...");
                    EventMonitor.Event event = (EventMonitor.Event)this.events$2.peek();
                    if (EventMonitor$Cancelled$.MODULE$.equals(event)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        while (!this.events$2.offer(EventMonitor$Cancelled$.MODULE$)) {
                            this.events$2.clear();
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
            {
                this.terminationCondition$1 = terminationCondition$1;
                this.events$2 = events$2;
                this.logger$2 = logger$2;
                super(new StringBuilder(23).append("watch-state-user-input-").append(EventMonitor$.MODULE$.sbt$internal$io$EventMonitor$$userInputId().incrementAndGet()).toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$loop$3()}, serializedLambda);
            }
        };
    }

    public AtomicInteger sbt$internal$io$EventMonitor$$eventThreadId() {
        return this.sbt$internal$io$EventMonitor$$eventThreadId;
    }

    public AtomicInteger sbt$internal$io$EventMonitor$$userInputId() {
        return this.sbt$internal$io$EventMonitor$$userInputId;
    }

    private EventMonitor$() {
        MODULE$ = this;
        this.sbt$internal$io$EventMonitor$$eventThreadId = new AtomicInteger(0);
        this.sbt$internal$io$EventMonitor$$userInputId = new AtomicInteger(0);
    }
}

