/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.stringtemplate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupInterface;
import org.antlr.stringtemplate.StringTemplateGroupLoader;

public class PathGroupLoader
implements StringTemplateGroupLoader {
    protected List dirs = null;
    protected StringTemplateErrorListener errors = null;
    String fileCharEncoding = System.getProperty("file.encoding");

    public PathGroupLoader(StringTemplateErrorListener errors) {
        this.errors = errors;
    }

    public PathGroupLoader(String dirStr, StringTemplateErrorListener errors) {
        this.errors = errors;
        StringTokenizer tokenizer = new StringTokenizer(dirStr, ":", false);
        while (tokenizer.hasMoreElements()) {
            String dir = (String)tokenizer.nextElement();
            if (this.dirs == null) {
                this.dirs = new ArrayList();
            }
            this.dirs.add(dir);
        }
    }

    public StringTemplateGroup loadGroup(String groupName, StringTemplateGroup superGroup) {
        StringTemplateGroup group = null;
        try {
            BufferedReader br = this.locate(groupName + ".stg");
            if (br == null) {
                this.error("no such group file " + groupName + ".stg");
                return null;
            }
            group = new StringTemplateGroup(br, null, this.errors, superGroup);
        }
        catch (IOException ioe) {
            this.error("can't load group " + groupName, ioe);
        }
        return group;
    }

    public StringTemplateGroup loadGroup(String groupName) {
        return this.loadGroup(groupName, null);
    }

    public StringTemplateGroupInterface loadInterface(String interfaceName) {
        StringTemplateGroupInterface I = null;
        try {
            BufferedReader br = this.locate(interfaceName + ".sti");
            if (br == null) {
                this.error("no such interface file " + interfaceName + ".sti");
                return null;
            }
            I = new StringTemplateGroupInterface(br, this.errors);
        }
        catch (IOException ioe) {
            this.error("can't load interface " + interfaceName, ioe);
        }
        return I;
    }

    protected BufferedReader locate(String name) throws IOException {
        for (int i = 0; i < this.dirs.size(); ++i) {
            String dir = (String)this.dirs.get(i);
            String fileName = dir + "/" + name;
            if (!new File(fileName).exists()) continue;
            FileInputStream fis = new FileInputStream(fileName);
            InputStreamReader isr = this.getInputStreamReader(fis);
            return new BufferedReader(isr);
        }
        return null;
    }

    protected InputStreamReader getInputStreamReader(InputStream in) {
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(in, this.fileCharEncoding);
        }
        catch (UnsupportedEncodingException uee) {
            this.error("Invalid file character encoding: " + this.fileCharEncoding);
        }
        return isr;
    }

    public String getFileCharEncoding() {
        return this.fileCharEncoding;
    }

    public void setFileCharEncoding(String fileCharEncoding) {
        this.fileCharEncoding = fileCharEncoding;
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Exception e) {
        if (this.errors != null) {
            this.errors.error(msg, e);
        } else {
            System.err.println("StringTemplate: " + msg);
            if (e != null) {
                e.printStackTrace();
            }
        }
    }
}

