/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.refactoring.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.sourceforge.squirrel_sql.client.gui.db.IDisposableDialog;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public abstract class AbstractRefactoringTabbedDialog
extends JDialog
implements IDisposableDialog {
    protected JButton executeButton = null;
    protected JButton editSQLButton = null;
    protected JButton showSQLButton = null;
    protected JButton cancelButton = null;
    protected GridBagConstraints c = null;
    protected final Dimension mediumField = new Dimension(126, 20);
    protected final JTabbedPane pane = new JTabbedPane();
    protected final EmptyBorder emptyBorder = new EmptyBorder(new Insets(5, 5, 5, 5));
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractRefactoringTabbedDialog.class);

    public AbstractRefactoringTabbedDialog(Dimension size) {
        this.defaultInit(size);
    }

    public void addShowSQLListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.showSQLButton.addActionListener(listener);
    }

    public void addEditSQLListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.editSQLButton.addActionListener(listener);
    }

    public void addExecuteListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.executeButton.addActionListener(listener);
    }

    protected GridBagConstraints getLabelConstraints(GridBagConstraints c) {
        c.gridx = 0;
        ++c.gridy;
        c.anchor = 12;
        c.fill = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        return c;
    }

    protected GridBagConstraints getFieldConstraints(GridBagConstraints c) {
        ++c.gridx;
        c.anchor = 18;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 2;
        return c;
    }

    protected JLabel getBorderedLabel(String text, Border border) {
        JLabel result = new JLabel(text);
        result.setBorder(border);
        result.setPreferredSize(new Dimension(115, 20));
        result.setHorizontalAlignment(4);
        return result;
    }

    protected void defaultInit(Dimension size) {
        super.setModal(true);
        this.setSize(size);
        this.pane.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.c = new GridBagConstraints();
        this.c.gridx = 0;
        this.c.gridy = -1;
        this.setLayout(new BorderLayout());
        this.add((Component)this.pane, "Center");
        this.add((Component)this.getButtonPanel(), "South");
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(2).put(escapeStroke, "CloseAction");
        this.getRootPane().getInputMap(0).put(escapeStroke, "CloseAction");
        this.getRootPane().getActionMap().put("CloseAction", new AbstractAction(){
            private static final long serialVersionUID = -2305467371279192850L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractRefactoringTabbedDialog.this.setVisible(false);
                AbstractRefactoringTabbedDialog.this.dispose();
            }
        });
    }

    protected JPanel getButtonPanel() {
        JPanel result = new JPanel();
        this.executeButton = new JButton(i18n.EXECUTE_BUTTON_LABEL);
        result.add(this.executeButton);
        this.editSQLButton = new JButton(i18n.EDIT_BUTTON_LABEL);
        result.add(this.editSQLButton);
        this.showSQLButton = new JButton(i18n.SHOWSQL_BUTTON_LABEL);
        result.add(this.showSQLButton);
        this.cancelButton = new JButton(i18n.CANCEL_BUTTON_LABEL);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractRefactoringTabbedDialog.this.setVisible(false);
                AbstractRefactoringTabbedDialog.this.dispose();
            }
        });
        result.add(this.cancelButton);
        return result;
    }

    protected void enable(JButton button) {
        if (button != null) {
            button.setEnabled(true);
        }
    }

    protected void disable(JButton button) {
        if (button != null) {
            button.setEnabled(false);
        }
    }

    protected void setAllButtonEnabled(boolean enable) {
        this.executeButton.setEnabled(enable);
        this.editSQLButton.setEnabled(enable);
        this.showSQLButton.setEnabled(enable);
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    protected static interface i18n {
        public static final String CANCEL_BUTTON_LABEL = AbstractRefactoringTabbedDialog.access$000().getString("AbstractRefactoringDialog.cancelButtonLabel");
        public static final String EDIT_BUTTON_LABEL = AbstractRefactoringTabbedDialog.access$000().getString("AbstractRefactoringDialog.editButtonLabel");
        public static final String EXECUTE_BUTTON_LABEL = AbstractRefactoringTabbedDialog.access$000().getString("AbstractRefactoringDialog.executeButtonLabel");
        public static final String SHOWSQL_BUTTON_LABEL = AbstractRefactoringTabbedDialog.access$000().getString("AbstractRefactoringDialog.showButtonLabel");
        public static final String TABLE_NAME_LABEL = AbstractRefactoringTabbedDialog.access$000().getString("AbstractRefactoringDialog.tableNameLabel");
    }
}

