/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.io.Serializable;
import net.sourceforge.squirrel_sql.client.Version;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;

public class UpdateSettings
implements Cloneable,
IUpdateSettings,
Serializable {
    private static final long serialVersionUID = -1305655179503568153L;
    private String updateServer = "sourceforge.net";
    private String updateServerPort = "80";
    private String updateServerPath = "projects/squirrel-sql/files/updates";
    private String updateServerChannel = "stable";
    private boolean enableAutomaticUpdates = true;
    private String updateCheckFrequency = "WEEKLY";
    private String lastUpdateCheckTimeMillis = "0";
    private boolean isRemoteUpdateSite = true;
    private String fileSystemUpdatePath = "";

    public UpdateSettings() {
        if (Version.isSnapshotVersion()) {
            this.updateServerChannel = "snapshot";
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public UpdateSettings(IUpdateSettings updateSettings) {
        String server = updateSettings.getUpdateServer();
        String port = updateSettings.getUpdateServerPort();
        String path = updateSettings.getUpdateServerPath();
        if (server != null && server.equalsIgnoreCase("www.squirrel-sql.net")) {
            server = "sourceforge.net";
            port = "80";
            path = "projects/squirrel-sql/files/updates";
        }
        this.updateServer = server;
        this.updateServerPort = port;
        this.updateServerPath = path;
        this.updateServerChannel = updateSettings.getUpdateServerChannel();
        this.enableAutomaticUpdates = updateSettings.isEnableAutomaticUpdates();
        this.updateCheckFrequency = updateSettings.getUpdateCheckFrequency();
        this.lastUpdateCheckTimeMillis = updateSettings.getLastUpdateCheckTimeMillis();
        this.isRemoteUpdateSite = updateSettings.isRemoteUpdateSite();
        this.fileSystemUpdatePath = updateSettings.getFileSystemUpdatePath();
    }

    @Override
    public String getUpdateServer() {
        return this.updateServer;
    }

    @Override
    public void setUpdateServer(String updateServer) {
        this.updateServer = updateServer;
    }

    @Override
    public String getUpdateServerPort() {
        return this.updateServerPort;
    }

    @Override
    public void setUpdateServerPort(String updateServerPort) {
        this.updateServerPort = updateServerPort;
    }

    @Override
    public String getUpdateServerPath() {
        return this.updateServerPath;
    }

    @Override
    public void setUpdateServerPath(String updateServerPath) {
        this.updateServerPath = updateServerPath;
    }

    @Override
    public String getUpdateServerChannel() {
        return this.updateServerChannel;
    }

    @Override
    public void setUpdateServerChannel(String updateServerChannel) {
        this.updateServerChannel = updateServerChannel;
    }

    @Override
    public boolean isEnableAutomaticUpdates() {
        return this.enableAutomaticUpdates;
    }

    @Override
    public void setEnableAutomaticUpdates(boolean enableAutomaticUpdates) {
        this.enableAutomaticUpdates = enableAutomaticUpdates;
    }

    @Override
    public String getUpdateCheckFrequency() {
        return this.updateCheckFrequency;
    }

    @Override
    public void setUpdateCheckFrequency(String updateCheckFrequency) {
        this.updateCheckFrequency = updateCheckFrequency;
    }

    @Override
    public String getLastUpdateCheckTimeMillis() {
        return this.lastUpdateCheckTimeMillis;
    }

    @Override
    public void setLastUpdateCheckTimeMillis(String lastUpdateCheckTimeMillis) {
        this.lastUpdateCheckTimeMillis = lastUpdateCheckTimeMillis;
    }

    @Override
    public boolean isRemoteUpdateSite() {
        return this.isRemoteUpdateSite;
    }

    @Override
    public void setRemoteUpdateSite(boolean isRemoteUpdateSite) {
        this.isRemoteUpdateSite = isRemoteUpdateSite;
    }

    @Override
    public String getFileSystemUpdatePath() {
        return this.fileSystemUpdatePath;
    }

    @Override
    public void setFileSystemUpdatePath(String fileSystemUpdatePath) {
        this.fileSystemUpdatePath = fileSystemUpdatePath;
    }
}

