/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.sqlfilter;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.ISQLFilterPanel;
import net.sourceforge.squirrel_sql.client.session.sqlfilter.SQLFilterClauses;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;

public class OrderByClausePanel
implements ISQLFilterPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(OrderByClausePanel.class);
    private SQLFilterClauses _sqlFilterClauses;
    private OrderByClauseSubPanel _myPanel;

    public OrderByClausePanel(LinkedHashMap<String, IDataTypeComponent> columnComponents, String tableName) {
        this._myPanel = new OrderByClauseSubPanel(columnComponents.keySet(), tableName);
    }

    @Override
    public void initialize(SQLFilterClauses sqlFilterClauses) throws IllegalArgumentException {
        if (sqlFilterClauses == null) {
            throw new IllegalArgumentException("Null sqlFilterClauses passed");
        }
        this._sqlFilterClauses = sqlFilterClauses;
        this._myPanel.loadData(this._sqlFilterClauses);
    }

    @Override
    public Component getPanelComponent() {
        return this._myPanel;
    }

    @Override
    public String getTitle() {
        return OrderByClauseSubPanel.OrderByClausePanelI18n.ORDER_BY_CLAUSE;
    }

    @Override
    public String getHint() {
        return OrderByClauseSubPanel.OrderByClausePanelI18n.HINT;
    }

    @Override
    public void applyChanges() {
        this._myPanel.applyChanges(this._sqlFilterClauses);
    }

    public void clearFilter() {
        this._myPanel.clearFilter();
    }

    public static String getClauseIdentifier() {
        return OrderByClauseSubPanel.OrderByClausePanelI18n.ORDER_BY_CLAUSE;
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private static final class OrderCombo
    extends JComboBox {
        private static final long serialVersionUID = 1L;

        OrderCombo() {
            this.addItem("ASC");
            this.addItem("DESC");
        }
    }

    private static final class OrderByClauseSubPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JLabel _columnLabel = new JLabel(OrderByClausePanelI18n.COLUMNS);
        private JComboBox _columnCombo;
        private JLabel _orderLabel = new JLabel(OrderByClausePanelI18n.ORDER_DIRECTION);
        private OrderCombo _orderCombo = new OrderCombo();
        private JButton _addButton = new JButton(OrderByClausePanelI18n.ADD);
        private JTextArea _orderClauseArea = new JTextArea(10, 40);
        private String _tableName;

        OrderByClauseSubPanel(Set<String> set, String tableName) {
            this._columnCombo = new JComboBox<Object>(set.toArray());
            this._tableName = tableName;
            this.createUserInterface();
        }

        void loadData(SQLFilterClauses sqlFilterClauses) {
            this._orderClauseArea.setText(sqlFilterClauses.get(OrderByClausePanel.getClauseIdentifier(), this._tableName));
        }

        void applyChanges(SQLFilterClauses sqlFilterClauses) {
            sqlFilterClauses.put(OrderByClausePanel.getClauseIdentifier(), this._tableName, this._orderClauseArea.getText());
        }

        private void createUserInterface() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)this.createControlsPanel(), gbc);
            this._orderClauseArea.setLineWrap(true);
            JScrollPane sp = new JScrollPane(this._orderClauseArea, 20, 31);
            gbc = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(4, 4, 4, 4), 0, 0);
            this.add((Component)sp, gbc);
        }

        private JPanel createControlsPanel() {
            JPanel ret = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._columnLabel, gbc);
            gbc = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._columnCombo, gbc);
            gbc = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._orderLabel, gbc);
            gbc = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._orderCombo, gbc);
            gbc = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(4, 4, 4, 4), 0, 0);
            ret.add((Component)this._addButton, gbc);
            this._addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OrderByClauseSubPanel.this.addTextToClause();
                }
            });
            return ret;
        }

        private void addTextToClause() {
            String column = (String)this._columnCombo.getSelectedItem();
            String order = (String)this._orderCombo.getSelectedItem();
            if (this._orderClauseArea.getText().length() > 0) {
                this._orderClauseArea.append(",\n");
            }
            this._orderClauseArea.append(column + " " + order);
        }

        public void clearFilter() {
            this._orderClauseArea.setText("");
        }

        static interface OrderByClausePanelI18n {
            public static final String ASC = "ASC";
            public static final String DESC = "DESC";
            public static final String ADD = OrderByClausePanel.access$000().getString("OrderByClausePanel.addLabel");
            public static final String COLUMNS = OrderByClausePanel.access$000().getString("OrderByClausePanel.columnsLabel");
            public static final String ORDER_DIRECTION = OrderByClausePanel.access$000().getString("OrderByClausePanel.orderDirectionLabel");
            public static final String ORDER_BY_CLAUSE = OrderByClausePanel.access$000().getString("OrderByClausePanel.orderByClauseLabel");
            public static final String HINT = OrderByClausePanel.access$000().getString("OrderByClausePanel.hint");
        }
    }
}

