/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.util;

import java.sql.DataTruncation;
import java.sql.SQLException;
import java.sql.SQLWarning;
import net.sourceforge.squirrel_sql.fw.sql.SQLExecutionException;
import net.sourceforge.squirrel_sql.fw.util.ExceptionFormatter;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DefaultExceptionFormatter
implements ExceptionFormatter {
    private static final ILogger s_log = LoggerController.createLogger(DefaultExceptionFormatter.class);
    private ExceptionFormatter customFormatter = null;

    @Override
    public String format(Throwable th) {
        if (th == null) {
            throw new IllegalArgumentException("format: th cannot be null");
        }
        StringBuilder result = new StringBuilder();
        String postError = "";
        Throwable cause = th;
        if (th instanceof SQLExecutionException) {
            postError = ((SQLExecutionException)th).getPostError();
            cause = th.getCause();
        }
        String customMessage = null;
        if (this.customFormatter != null && this.customFormatter.formatsException(cause)) {
            try {
                customMessage = this.customFormatter.format(cause);
            }
            catch (Exception e) {
                s_log.error("Exception occurred while formatting:  " + e.getMessage(), e);
            }
        }
        if (customMessage != null) {
            result.append(customMessage);
        } else {
            result.append(this.defaultFormatSQLException(cause));
        }
        if (postError != null && !"".equals(postError)) {
            result.append("\n");
            result.append(postError);
        }
        return result.toString();
    }

    public String defaultFormatSQLException(Throwable cause) {
        StringBuilder result = new StringBuilder();
        if (cause instanceof DataTruncation) {
            result.append(this.getDataTruncationMessage((DataTruncation)cause));
        } else if (cause instanceof SQLWarning) {
            result.append(this.getSQLWarningMessage((SQLWarning)cause));
        } else if (cause instanceof SQLException) {
            result.append(this.getSQLExceptionMessage((SQLException)cause));
        } else {
            result.append(cause.toString());
        }
        return result.toString();
    }

    @Override
    public boolean formatsException(Throwable t) {
        return true;
    }

    public void setCustomExceptionFormatter(ExceptionFormatter customFormatter) {
        if (customFormatter == null) {
            throw new IllegalArgumentException("customFormatter cannot be null");
        }
        if (this.customFormatter == null) {
            this.customFormatter = customFormatter;
        } else {
            s_log.error("setCustomExceptionFormatter: An existing customFormatter ( " + this.customFormatter.getClass().getName() + " )has already " + "been set - ignoring " + customFormatter.getClass().getName());
        }
    }

    private String getDataTruncationMessage(DataTruncation ex) {
        StringBuilder buf = new StringBuilder();
        buf.append("Data Truncation error occurred on").append(ex.getRead() ? " a read " : " a write ").append(" of column ").append(ex.getIndex()).append("Data was ").append(ex.getDataSize()).append(" bytes long and ").append(ex.getTransferSize()).append(" bytes were transferred.");
        return buf.toString();
    }

    private String getSQLWarningMessage(SQLWarning ex) {
        StringBuilder buf = new StringBuilder();
        while (ex != null) {
            buf.append(this.buildMessage("Warning:   ", ex));
            ex = ex.getNextWarning();
        }
        return buf.toString();
    }

    private String getSQLExceptionMessage(SQLException ex) {
        StringBuilder buf = new StringBuilder();
        while (ex != null) {
            buf.append(this.buildMessage("Error: ", ex));
            if (s_log.isDebugEnabled()) {
                s_log.debug("Error", ex);
            }
            if ((ex = ex.getNextException()) == null) continue;
            buf.append("\n");
        }
        return buf.toString();
    }

    private String buildMessage(String prefix, SQLException ex) {
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        result.append(ex.getMessage());
        result.append("\nSQLState:  ");
        result.append(ex.getSQLState());
        result.append("\nErrorCode: ");
        result.append(ex.getErrorCode());
        return result.toString();
    }
}

