/*
 * Copyright (C) Huawei Technologies Co., Ltd. 2023-2024. All rights reserved.
 * SPDX-License-Identifier: MIT
 */

#ifndef VATOMIC_ARM64_LLSC_H
#define VATOMIC_ARM64_LLSC_H
/* !!!Warning: File generated by tmplr; DO NOT EDIT.!!! */

/*******************************************************************************
 * options
 ******************************************************************************/
#if !defined(VATOMIC_ARM64_LLSC)
    #error "Don't include this file directly, include <vsync/atomic.h> instead"
#endif

/******************************************************************************
 * vatomic32_xchg
 ******************************************************************************/
#ifndef VATOMIC32_XCHG
    #define VATOMIC32_XCHG
static inline vuint32_t
vatomic32_xchg(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "stlxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_xchg_acq
 ******************************************************************************/
#ifndef VATOMIC32_XCHG_ACQ
    #define VATOMIC32_XCHG_ACQ
static inline vuint32_t
vatomic32_xchg_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "stxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_xchg_rel
 ******************************************************************************/
#ifndef VATOMIC32_XCHG_REL
    #define VATOMIC32_XCHG_REL
static inline vuint32_t
vatomic32_xchg_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "stlxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_xchg_rlx
 ******************************************************************************/
#ifndef VATOMIC32_XCHG_RLX
    #define VATOMIC32_XCHG_RLX
static inline vuint32_t
vatomic32_xchg_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "stxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_xchg
 ******************************************************************************/
#ifndef VATOMIC64_XCHG
    #define VATOMIC64_XCHG
static inline vuint64_t
vatomic64_xchg(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_xchg_acq
 ******************************************************************************/
#ifndef VATOMIC64_XCHG_ACQ
    #define VATOMIC64_XCHG_ACQ
static inline vuint64_t
vatomic64_xchg_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_xchg_rel
 ******************************************************************************/
#ifndef VATOMIC64_XCHG_REL
    #define VATOMIC64_XCHG_REL
static inline vuint64_t
vatomic64_xchg_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_xchg_rlx
 ******************************************************************************/
#ifndef VATOMIC64_XCHG_RLX
    #define VATOMIC64_XCHG_RLX
static inline vuint64_t
vatomic64_xchg_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_xchg
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG
    #define VATOMICPTR_XCHG
static inline void *
vatomicptr_xchg(vatomicptr_t *a, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_xchg_acq
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG_ACQ
    #define VATOMICPTR_XCHG_ACQ
static inline void *
vatomicptr_xchg_acq(vatomicptr_t *a, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_xchg_rel
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG_REL
    #define VATOMICPTR_XCHG_REL
static inline void *
vatomicptr_xchg_rel(vatomicptr_t *a, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_xchg_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_XCHG_RLX
    #define VATOMICPTR_XCHG_RLX
static inline void *
vatomicptr_xchg_rlx(vatomicptr_t *a, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [a] "Q"(a->_v)
        : "memory");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG
    #define VATOMIC32_CMPXCHG
static inline vuint32_t
vatomic32_cmpxchg(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[exp]\n"
        "b.ne 2f\n"
        "stlxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg_acq
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG_ACQ
    #define VATOMIC32_CMPXCHG_ACQ
static inline vuint32_t
vatomic32_cmpxchg_acq(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[exp]\n"
        "b.ne 2f\n"
        "stxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg_rel
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG_REL
    #define VATOMIC32_CMPXCHG_REL
static inline vuint32_t
vatomic32_cmpxchg_rel(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[exp]\n"
        "b.ne 2f\n"
        "stlxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_cmpxchg_rlx
 ******************************************************************************/
#ifndef VATOMIC32_CMPXCHG_RLX
    #define VATOMIC32_CMPXCHG_RLX
static inline vuint32_t
vatomic32_cmpxchg_rlx(vatomic32_t *a, vuint32_t e, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[exp]\n"
        "b.ne 2f\n"
        "stxr  %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG
    #define VATOMIC64_CMPXCHG
static inline vuint64_t
vatomic64_cmpxchg(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg_acq
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG_ACQ
    #define VATOMIC64_CMPXCHG_ACQ
static inline vuint64_t
vatomic64_cmpxchg_acq(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg_rel
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG_REL
    #define VATOMIC64_CMPXCHG_REL
static inline vuint64_t
vatomic64_cmpxchg_rel(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_cmpxchg_rlx
 ******************************************************************************/
#ifndef VATOMIC64_CMPXCHG_RLX
    #define VATOMIC64_CMPXCHG_RLX
static inline vuint64_t
vatomic64_cmpxchg_rlx(vatomic64_t *a, vuint64_t e, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG
    #define VATOMICPTR_CMPXCHG
static inline void *
vatomicptr_cmpxchg(vatomicptr_t *a, void *e, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg_acq
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG_ACQ
    #define VATOMICPTR_CMPXCHG_ACQ
static inline void *
vatomicptr_cmpxchg_acq(vatomicptr_t *a, void *e, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg_rel
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG_REL
    #define VATOMICPTR_CMPXCHG_REL
static inline void *
vatomicptr_cmpxchg_rel(vatomicptr_t *a, void *e, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stlxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomicptr_cmpxchg_rlx
 ******************************************************************************/
#ifndef VATOMICPTR_CMPXCHG_RLX
    #define VATOMICPTR_CMPXCHG_RLX
static inline void *
vatomicptr_cmpxchg_rlx(vatomicptr_t *a, void *e, void *v)
{
    void *oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[exp]\n"
        "b.ne 2f\n"
        "stxr  %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp)
        : [newv] "r"(v), [exp] "r"(e), [a] "Q"(a->_v)
        : "memory", "cc");
    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_max
 ******************************************************************************/
#ifndef VATOMIC32_GET_MAX
    #define VATOMIC32_GET_MAX
static inline vuint32_t
vatomic32_get_max(vatomic32_t *a, vuint32_t v)
{
    vuint32_t tmp;
    vuint32_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[v]\n"
        "b.hs 2f\n"
        "stlxr %w[tmp], %w[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_max_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_MAX_ACQ
    #define VATOMIC32_GET_MAX_ACQ
static inline vuint32_t
vatomic32_get_max_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t tmp;
    vuint32_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[v]\n"
        "b.hs 2f\n"
        "stxr %w[tmp], %w[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_max_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_MAX_REL
    #define VATOMIC32_GET_MAX_REL
static inline vuint32_t
vatomic32_get_max_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t tmp;
    vuint32_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[v]\n"
        "b.hs 2f\n"
        "stlxr %w[tmp], %w[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_max_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_MAX_RLX
    #define VATOMIC32_GET_MAX_RLX
static inline vuint32_t
vatomic32_get_max_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t tmp;
    vuint32_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[v]\n"
        "b.hs 2f\n"
        "stxr %w[tmp], %w[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_max
 ******************************************************************************/
#ifndef VATOMIC64_GET_MAX
    #define VATOMIC64_GET_MAX
static inline vuint64_t
vatomic64_get_max(vatomic64_t *a, vuint64_t v)
{
    vuint32_t tmp;
    vuint64_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[v]\n"
        "b.hs 2f\n"
        "stlxr %w[tmp], %x[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_max_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_MAX_ACQ
    #define VATOMIC64_GET_MAX_ACQ
static inline vuint64_t
vatomic64_get_max_acq(vatomic64_t *a, vuint64_t v)
{
    vuint32_t tmp;
    vuint64_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[v]\n"
        "b.hs 2f\n"
        "stxr %w[tmp], %x[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_max_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_MAX_REL
    #define VATOMIC64_GET_MAX_REL
static inline vuint64_t
vatomic64_get_max_rel(vatomic64_t *a, vuint64_t v)
{
    vuint32_t tmp;
    vuint64_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[v]\n"
        "b.hs 2f\n"
        "stlxr %w[tmp], %x[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_max_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_MAX_RLX
    #define VATOMIC64_GET_MAX_RLX
static inline vuint64_t
vatomic64_get_max_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint32_t tmp;
    vuint64_t oldv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[v]\n"
        "b.hs 2f\n"
        "stxr %w[tmp], %x[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_max
 ******************************************************************************/
#ifndef VATOMIC32_MAX
    #define VATOMIC32_MAX
static inline void
vatomic32_max(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[v]\n"
        "b.hs 2f\n"
        "stlxr  %w[tmp], %w[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_max_rel
 ******************************************************************************/
#ifndef VATOMIC32_MAX_REL
    #define VATOMIC32_MAX_REL
static inline void
vatomic32_max_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[v]\n"
        "b.hs 2f\n"
        "stlxr  %w[tmp], %w[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_max_rlx
 ******************************************************************************/
#ifndef VATOMIC32_MAX_RLX
    #define VATOMIC32_MAX_RLX
static inline void
vatomic32_max_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "cmp %w[oldv], %w[v]\n"
        "b.hs 2f\n"
        "stxr  %w[tmp], %w[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_max
 ******************************************************************************/
#ifndef VATOMIC64_MAX
    #define VATOMIC64_MAX
static inline void
vatomic64_max(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[v]\n"
        "b.hs 2f\n"
        "stlxr  %w[tmp], %x[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_max_rel
 ******************************************************************************/
#ifndef VATOMIC64_MAX_REL
    #define VATOMIC64_MAX_REL
static inline void
vatomic64_max_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[v]\n"
        "b.hs 2f\n"
        "stlxr  %w[tmp], %x[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_max_rlx
 ******************************************************************************/
#ifndef VATOMIC64_MAX_RLX
    #define VATOMIC64_MAX_RLX
static inline void
vatomic64_max_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "cmp %x[oldv], %x[v]\n"
        "b.hs 2f\n"
        "stxr  %w[tmp], %x[v], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        "2:\n"
        : [oldv] "=&r"(oldv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_get_and
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND
    #define VATOMIC32_GET_AND
static inline vuint32_t
vatomic32_get_and(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "and %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR
    #define VATOMIC32_GET_OR
static inline vuint32_t
vatomic32_get_or(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "orr %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR
    #define VATOMIC32_GET_XOR
static inline vuint32_t
vatomic32_get_xor(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "eor %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD
    #define VATOMIC32_GET_ADD
static inline vuint32_t
vatomic32_get_add(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "add %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB
    #define VATOMIC32_GET_SUB
static inline vuint32_t
vatomic32_get_sub(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "sub %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_and_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND_ACQ
    #define VATOMIC32_GET_AND_ACQ
static inline vuint32_t
vatomic32_get_and_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "and %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR_ACQ
    #define VATOMIC32_GET_OR_ACQ
static inline vuint32_t
vatomic32_get_or_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "orr %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR_ACQ
    #define VATOMIC32_GET_XOR_ACQ
static inline vuint32_t
vatomic32_get_xor_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "eor %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD_ACQ
    #define VATOMIC32_GET_ADD_ACQ
static inline vuint32_t
vatomic32_get_add_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "add %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub_acq
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB_ACQ
    #define VATOMIC32_GET_SUB_ACQ
static inline vuint32_t
vatomic32_get_sub_acq(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "sub %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_and_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND_REL
    #define VATOMIC32_GET_AND_REL
static inline vuint32_t
vatomic32_get_and_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "and %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR_REL
    #define VATOMIC32_GET_OR_REL
static inline vuint32_t
vatomic32_get_or_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "orr %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR_REL
    #define VATOMIC32_GET_XOR_REL
static inline vuint32_t
vatomic32_get_xor_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "eor %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD_REL
    #define VATOMIC32_GET_ADD_REL
static inline vuint32_t
vatomic32_get_add_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "add %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub_rel
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB_REL
    #define VATOMIC32_GET_SUB_REL
static inline vuint32_t
vatomic32_get_sub_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "sub %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_and_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_AND_RLX
    #define VATOMIC32_GET_AND_RLX
static inline vuint32_t
vatomic32_get_and_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "and %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_or_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_OR_RLX
    #define VATOMIC32_GET_OR_RLX
static inline vuint32_t
vatomic32_get_or_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "orr %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_xor_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_XOR_RLX
    #define VATOMIC32_GET_XOR_RLX
static inline vuint32_t
vatomic32_get_xor_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "eor %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_add_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_ADD_RLX
    #define VATOMIC32_GET_ADD_RLX
static inline vuint32_t
vatomic32_get_add_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "add %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_get_sub_rlx
 ******************************************************************************/
#ifndef VATOMIC32_GET_SUB_RLX
    #define VATOMIC32_GET_SUB_RLX
static inline vuint32_t
vatomic32_get_sub_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t tmp;
    vuint32_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "sub %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND
    #define VATOMIC64_GET_AND
static inline vuint64_t
vatomic64_get_and(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "and %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR
    #define VATOMIC64_GET_OR
static inline vuint64_t
vatomic64_get_or(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "orr %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR
    #define VATOMIC64_GET_XOR
static inline vuint64_t
vatomic64_get_xor(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "eor %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD
    #define VATOMIC64_GET_ADD
static inline vuint64_t
vatomic64_get_add(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "add %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB
    #define VATOMIC64_GET_SUB
static inline vuint64_t
vatomic64_get_sub(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "sub %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND_ACQ
    #define VATOMIC64_GET_AND_ACQ
static inline vuint64_t
vatomic64_get_and_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "and %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR_ACQ
    #define VATOMIC64_GET_OR_ACQ
static inline vuint64_t
vatomic64_get_or_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "orr %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR_ACQ
    #define VATOMIC64_GET_XOR_ACQ
static inline vuint64_t
vatomic64_get_xor_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "eor %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD_ACQ
    #define VATOMIC64_GET_ADD_ACQ
static inline vuint64_t
vatomic64_get_add_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "add %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub_acq
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB_ACQ
    #define VATOMIC64_GET_SUB_ACQ
static inline vuint64_t
vatomic64_get_sub_acq(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "sub %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND_REL
    #define VATOMIC64_GET_AND_REL
static inline vuint64_t
vatomic64_get_and_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "and %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR_REL
    #define VATOMIC64_GET_OR_REL
static inline vuint64_t
vatomic64_get_or_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "orr %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR_REL
    #define VATOMIC64_GET_XOR_REL
static inline vuint64_t
vatomic64_get_xor_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "eor %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD_REL
    #define VATOMIC64_GET_ADD_REL
static inline vuint64_t
vatomic64_get_add_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "add %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub_rel
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB_REL
    #define VATOMIC64_GET_SUB_REL
static inline vuint64_t
vatomic64_get_sub_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "sub %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_and_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_AND_RLX
    #define VATOMIC64_GET_AND_RLX
static inline vuint64_t
vatomic64_get_and_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "and %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_or_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_OR_RLX
    #define VATOMIC64_GET_OR_RLX
static inline vuint64_t
vatomic64_get_or_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "orr %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_xor_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_XOR_RLX
    #define VATOMIC64_GET_XOR_RLX
static inline vuint64_t
vatomic64_get_xor_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "eor %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_add_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_ADD_RLX
    #define VATOMIC64_GET_ADD_RLX
static inline vuint64_t
vatomic64_get_add_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "add %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic64_get_sub_rlx
 ******************************************************************************/
#ifndef VATOMIC64_GET_SUB_RLX
    #define VATOMIC64_GET_SUB_RLX
static inline vuint64_t
vatomic64_get_sub_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint32_t tmp;
    vuint64_t newv;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "sub %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");

    return oldv;
}
#endif
/******************************************************************************
 * vatomic32_and
 ******************************************************************************/
#ifndef VATOMIC32_AND
    #define VATOMIC32_AND
static inline void
vatomic32_and(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "and %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_or
 ******************************************************************************/
#ifndef VATOMIC32_OR
    #define VATOMIC32_OR
static inline void
vatomic32_or(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "orr %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_xor
 ******************************************************************************/
#ifndef VATOMIC32_XOR
    #define VATOMIC32_XOR
static inline void
vatomic32_xor(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "eor %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_add
 ******************************************************************************/
#ifndef VATOMIC32_ADD
    #define VATOMIC32_ADD
static inline void
vatomic32_add(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "add %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_sub
 ******************************************************************************/
#ifndef VATOMIC32_SUB
    #define VATOMIC32_SUB
static inline void
vatomic32_sub(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %w[oldv], %[a]\n"
        "sub %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_and_rel
 ******************************************************************************/
#ifndef VATOMIC32_AND_REL
    #define VATOMIC32_AND_REL
static inline void
vatomic32_and_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "and %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_or_rel
 ******************************************************************************/
#ifndef VATOMIC32_OR_REL
    #define VATOMIC32_OR_REL
static inline void
vatomic32_or_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "orr %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_xor_rel
 ******************************************************************************/
#ifndef VATOMIC32_XOR_REL
    #define VATOMIC32_XOR_REL
static inline void
vatomic32_xor_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "eor %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_add_rel
 ******************************************************************************/
#ifndef VATOMIC32_ADD_REL
    #define VATOMIC32_ADD_REL
static inline void
vatomic32_add_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "add %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_sub_rel
 ******************************************************************************/
#ifndef VATOMIC32_SUB_REL
    #define VATOMIC32_SUB_REL
static inline void
vatomic32_sub_rel(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "sub %w[newv], %w[oldv], %w[v]\n"
        "stlxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_and_rlx
 ******************************************************************************/
#ifndef VATOMIC32_AND_RLX
    #define VATOMIC32_AND_RLX
static inline void
vatomic32_and_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "and %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_or_rlx
 ******************************************************************************/
#ifndef VATOMIC32_OR_RLX
    #define VATOMIC32_OR_RLX
static inline void
vatomic32_or_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "orr %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_xor_rlx
 ******************************************************************************/
#ifndef VATOMIC32_XOR_RLX
    #define VATOMIC32_XOR_RLX
static inline void
vatomic32_xor_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "eor %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_add_rlx
 ******************************************************************************/
#ifndef VATOMIC32_ADD_RLX
    #define VATOMIC32_ADD_RLX
static inline void
vatomic32_add_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "add %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic32_sub_rlx
 ******************************************************************************/
#ifndef VATOMIC32_SUB_RLX
    #define VATOMIC32_SUB_RLX
static inline void
vatomic32_sub_rlx(vatomic32_t *a, vuint32_t v)
{
    vuint32_t oldv;
    vuint32_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %w[oldv], %[a]\n"
        "sub %w[newv], %w[oldv], %w[v]\n"
        "stxr %w[tmp], %w[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_and
 ******************************************************************************/
#ifndef VATOMIC64_AND
    #define VATOMIC64_AND
static inline void
vatomic64_and(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "and %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_or
 ******************************************************************************/
#ifndef VATOMIC64_OR
    #define VATOMIC64_OR
static inline void
vatomic64_or(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "orr %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_xor
 ******************************************************************************/
#ifndef VATOMIC64_XOR
    #define VATOMIC64_XOR
static inline void
vatomic64_xor(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "eor %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_add
 ******************************************************************************/
#ifndef VATOMIC64_ADD
    #define VATOMIC64_ADD
static inline void
vatomic64_add(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "add %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_sub
 ******************************************************************************/
#ifndef VATOMIC64_SUB
    #define VATOMIC64_SUB
static inline void
vatomic64_sub(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldaxr %x[oldv], %[a]\n"
        "sub %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_and_rel
 ******************************************************************************/
#ifndef VATOMIC64_AND_REL
    #define VATOMIC64_AND_REL
static inline void
vatomic64_and_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "and %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_or_rel
 ******************************************************************************/
#ifndef VATOMIC64_OR_REL
    #define VATOMIC64_OR_REL
static inline void
vatomic64_or_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "orr %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_xor_rel
 ******************************************************************************/
#ifndef VATOMIC64_XOR_REL
    #define VATOMIC64_XOR_REL
static inline void
vatomic64_xor_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "eor %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_add_rel
 ******************************************************************************/
#ifndef VATOMIC64_ADD_REL
    #define VATOMIC64_ADD_REL
static inline void
vatomic64_add_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "add %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_sub_rel
 ******************************************************************************/
#ifndef VATOMIC64_SUB_REL
    #define VATOMIC64_SUB_REL
static inline void
vatomic64_sub_rel(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "sub %x[newv], %x[oldv], %x[v]\n"
        "stlxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_and_rlx
 ******************************************************************************/
#ifndef VATOMIC64_AND_RLX
    #define VATOMIC64_AND_RLX
static inline void
vatomic64_and_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "and %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_or_rlx
 ******************************************************************************/
#ifndef VATOMIC64_OR_RLX
    #define VATOMIC64_OR_RLX
static inline void
vatomic64_or_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "orr %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_xor_rlx
 ******************************************************************************/
#ifndef VATOMIC64_XOR_RLX
    #define VATOMIC64_XOR_RLX
static inline void
vatomic64_xor_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "eor %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_add_rlx
 ******************************************************************************/
#ifndef VATOMIC64_ADD_RLX
    #define VATOMIC64_ADD_RLX
static inline void
vatomic64_add_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "add %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
/******************************************************************************
 * vatomic64_sub_rlx
 ******************************************************************************/
#ifndef VATOMIC64_SUB_RLX
    #define VATOMIC64_SUB_RLX
static inline void
vatomic64_sub_rlx(vatomic64_t *a, vuint64_t v)
{
    vuint64_t oldv;
    vuint64_t newv;
    vuint32_t tmp;
    __asm__ volatile(
        "prfm pstl1strm, %[a]\n"
        "1:\n"
        "ldxr %x[oldv], %[a]\n"
        "sub %x[newv], %x[oldv], %x[v]\n"
        "stxr %w[tmp], %x[newv], %[a]\n"
        "cbnz %w[tmp], 1b\n"
        : [oldv] "=&r"(oldv), [newv] "=&r"(newv), [tmp] "=&r"(tmp), [v] "+&r"(v)
        : [a] "Q"(a->_v)
        : "memory", "cc");
}
#endif
#endif
