/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*  xmc.h								*
*									*
*	Definitions used by both xmx and xmc client applications.	*
*									*
************************************************************************/
#ifndef XMC_H
#define XMC_H

/*
**  Input Modes
*/
#define View			1
#define Seat			2
#define Floor			3

/*
**  Config Modes
*/
#define ConfigAny		0
#define ConfigAllow		1
#define ConfigDelay		2

/*
**  Permissions
*/
#define BasePerms		0x0000
#define AddMine			0x0001
#define AddAny			0x0002
#define FloorMine		0x0004
#define FloorAny		0x0008
#define SeatMine		0x0010
#define SeatAny			0x0020
#define GrabMine		0x0040
#define GrabAny			0x0080
#define TptrMine		0x0100
#define TptrAny			0x0200
#define SelectMine		0x0400
#define SelectAny		0x0800
#define SuperPerms		0x1000

/*
**	Events
*/
#define DisplayInEvent		2
#define DisplayRefusedEvent	3
#define DisplayOutEvent		4
#define DisplayTagEvent		5
#define ModeFloorEvent		6
#define ModeSeatEvent		7
#define ModeViewEvent		8
#define PointerGrabEvent	9
#define PointerNoGrabEvent	10
#define PointerUngrabEvent	11
#define KeyboardGrabEvent	12
#define KeyboardNoGrabEvent	13
#define KeyboardUngrabEvent	14
#define ShareSelectionsEvent	15
#define UnshareSelectionsEvent	16
#define TptrAssignEvent		17
#define TptrHideEvent		18
#define TptrShowEvent		19
#define ConfigModeEvent		20
#define SeatKeyPressEvent	21
#define SeatKeyReleaseEvent	22
#define SeatButtonPressEvent	23
#define SeatButtonReleaseEvent	24

/*
**	Event Masks
**
**	The first four just happen to match (ahem) the corresponding
**	masks in the X protocol.
*/
#define SeatKeyPressMask	(1<<0)
#define SeatKeyReleaseMask	(1<<1)
#define SeatButtonPressMask	(1<<2)
#define SeatButtonReleaseMask	(1<<3)
#define DisplayMask		(1<<4)
#define InputModeMask		(1<<5)
#define GrabPointerMask		(1<<6)
#define GrabKeyboardMask	(1<<7)
#define SelectionMask		(1<<8)
#define TptrAssignMask		(1<<9)
#define TptrVisibilityMask	(1<<10)

/*
**	Errors
*/
#define ErrDisplay		1
#define ErrConfig		2
#define ErrMerge		3
#define ErrEvent		4
#define ErrAlloc		5
#define ErrConnect		6
#define ErrTelepointer		7
#define ErrId			8
#define ErrGeometry		9

/*
**	These are chosen to match X Protocol
*/
#define AddrFamInternet		0
#define AddrFamDECnet		1
#define AddrFamChaos		2
#define AddrFamLocal		256

#endif /* XMC_H */
