/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.ByteBufferFactory;
import com.sun.grizzly.util.ExtendedThreadPool;
import com.sun.grizzly.util.LoggerUtils;
import com.sun.grizzly.util.WorkerThreadImpl;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public class DefaultThreadPool
extends ThreadPoolExecutor
implements ExecutorService,
ExtendedThreadPool,
Thread.UncaughtExceptionHandler {
    public static int DEFAULT_MIN_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_THREAD_COUNT = 5;
    public static int DEFAULT_MAX_TASKS_QUEUED = Integer.MAX_VALUE;
    public static int DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT = 30000;
    protected String name = "Grizzly";
    protected int maxTasksCount;
    protected AtomicInteger workerThreadCounter = new AtomicInteger();
    protected int priority = 5;
    protected int initialByteBufferSize = 8192;
    protected ByteBufferFactory.ByteBufferType byteBufferType = ByteBufferFactory.ByteBufferType.HEAP_VIEW;

    public DefaultThreadPool() {
        this(DEFAULT_MIN_THREAD_COUNT, DEFAULT_MAX_THREAD_COUNT, DEFAULT_MAX_TASKS_QUEUED, DEFAULT_IDLE_THREAD_KEEPALIVE_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public DefaultThreadPool(int corePoolSize, int maximumPoolSize, int maxTasksCount, long keepAliveTime, TimeUnit unit) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(maxTasksCount));
        this.setThreadFactory(new DefaultWorkerThreadFactory());
        this.maxTasksCount = maxTasksCount;
    }

    public int getQueuedTasksCount() {
        return this.getQueue().size();
    }

    public int getMaxQueuedTasksCount() {
        return this.maxTasksCount;
    }

    public void setMaxQueuedTasksCount(int maxTasksCount) {
        throw new UnsupportedOperationException("Value could not be changed!");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getQueueSize() {
        return this.getQueue().size();
    }

    public ByteBufferFactory.ByteBufferType getByteBufferType() {
        return this.byteBufferType;
    }

    public void setByteBufferType(ByteBufferFactory.ByteBufferType byteBufferType) {
        this.byteBufferType = byteBufferType;
    }

    public int getInitialByteBufferSize() {
        return this.initialByteBufferSize;
    }

    public void setInitialByteBufferSize(int initialByteBufferSize) {
        this.initialByteBufferSize = initialByteBufferSize;
    }

    public void start() {
        this.prestartCoreThread();
    }

    public void stop() {
        this.shutdownNow();
    }

    public void uncaughtException(Thread thread, Throwable throwable) {
        LoggerUtils.getLogger().log(Level.WARNING, "Uncaught thread exception. Thread: " + thread, throwable);
    }

    protected void beforeExecute(Thread t, Runnable r) {
        ((WorkerThreadImpl)t).createByteBuffer(false);
    }

    protected void afterExecute(Runnable r, Throwable t) {
        ((WorkerThreadImpl)Thread.currentThread()).reset();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(512);
        builder.append("DefaultThreadPool[");
        this.injectToStringAttributes(builder);
        builder.append(']');
        return builder.toString();
    }

    protected void injectToStringAttributes(StringBuilder sb) {
        sb.append("name=").append(this.name);
        sb.append(", priority=").append(this.priority);
        sb.append(", min-threads=").append(this.getCorePoolSize());
        sb.append(", max-threads=").append(this.getMaximumPoolSize());
        sb.append(", max-queue-size=").append(this.getMaxQueuedTasksCount());
        sb.append(", initial-byte-buffer-size=").append(this.initialByteBufferSize);
        sb.append(", byte-buffer-type=").append((Object)this.byteBufferType);
        sb.append(", is-shutdown=").append(this.isShutdown());
    }

    private class DefaultWorkerThreadFactory
    implements ThreadFactory {
        private DefaultWorkerThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            WorkerThreadImpl thread = new WorkerThreadImpl(DefaultThreadPool.this, DefaultThreadPool.this.name + "-WorkerThread(" + DefaultThreadPool.this.workerThreadCounter.getAndIncrement() + ")", r, DefaultThreadPool.this.initialByteBufferSize);
            thread.setUncaughtExceptionHandler(DefaultThreadPool.this);
            thread.setPriority(DefaultThreadPool.this.priority);
            return thread;
        }
    }
}

