/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.border.BackgroundBorder;
import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;

public class QuaquaToolBarUI
extends BasicToolBarUI {
    private static final String IS_ROLLOVER = "JToolBar.isRollover";
    static final String TOOLBAR_DRAW_DIVIDER_PROPERTY = "Quaqua.ToolBar.isDividerDrawn";
    public static final String TOOLBAR_STYLE_PROPERTY = "Quaqua.ToolBar.style";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private HashMap borderTable = new HashMap();
    private Hashtable rolloverTable = new Hashtable();
    private Handler handler;
    private Point dragWindowOffset = null;
    private Container dockingSource;
    private boolean floating;
    private RootPaneContainer floatingToolBar;
    private int floatingX;
    private int floatingY;
    protected DragWindow0 dragWindow0;
    private int dockingSensitivity = 0;

    public static ComponentUI createUI(JComponent c) {
        return new QuaquaToolBarUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.dragWindow0 = null;
        this.dockingSource = null;
        this.floatingToolBar = null;
    }

    protected void installDefaults() {
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        super.installDefaults();
        QuaquaUtilities.installProperty(this.toolBar, "opaque", UIManager.get("ToolBar.opaque"));
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected ContainerListener createToolBarContListener() {
        return this.getHandler();
    }

    protected FocusListener createToolBarFocusListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyListener() {
        return this.getHandler();
    }

    protected MouseInputListener createDockingListener() {
        this.getHandler().tb = this.toolBar;
        return this.getHandler();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    public void paint(Graphics gr, JComponent c) {
        if (c.isOpaque()) {
            Graphics2D g = (Graphics2D)gr;
            if (c.getBorder() instanceof BackgroundBorder) {
                Border bb = ((BackgroundBorder)c.getBorder()).getBackgroundBorder();
                bb.paintBorder(c, g, 0, 0, c.getWidth(), c.getHeight());
            } else {
                g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
            }
        }
    }

    protected void paintDragWindow(Graphics g) {
        int w = this.dragWindow0.getWidth();
        int h = this.dragWindow0.getHeight();
        g.setColor(this.dragWindow0.getBackground());
        g.fillRect(0, 0, w, h);
        Graphics g2 = g.create();
        this.toolBar.paint(g2);
        g2.dispose();
        g.setColor(this.dragWindow0.getBorderColor());
        g.drawRect(0, 0, w - 1, h - 1);
    }

    protected RootPaneContainer createFloatingWindow(JToolBar toolbar) {
        Window window = SwingUtilities.getWindowAncestor(toolbar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            public ToolBarDialog(Dialog owner, String title, boolean modal) {
                super(owner, title, modal);
            }

            protected JRootPane createRootPane() {
                JRootPane rootPane = new JRootPane(){
                    private boolean packing = false;

                    public void validate() {
                        this.putClientProperty("Quaqua.RootPane.isVertical", QuaquaToolBarUI.this.toolBar.getOrientation() == 1 ? Boolean.FALSE : Boolean.TRUE);
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                rootPane.setFont(UIManager.getFont("ToolBar.titleFont"));
                rootPane.putClientProperty("Quaqua.RootPane.isPalette", Boolean.TRUE);
                QuaquaUtilities.installProperty(rootPane, "opaque", Boolean.TRUE);
                return rootPane;
            }
        }
        ToolBarDialog dialog = window instanceof Frame ? new ToolBarDialog((Frame)window, toolbar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, toolbar.getName(), false) : new ToolBarDialog((Frame)null, toolbar.getName(), false));
        try {
            Methods.invoke((Object)dialog, "setUndecorated", true);
            Methods.invoke((Object)dialog.getRootPane(), "setWindowDecorationStyle", 1);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        dialog.setTitle(toolbar.getName());
        dialog.setResizable(false);
        WindowListener wl = this.createFrameListener();
        dialog.addWindowListener(wl);
        dialog.getRootPane().putClientProperty("JDialog.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("JFrame.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("Dialog.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("Frame.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("JWindow.isPalette", Boolean.TRUE);
        dialog.getRootPane().putClientProperty("Window.isPalette", Boolean.TRUE);
        return dialog;
    }

    protected Border createRolloverBorder() {
        return UIManager.getBorder("Button.border");
    }

    protected Border createNonRolloverBorder() {
        return UIManager.getBorder("Button.border");
    }

    private Border createNonRolloverToggleBorder() {
        return UIManager.getBorder("Button.border");
    }

    protected DragWindow0 createDragWindow0(JToolBar toolbar) {
        Window frame = null;
        if (this.toolBar != null) {
            Container p;
            for (p = this.toolBar.getParent(); p != null && !(p instanceof Window); p = p.getParent()) {
            }
            if (p != null) {
                frame = (Window)p;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            frame = (Window)((Object)this.floatingToolBar);
        }
        DragWindow0 dragW = new DragWindow0(frame);
        JRootPane rp = dragW.getRootPane();
        rp.putClientProperty("Window.alpha", new Float(0.5f));
        return dragW;
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                b.setBorder(rolloverBorder);
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(true);
        }
    }

    protected void setBorderToNonRollover(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.get(b);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(b, b.getBorder());
            }
            if (b.getBorder() instanceof UIResource) {
                if (b instanceof JToggleButton) {
                    ((JToggleButton)b).setBorder(nonRolloverToggleBorder);
                } else {
                    b.setBorder(nonRolloverBorder);
                }
            }
            this.rolloverTable.put(b, b.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            b.setRolloverEnabled(false);
        }
    }

    protected void setBorderToNormal(Component c) {
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            Border border = (Border)this.borderTable.remove(b);
            b.setBorder(border);
            Boolean value = (Boolean)this.rolloverTable.remove(b);
            if (value != null) {
                b.setRolloverEnabled(value);
            }
        }
    }

    public void setFloatingLocation(int x, int y) {
        this.floatingX = x;
        this.floatingY = y;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean b, Point p) {
        if (this.toolBar.isFloatable()) {
            if (this.dragWindow0 != null) {
                this.dragWindow0.setVisible(false);
            }
            this.floating = b;
            if (b) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(true);
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                String constraint = this.getDockingConstraint(this.dockingSource, p);
                if (constraint == null) {
                    constraint = "North";
                }
                int orientation = this.mapConstraintToOrientation(constraint);
                this.setOrientation(orientation);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add(constraint, this.toolBar);
            }
            this.dockingSource.invalidate();
            Container dockingSourceParent = this.dockingSource.getParent();
            if (dockingSourceParent != null) {
                dockingSourceParent.validate();
            }
            this.dockingSource.repaint();
        }
    }

    private String getDockingConstraint(Component c, Point p) {
        if (p == null) {
            return this.constraintBeforeFloating;
        }
        if (c.contains(p)) {
            int n = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (p.y < this.dockingSensitivity && !this.isBlocked(c, "North")) {
                return "North";
            }
            if (p.x >= c.getWidth() - this.dockingSensitivity && !this.isBlocked(c, "East")) {
                return "East";
            }
            if (p.x < this.dockingSensitivity && !this.isBlocked(c, "West")) {
                return "West";
            }
            if (p.y >= c.getHeight() - this.dockingSensitivity && !this.isBlocked(c, "South")) {
                return "South";
            }
        }
        return null;
    }

    private boolean isBlocked(Component comp, Object constraint) {
        Container cont;
        LayoutManager lm;
        if (comp instanceof Container && (lm = (cont = (Container)comp).getLayout()) instanceof BorderLayout) {
            BorderLayout blm = (BorderLayout)lm;
            Component c = null;
            try {
                c = (Component)Methods.invoke((Object)blm, "getLayoutComponent", new Class[]{Container.class, Object.class}, new Object[]{cont, constraint});
            }
            catch (Throwable ex) {
                // empty catch block
            }
            return c != null && c != this.toolBar;
        }
        return false;
    }

    protected void dragTo(Point position, Point origin) {
        Window ancestorWindow;
        if (this.toolBar.isFloatable()) {
            try {
                Point offset;
                if (this.dragWindow0 == null) {
                    this.dragWindow0 = this.createDragWindow0(this.toolBar);
                }
                if ((offset = this.dragWindow0.getOffset()) == null) {
                    Dimension size = this.toolBar.getPreferredSize();
                    offset = new Point(size.width / 2, size.height / 2);
                    this.dragWindow0.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                Point dragPoint = new Point(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                Point dockingPosition = this.dockingSource.getLocationOnScreen();
                Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                if (this.canDock(this.dockingSource, comparisonPoint)) {
                    this.dragWindow0.setBackground(this.getDockingColor());
                    String constraint = this.getDockingConstraint(this.dockingSource, comparisonPoint);
                    int orientation = this.mapConstraintToOrientation(constraint);
                    this.dragWindow0.setOrientation(orientation);
                    this.dragWindow0.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow0.setBackground(this.getFloatingColor());
                    this.dragWindow0.setBorderColor(this.floatingBorderColor);
                }
                this.dragWindow0.setLocation(dragPoint.x, dragPoint.y);
                if (!this.dragWindow0.isVisible()) {
                    Dimension size = this.toolBar.getPreferredSize();
                    this.dragWindow0.setSize(size.width, size.height);
                    this.dragWindow0.setVisible(true);
                }
            }
            catch (IllegalComponentStateException e) {}
        } else if (this.isDragMovesWindow() && (ancestorWindow = SwingUtilities.getWindowAncestor(this.toolBar)) != null) {
            if (this.dragWindowOffset == null) {
                this.dragWindowOffset = new Point(position);
            }
            Point loc = ancestorWindow.getLocation();
            ancestorWindow.setLocation(loc.x + position.x - this.dragWindowOffset.x, loc.y + position.y - this.dragWindowOffset.y);
        }
    }

    protected void floatAt(Point position, Point origin) {
        if (this.toolBar.isFloatable()) {
            try {
                Point offset = this.dragWindow0.getOffset();
                if (offset == null) {
                    offset = position;
                    this.dragWindow0.setOffset(offset);
                }
                Point global = new Point(origin.x + position.x, origin.y + position.y);
                this.setFloatingLocation(global.x - offset.x, global.y - offset.y);
                if (this.dockingSource != null) {
                    Point dockingPosition = this.dockingSource.getLocationOnScreen();
                    Point comparisonPoint = new Point(global.x - dockingPosition.x, global.y - dockingPosition.y);
                    if (this.canDock(this.dockingSource, comparisonPoint)) {
                        this.setFloating(false, comparisonPoint);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow0.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    private int mapConstraintToOrientation(String constraint) {
        int orientation = this.toolBar.getOrientation();
        if (constraint != null) {
            if (constraint.equals("East") || constraint.equals("West")) {
                orientation = 1;
            } else if (constraint.equals("North") || constraint.equals("South")) {
                orientation = 0;
            }
        }
        return orientation;
    }

    public void setOrientation(int orientation) {
        this.toolBar.setOrientation(orientation);
        if (this.dragWindow0 != null) {
            this.dragWindow0.setOrientation(orientation);
        }
    }

    private String calculateConstraint() {
        String constraint = null;
        LayoutManager lm = this.dockingSource.getLayout();
        if (lm instanceof BorderLayout) {
            BorderLayout bl = (BorderLayout)lm;
            try {
                constraint = (String)Methods.invoke((Object)bl, "getConstraints", new Class[]{Component.class}, new Object[]{this.toolBar});
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        return constraint != null ? constraint : this.constraintBeforeFloating;
    }

    private boolean isDragMovesWindow() {
        Object toolBarStyle = this.toolBar.getClientProperty(TOOLBAR_STYLE_PROPERTY);
        if (toolBarStyle == null) {
            JRootPane rootPane = SwingUtilities.getRootPane(this.toolBar);
            int xOffset = 0;
            int yOffset = 0;
            for (Container c = this.toolBar; c != rootPane; c = c.getParent()) {
                xOffset += ((Component)c).getX();
                yOffset += ((Component)c).getY();
            }
            Object object = toolBarStyle = yOffset == 0 ? "title" : "plain";
        }
        if (UIManager.getBoolean("ToolBar.textured.dragMovesWindow")) {
            boolean isTextured = QuaquaUtilities.isOnTexturedWindow(this.toolBar);
            return isTextured && toolBarStyle.equals("title") || toolBarStyle.equals("bottom");
        }
        return false;
    }

    protected class DragWindow0
    extends JWindow {
        Color borderColor;
        int orientation;
        Point offset;

        DragWindow0(Window w) {
            super(w);
            this.borderColor = Color.gray;
            this.orientation = QuaquaToolBarUI.this.toolBar.getOrientation();
        }

        public void setOrientation(int o) {
            if (this.isShowing()) {
                if (o == this.orientation) {
                    return;
                }
                this.orientation = o;
                Dimension size = this.getSize();
                this.setSize(new Dimension(size.height, size.width));
                if (this.offset != null) {
                    if (QuaquaUtilities.isLeftToRight(QuaquaToolBarUI.this.toolBar)) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (o == 0) {
                        this.setOffset(new Point(size.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, size.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point p) {
            this.offset = p;
        }

        public void setBorderColor(Color c) {
            if (this.borderColor == c) {
                return;
            }
            this.borderColor = c;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        public void paint(Graphics g) {
            QuaquaToolBarUI.this.paintDragWindow(g);
            super.paint(g);
        }

        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        public void windowClosing(WindowEvent w) {
            if (QuaquaToolBarUI.this.toolBar.isFloatable()) {
                if (QuaquaToolBarUI.this.dragWindow0 != null) {
                    QuaquaToolBarUI.this.dragWindow0.setVisible(false);
                }
                QuaquaToolBarUI.this.floating = false;
                if (QuaquaToolBarUI.this.floatingToolBar == null) {
                    QuaquaToolBarUI.this.floatingToolBar = QuaquaToolBarUI.this.createFloatingWindow(QuaquaToolBarUI.this.toolBar);
                }
                if (QuaquaToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)QuaquaToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                QuaquaToolBarUI.this.floatingToolBar.getContentPane().remove(QuaquaToolBarUI.this.toolBar);
                String constraint = QuaquaToolBarUI.this.constraintBeforeFloating;
                if (QuaquaToolBarUI.this.toolBar.getOrientation() == 0) {
                    if (constraint == "West" || constraint == "East") {
                        constraint = "North";
                    }
                } else if (constraint == "North" || constraint == "South") {
                    constraint = "West";
                }
                if (QuaquaToolBarUI.this.dockingSource == null) {
                    QuaquaToolBarUI.this.dockingSource = QuaquaToolBarUI.this.toolBar.getParent();
                }
                if (QuaquaToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(QuaquaToolBarUI.this.propertyListener);
                }
                QuaquaToolBarUI.this.dockingSource.add((Component)QuaquaToolBarUI.this.toolBar, constraint);
                QuaquaToolBarUI.this.dockingSource.invalidate();
                Container dockingSourceParent = QuaquaToolBarUI.this.dockingSource.getParent();
                if (dockingSourceParent != null) {
                    dockingSourceParent.validate();
                }
                QuaquaToolBarUI.this.dockingSource.repaint();
            }
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        JToolBar tb;
        boolean isDragging = false;
        Point origin = null;

        private Handler() {
        }

        public void componentAdded(ContainerEvent evt) {
            Component c = evt.getChild();
            if (QuaquaToolBarUI.this.toolBarFocusListener != null) {
                c.addFocusListener(QuaquaToolBarUI.this.toolBarFocusListener);
            }
            if (QuaquaToolBarUI.this.isRolloverBorders()) {
                QuaquaToolBarUI.this.setBorderToRollover(c);
            } else {
                QuaquaToolBarUI.this.setBorderToNonRollover(c);
            }
        }

        public void componentRemoved(ContainerEvent evt) {
            Component c = evt.getChild();
            if (QuaquaToolBarUI.this.toolBarFocusListener != null) {
                c.removeFocusListener(QuaquaToolBarUI.this.toolBarFocusListener);
            }
            QuaquaToolBarUI.this.setBorderToNormal(c);
        }

        public void focusGained(FocusEvent evt) {
            Component c = evt.getComponent();
            QuaquaToolBarUI.this.focusedCompIndex = QuaquaToolBarUI.this.toolBar.getComponentIndex(c);
        }

        public void focusLost(FocusEvent evt) {
        }

        public void mousePressed(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = false;
            QuaquaToolBarUI.this.dragWindowOffset = null;
        }

        public void mouseReleased(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point position = evt.getPoint();
                if (this.origin == null) {
                    this.origin = evt.getComponent().getLocationOnScreen();
                }
                QuaquaToolBarUI.this.floatAt(position, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
            QuaquaToolBarUI.this.dragWindowOffset = null;
        }

        public void mouseDragged(MouseEvent evt) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point position = evt.getPoint();
            if (this.origin == null) {
                this.origin = evt.getComponent().getLocationOnScreen();
            }
            QuaquaToolBarUI.this.dragTo(position, this.origin);
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (propertyName != null && propertyName.equals("Frame.active")) {
                QuaquaToolBarUI.this.toolBar.repaint();
            } else if (propertyName != null && propertyName.equals("lookAndFeel")) {
                QuaquaToolBarUI.this.toolBar.updateUI();
            } else if (propertyName != null && propertyName.equals("orientation")) {
                Component[] components = QuaquaToolBarUI.this.toolBar.getComponents();
                int orientation = (Integer)evt.getNewValue();
                for (int i = 0; i < components.length; ++i) {
                    if (!(components[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)components[i];
                    if (orientation == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension size = separator.getSeparatorSize();
                    if (size == null || size.width == size.height) continue;
                    Dimension newSize = new Dimension(size.height, size.width);
                    separator.setSeparatorSize(newSize);
                }
            } else if (propertyName != null && propertyName.equals(QuaquaToolBarUI.IS_ROLLOVER)) {
                QuaquaToolBarUI.this.installNormalBorders(QuaquaToolBarUI.this.toolBar);
                QuaquaToolBarUI.this.setRolloverBorders((Boolean)evt.getNewValue());
            }
        }
    }
}

